/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.ProcessRunner;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ForeignExe {
    @Nullable
    private String pathToExe;
    private String versionFlag = "--version";
    private Pattern versionRegex = Pattern.compile("version (\\S*)");
    @Nullable
    private String fixCantFind;
    @Nullable
    private String fixWrongVersion;
    private String name;
    private String version;

    public static ForeignExe nameAndVersion(String exeName, String version) {
        ForeignExe foreign = new ForeignExe();
        foreign.name = Objects.requireNonNull(exeName);
        foreign.version = Objects.requireNonNull(version);
        return foreign;
    }

    public ForeignExe versionFlag(String versionFlag) {
        this.versionFlag = Objects.requireNonNull(versionFlag);
        return this;
    }

    public ForeignExe versionRegex(Pattern versionRegex) {
        this.versionRegex = Objects.requireNonNull(versionRegex);
        return this;
    }

    public ForeignExe fixCantFind(String msg) {
        this.fixCantFind = msg;
        return this;
    }

    public ForeignExe fixWrongVersion(String msg) {
        this.fixWrongVersion = msg;
        return this;
    }

    public ForeignExe pathToExe(@Nullable String pathToExe) {
        this.pathToExe = pathToExe;
        return this;
    }

    public String confirmVersionAndGetAbsolutePath() throws IOException, InterruptedException {
        try (ProcessRunner runner = new ProcessRunner();){
            String exeAbsPath;
            if (this.pathToExe != null) {
                exeAbsPath = this.pathToExe;
            } else {
                ProcessRunner.Result cmdWhich = runner.shellWinUnix("where " + this.name, "which " + this.name);
                if (cmdWhich.exitNotZero()) {
                    throw this.cantFind("Unable to find " + this.name + " on path", cmdWhich);
                }
                exeAbsPath = cmdWhich.assertExitZero(Charset.defaultCharset()).trim();
            }
            ProcessRunner.Result cmdVersion = runner.exec(exeAbsPath, this.versionFlag);
            if (cmdVersion.exitNotZero()) {
                throw this.cantFind("Unable to run " + exeAbsPath, cmdVersion);
            }
            Matcher versionMatcher = this.versionRegex.matcher(cmdVersion.assertExitZero(Charset.defaultCharset()));
            if (!versionMatcher.find()) {
                throw this.cantFind("Unable to parse version with /" + String.valueOf(this.versionRegex) + "/", cmdVersion);
            }
            String versionFound = versionMatcher.group(1);
            if (!versionFound.equals(this.version)) {
                throw this.wrongVersion("You specified version " + this.version + ", but Spotless found " + versionFound, cmdVersion, versionFound);
            }
            String string = exeAbsPath;
            return string;
        }
    }

    private RuntimeException cantFind(String message, ProcessRunner.Result cmd) {
        return this.exceptionFmt(message, cmd, this.fixCantFind == null ? null : this.fixCantFind.replace("{version}", this.version));
    }

    private RuntimeException wrongVersion(String message, ProcessRunner.Result cmd, String versionFound) {
        return this.exceptionFmt(message, cmd, this.fixWrongVersion == null ? null : this.fixWrongVersion.replace("{version}", this.version).replace("{versionFound}", versionFound));
    }

    private RuntimeException exceptionFmt(String msgPrimary, ProcessRunner.Result cmd, @Nullable String msgFix) {
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append(msgPrimary);
        errorMsg.append('\n');
        if (msgFix != null) {
            errorMsg.append(msgFix);
            errorMsg.append('\n');
        }
        errorMsg.append(cmd.toString());
        return new RuntimeException(errorMsg.toString());
    }
}

