/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.ProcessRunner;
import com.diffplug.spotless.npm.NodeServerLayout;
import com.diffplug.spotless.npm.NpmFormatterStepLocations;
import com.diffplug.spotless.npm.NpmLongRunningProcess;
import com.diffplug.spotless.npm.NpmProcess;
import com.diffplug.spotless.npm.NpmProcessFactory;
import com.diffplug.spotless.npm.ShadowCopy;
import com.diffplug.spotless.npm.StandardNpmProcessFactory;
import com.diffplug.spotless.npm.TimedLogger;
import java.io.File;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeModulesCachingNpmProcessFactory
implements NpmProcessFactory {
    private static final Logger logger = LoggerFactory.getLogger(NodeModulesCachingNpmProcessFactory.class);
    private static final TimedLogger timedLogger = TimedLogger.forLogger(logger);
    private final File cacheDir;
    private final ShadowCopy shadowCopy;

    private NodeModulesCachingNpmProcessFactory(@Nonnull File cacheDir) {
        this.cacheDir = Objects.requireNonNull(cacheDir);
        this.assertDir(cacheDir);
        this.shadowCopy = new ShadowCopy(cacheDir);
    }

    private void assertDir(File cacheDir) {
        if (cacheDir.exists() && !cacheDir.isDirectory()) {
            throw new IllegalArgumentException("Cache dir must be a directory");
        }
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            throw new IllegalArgumentException("Cache dir could not be created.");
        }
    }

    public static NodeModulesCachingNpmProcessFactory create(@Nonnull File cacheDir) {
        return new NodeModulesCachingNpmProcessFactory(cacheDir);
    }

    @Override
    public NpmProcess createNpmInstallProcess(NodeServerLayout nodeServerLayout, NpmFormatterStepLocations formatterStepLocations, NpmProcessFactory.OnlinePreferrence onlinePreferrence) {
        NpmProcess actualNpmInstallProcess = StandardNpmProcessFactory.INSTANCE.createNpmInstallProcess(nodeServerLayout, formatterStepLocations, onlinePreferrence);
        return new CachingNmpInstall(actualNpmInstallProcess, nodeServerLayout);
    }

    @Override
    public NpmLongRunningProcess createNpmServeProcess(NodeServerLayout nodeServerLayout, NpmFormatterStepLocations formatterStepLocations) {
        return StandardNpmProcessFactory.INSTANCE.createNpmServeProcess(nodeServerLayout, formatterStepLocations);
    }

    private class CachedResult
    extends ProcessRunner.Result {
        public CachedResult() {
            super(List.of("(from cache dir " + String.valueOf(NodeModulesCachingNpmProcessFactory.this.cacheDir) + ")"), 0, new byte[0], new byte[0]);
        }
    }

    private class CachingNmpInstall
    implements NpmProcess {
        private final NpmProcess actualNpmInstallProcess;
        private final NodeServerLayout nodeServerLayout;

        public CachingNmpInstall(NpmProcess actualNpmInstallProcess, NodeServerLayout nodeServerLayout) {
            this.actualNpmInstallProcess = actualNpmInstallProcess;
            this.nodeServerLayout = nodeServerLayout;
        }

        @Override
        public ProcessRunner.Result waitFor() {
            String entryName = this.entryName();
            if (NodeModulesCachingNpmProcessFactory.this.shadowCopy.entryExists(entryName, "node_modules")) {
                timedLogger.withInfo("Using cached node_modules for {} from {}", entryName, NodeModulesCachingNpmProcessFactory.this.cacheDir).run(() -> NodeModulesCachingNpmProcessFactory.this.shadowCopy.copyEntryInto(this.entryName(), "node_modules", this.nodeServerLayout.nodeModulesDir()));
                return new CachedResult();
            }
            ProcessRunner.Result result = timedLogger.withInfo("calling actual npm install {}", this.actualNpmInstallProcess.describe()).call(this.actualNpmInstallProcess::waitFor);
            assert (result.exitCode() == 0);
            this.storeShadowCopy(entryName);
            return result;
        }

        private void storeShadowCopy(String entryName) {
            timedLogger.withInfo("Caching node_modules for {} in {}", entryName, NodeModulesCachingNpmProcessFactory.this.cacheDir).run(() -> NodeModulesCachingNpmProcessFactory.this.shadowCopy.addEntry(this.entryName(), new File(this.nodeServerLayout.nodeModulesDir(), "node_modules")));
        }

        private String entryName() {
            return this.nodeServerLayout.nodeModulesDir().getName();
        }

        @Override
        public String describe() {
            return String.format("Wrapper around [%s] to cache node_modules in [%s]", this.actualNpmInstallProcess.describe(), NodeModulesCachingNpmProcessFactory.this.cacheDir.getAbsolutePath());
        }
    }
}

