/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.npm.NpmResourceHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ShadowCopy {
    private static final Logger logger = LoggerFactory.getLogger(ShadowCopy.class);
    private final File shadowCopyRoot;

    public ShadowCopy(@Nonnull File shadowCopyRoot) {
        this.shadowCopyRoot = shadowCopyRoot;
        if (!shadowCopyRoot.isDirectory()) {
            throw new IllegalArgumentException("Shadow copy root must be a directory: " + String.valueOf(shadowCopyRoot));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(String key, File orig) {
        if (!this.reserveSubFolder(key)) {
            logger.debug("Shadow copy entry already in progress: {}. Awaiting finalization.", (Object)key);
            try {
                NpmResourceHelper.awaitFileDeleted(this.markerFilePath(key).toFile(), Duration.ofSeconds(120L));
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.storeEntry(key, orig);
        }
        finally {
            this.cleanupReservation(key);
        }
    }

    public File getEntry(String key, String fileName) {
        return this.entry(key, fileName);
    }

    private void storeEntry(String key, File orig) {
        File target = this.entry(key, orig.getName());
        if (target.exists()) {
            logger.debug("Shadow copy entry already exists: {}", (Object)key);
            ThrowingEx.run(() -> Files.walkFileTree(target.toPath(), new DeleteDirectoryRecursively()));
        }
        ThrowingEx.run(() -> Files.walkFileTree(orig.toPath(), new CopyDirectoryRecursively(target, orig)));
    }

    private void cleanupReservation(String key) {
        ThrowingEx.run(() -> Files.delete(this.markerFilePath(key)));
    }

    private Path markerFilePath(String key) {
        return Paths.get(this.shadowCopyRoot.getAbsolutePath(), key + ".marker");
    }

    private File entry(String key, String origName) {
        return Paths.get(this.shadowCopyRoot.getAbsolutePath(), key, origName).toFile();
    }

    private boolean reserveSubFolder(String key) {
        try {
            Files.createFile(Paths.get(this.shadowCopyRoot.getAbsolutePath(), key + ".marker"), new FileAttribute[0]);
            return true;
        }
        catch (FileAlreadyExistsException e) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File copyEntryInto(String key, String origName, File targetParentFolder) {
        File target = Paths.get(targetParentFolder.getAbsolutePath(), origName).toFile();
        if (target.exists()) {
            logger.warn("Shadow copy destination already exists, deleting! {}: {}", (Object)key, (Object)target);
            ThrowingEx.run(() -> Files.walkFileTree(target.toPath(), new DeleteDirectoryRecursively()));
        }
        ThrowingEx.run(() -> Files.walkFileTree(this.entry(key, origName).toPath(), new CopyDirectoryRecursively(target, this.entry(key, origName))));
        return target;
    }

    public boolean entryExists(String key, String origName) {
        return this.entry(key, origName).exists();
    }

    private static class DeleteDirectoryRecursively
    extends SimpleFileVisitor<Path> {
        private DeleteDirectoryRecursively() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return super.visitFile(file, attrs);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.delete(dir);
            return super.postVisitDirectory(dir, exc);
        }
    }

    private static class CopyDirectoryRecursively
    extends SimpleFileVisitor<Path> {
        private final File target;
        private final File orig;
        private boolean tryHardLink = true;

        public CopyDirectoryRecursively(File target, File orig) {
            this.target = target;
            this.orig = orig;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Files.createDirectories(this.target.toPath().resolve(this.orig.toPath().relativize(dir)), new FileAttribute[0]);
            return super.preVisitDirectory(dir, attrs);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.tryHardLink) {
                try {
                    Files.createLink(this.target.toPath().resolve(this.orig.toPath().relativize(file)), file);
                    return super.visitFile(file, attrs);
                }
                catch (SecurityException | UnsupportedOperationException | FileSystemException e) {
                    logger.debug("Shadow copy entry does not support hard links: {}. Switching to 'copy'.", (Object)file, (Object)e);
                    this.tryHardLink = false;
                }
                catch (IOException e) {
                    logger.debug("Shadow copy entry failed to create hard link: {}. Switching to 'copy'.", (Object)file, (Object)e);
                    this.tryHardLink = false;
                }
            }
            Files.copy(file, this.target.toPath().resolve(this.orig.toPath().relativize(file)), new CopyOption[0]);
            return super.visitFile(file, attrs);
        }
    }
}

