/*
 * This file is part of ViaVersion - https://github.com/ViaVersion/ViaVersion
 * Copyright (C) 2016-2024 ViaVersion and contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.viaversion.viaversion.scheduler;

import com.viaversion.viaversion.api.scheduler.Task;
import com.viaversion.viaversion.api.scheduler.TaskStatus;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class ScheduledTask implements Task {

    private final ScheduledFuture<?> future;

    public ScheduledTask(final ScheduledFuture<?> future) {
        this.future = future;
    }

    @Override
    public TaskStatus status() {
        if (future.getDelay(TimeUnit.MILLISECONDS) > 0) {
            return TaskStatus.SCHEDULED;
        }
        return future.isDone() ? TaskStatus.STOPPED : TaskStatus.RUNNING;
    }

    @Override
    public void cancel() {
        future.cancel(false);
    }
}
