/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.map;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MapCursor {
    private byte x;
    private byte y;
    private byte direction;
    private byte type;
    private boolean visible;
    private Component caption;

    @Deprecated
    public MapCursor(byte x, byte y, byte direction, byte type, boolean visible) {
        this(x, y, direction, type, visible, (String)null);
    }

    public MapCursor(byte x, byte y, byte direction, @NotNull Type type, boolean visible) {
        this(x, y, direction, type, visible, (String)null);
    }

    @Deprecated
    public MapCursor(byte x, byte y, byte direction, byte type, boolean visible, @Nullable String caption) {
        this.x = x;
        this.y = y;
        this.setDirection(direction);
        this.setRawType(type);
        this.visible = visible;
        this.caption = caption == null ? null : LegacyComponentSerializer.legacySection().deserialize(caption);
    }

    @Deprecated
    public MapCursor(byte x, byte y, byte direction, byte type, boolean visible, @Nullable Component caption) {
        this.x = x;
        this.y = y;
        this.visible = visible;
        this.caption = caption;
        this.setDirection(direction);
        this.setRawType(type);
    }

    public MapCursor(byte x, byte y, byte direction, @NotNull Type type, boolean visible, @Nullable Component caption) {
        this.x = x;
        this.y = y;
        this.visible = visible;
        this.caption = caption;
        this.setDirection(direction);
        this.setType(type);
    }

    public MapCursor(byte x, byte y, byte direction, @NotNull Type type, boolean visible, @Nullable String caption) {
        this.x = x;
        this.y = y;
        this.setDirection(direction);
        this.setType(type);
        this.visible = visible;
        this.caption = caption == null ? null : LegacyComponentSerializer.legacySection().deserialize(caption);
    }

    public byte getX() {
        return this.x;
    }

    public byte getY() {
        return this.y;
    }

    public byte getDirection() {
        return this.direction;
    }

    @NotNull
    public Type getType() {
        return Type.byValue(this.type);
    }

    @ApiStatus.Internal
    public byte getRawType() {
        return this.type;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setX(byte x) {
        this.x = x;
    }

    public void setY(byte y) {
        this.y = y;
    }

    public void setDirection(byte direction) {
        if (direction < 0 || direction > 15) {
            throw new IllegalArgumentException("Direction must be in the range 0-15");
        }
        this.direction = direction;
    }

    public void setType(@NotNull Type type) {
        this.setRawType(type.value);
    }

    @Deprecated(forRemoval=true, since="1.20.2")
    public void setRawType(byte type) {
        if (type < 0 || type > 26) {
            throw new IllegalArgumentException("Type must be in the range 0-26");
        }
        this.type = type;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public @Nullable Component caption() {
        return this.caption;
    }

    public void caption(@Nullable Component caption) {
        this.caption = caption;
    }

    @Deprecated
    @Nullable
    public String getCaption() {
        return this.caption == null ? null : LegacyComponentSerializer.legacySection().serialize(this.caption);
    }

    @Deprecated
    public void setCaption(@Nullable String caption) {
        this.caption = caption == null ? null : LegacyComponentSerializer.legacySection().deserialize(caption);
    }

    public static enum Type {
        WHITE_POINTER(0),
        GREEN_POINTER(1),
        RED_POINTER(2),
        BLUE_POINTER(3),
        WHITE_CROSS(4),
        RED_MARKER(5),
        WHITE_CIRCLE(6),
        SMALL_WHITE_CIRCLE(7),
        MANSION(8),
        TEMPLE(9),
        BANNER_WHITE(10),
        BANNER_ORANGE(11),
        BANNER_MAGENTA(12),
        BANNER_LIGHT_BLUE(13),
        BANNER_YELLOW(14),
        BANNER_LIME(15),
        BANNER_PINK(16),
        BANNER_GRAY(17),
        BANNER_LIGHT_GRAY(18),
        BANNER_CYAN(19),
        BANNER_PURPLE(20),
        BANNER_BLUE(21),
        BANNER_BROWN(22),
        BANNER_GREEN(23),
        BANNER_RED(24),
        BANNER_BLACK(25),
        RED_X(26),
        DESERT_VILLAGE(27),
        PLAINS_VILLAGE(28),
        SAVANNA_VILLAGE(29),
        SNOWY_VILLAGE(30),
        TAIGA_VILLAGE(31),
        JUNGLE_TEMPLE(32),
        SWAMP_HUT(33);

        private byte value;

        private Type(int value) {
            this.value = (byte)value;
        }

        @ApiStatus.Internal
        public byte getValue() {
            return this.value;
        }

        @ApiStatus.Internal
        @Nullable
        public static Type byValue(byte value) {
            for (Type t : Type.values()) {
                if (t.value != value) continue;
                return t;
            }
            return null;
        }
    }
}

