package com.destroystokyo.paper.event.entity;

import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/**
 * Fired any time an entity is being added to the world for any reason (including a chunk loading).
 * <p>
 * Not to be confused with {@link CreatureSpawnEvent}
 */
public class EntityAddToWorldEvent extends EntityEvent {

    private static final HandlerList HANDLER_LIST = new HandlerList();

    @NotNull private final World world;

    @ApiStatus.Internal
    public EntityAddToWorldEvent(@NotNull Entity entity, @NotNull World world) {
        super(entity);
        this.world = world;
    }

    /**
     * @return The world that the entity is being added to
     */
    @NotNull
    public World getWorld() {
        return this.world;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}
