package com.destroystokyo.paper.event.entity;

import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/**
 * Fired when an entity transforms into another entity
 * <p>
 * If the event is cancelled, the entity will not transform
 *
 * @deprecated Bukkit has added {@link org.bukkit.event.entity.EntityTransformEvent}, you should start using that
 */
@Deprecated(forRemoval = true) @ApiStatus.ScheduledForRemoval(inVersion = "1.21")
public class EntityTransformedEvent extends EntityEvent implements Cancellable {

    private static final HandlerList HANDLER_LIST = new HandlerList();

    private final Entity transformed;
    private final TransformedReason reason;

    private boolean cancelled;

    @ApiStatus.Internal
    public EntityTransformedEvent(@NotNull Entity entity, @NotNull Entity transformed, @NotNull TransformedReason reason) {
        super(entity);
        this.transformed = transformed;
        this.reason = reason;
    }

    /**
     * The entity after it has transformed
     *
     * @return Transformed entity
     */
    @NotNull
    public Entity getTransformed() {
        return this.transformed;
    }

    /**
     * @return The reason for the transformation
     */
    @NotNull
    public TransformedReason getReason() {
        return this.reason;
    }

    @Override
    public boolean isCancelled(){
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel){
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers(){
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList(){
        return HANDLER_LIST;
    }

    public enum TransformedReason {
        /**
         * When a zombie drowns
         */
        DROWNED,
        /**
         * When a zombie villager is cured
         */
        CURED,
        /**
         * When a villager turns to a zombie villager
         */
        INFECTED,
        /**
         * When a mooshroom turns to a cow
         */
        SHEARED,
        /**
         * When a pig turns to a zombified piglin
         */
        LIGHTNING
    }
}
