package com.destroystokyo.paper.event.entity;

import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityTransformEvent;

import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/**
 * Fired when lightning strikes an entity
 */
public class EntityZapEvent extends EntityTransformEvent implements Cancellable {

    private static final HandlerList HANDLER_LIST = new HandlerList();

    @NotNull private final LightningStrike bolt;
    private boolean cancelled;

    @ApiStatus.Internal
    public EntityZapEvent(@NotNull final Entity entity, @NotNull final LightningStrike bolt, @NotNull final Entity replacementEntity) {
        super(entity, Collections.singletonList(replacementEntity), TransformReason.LIGHTNING);
        this.bolt = bolt;
    }

    /**
     * Gets the lightning bolt that is striking the entity.
     *
     * @return The lightning bolt responsible for this event
     */
    @NotNull
    public LightningStrike getBolt() {
        return this.bolt;
    }

    /**
     * Gets the entity that will replace the struck entity.
     *
     * @return The entity that will replace the struck entity
     */
    @NotNull
    public Entity getReplacementEntity() {
        return super.getTransformedEntity();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @NotNull
    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}
