package com.destroystokyo.paper.event.entity;

import com.google.common.collect.ImmutableList;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * Event called when a player gets close to a skeleton horse and triggers the lightning trap
 */
public class SkeletonHorseTrapEvent extends EntityEvent implements Cancellable {

    private static final HandlerList HANDLER_LIST = new HandlerList();

    private final List<HumanEntity> eligibleHumans;
    private boolean cancelled;

    @Deprecated
    @ApiStatus.Internal
    public SkeletonHorseTrapEvent(@NotNull SkeletonHorse horse) {
        this(horse, ImmutableList.of());
    }

    @ApiStatus.Internal
    public SkeletonHorseTrapEvent(@NotNull SkeletonHorse horse, @NotNull List<HumanEntity> eligibleHumans) {
        super(horse);
        this.eligibleHumans = eligibleHumans;
    }

    @NotNull
    @Override
    public SkeletonHorse getEntity() {
        return (SkeletonHorse) super.getEntity();
    }

    @NotNull
    public List<HumanEntity> getEligibleHumans() {
        return this.eligibleHumans;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @NotNull
    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

