package io.papermc.paper.command.brigadier;

import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/**
 * Implementing this interface allows for easily creating "Bukkit-style" {@code String[] args} commands.
 * The implementation handles converting the command to a representation compatible with Brigadier on registration, usually in the form of {@literal /commandlabel <greedy_string>}.
 */
@ApiStatus.Experimental
@FunctionalInterface
public interface BasicCommand {

    /**
     * Executes the command with the given {@link CommandSourceStack} and arguments.
     *
     * @param commandSourceStack the commandSourceStack of the command
     * @param args the arguments of the command ignoring repeated spaces
     */
    @ApiStatus.OverrideOnly
    void execute(@NotNull CommandSourceStack commandSourceStack, @NotNull String[] args);

    /**
     * Suggests possible completions for the given command {@link CommandSourceStack} and arguments.
     *
     * @param commandSourceStack the commandSourceStack of the command
     * @param args the arguments of the command including repeated spaces
     * @return a collection of suggestions
     */
    @ApiStatus.OverrideOnly
    default @NotNull Collection<String> suggest(final @NotNull CommandSourceStack commandSourceStack, final @NotNull String[] args) {
        return Collections.emptyList();
    }
}
