package io.papermc.paper.command.brigadier;

import com.mojang.brigadier.Message;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

/**
 * A component serializer for converting between {@link Message} and {@link Component}.
 */
@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface MessageComponentSerializer extends ComponentSerializer<Component, Component, Message> {

    /**
     * A component serializer for converting between {@link Message} and {@link Component}.
     *
     * @return serializer instance
     */
    static @NotNull MessageComponentSerializer message() {
        return MessageComponentSerializerHolder.PROVIDER.orElseThrow();
    }
}
