package io.papermc.paper.inventory.tooltip;

import org.jetbrains.annotations.NotNull;

record TooltipContextImpl(boolean isCreative, boolean isAdvanced) implements TooltipContext {

    @Override
    public @NotNull TooltipContext asCreative() {
        return new TooltipContextImpl(true, this.isAdvanced);
    }

    @Override
    public @NotNull TooltipContext asAdvanced() {
        return new TooltipContextImpl(this.isCreative, true);
    }
}
