package org.bukkit.inventory;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@DefaultQualifier(NonNull.class)
record EmptyRecipeChoice() implements RecipeChoice {

    static final RecipeChoice INSTANCE = new EmptyRecipeChoice();
    @Override
    public ItemStack getItemStack() {
        throw new UnsupportedOperationException("This is an empty RecipeChoice");
    }

    @SuppressWarnings("MethodDoesntCallSuperMethod")
    @Override
    public RecipeChoice clone() {
        return this;
    }

    @Override
    public boolean test(final ItemStack itemStack) {
        return false;
    }

    @Override
    public RecipeChoice validate(final boolean allowEmptyRecipes) {
        if (allowEmptyRecipes) return this;
        throw new IllegalArgumentException("empty RecipeChoice isn't allowed here");
    }
}
