/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity;

import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.Title;
import com.destroystokyo.paper.network.NetworkClient;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import io.papermc.paper.entity.LookAnchor;
import io.papermc.paper.math.Position;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.bossbar.BossBarViewer;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.resource.ResourcePackInfo;
import net.kyori.adventure.resource.ResourcePackInfoLike;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.resource.ResourcePackRequestLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.util.TriState;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.WeatherType;
import org.bukkit.WorldBorder;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.conversations.Conversable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageRecipient;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;

public interface Player
extends HumanEntity,
Conversable,
OfflinePlayer,
PluginMessageRecipient,
Identified,
BossBarViewer,
NetworkClient {
    default public @NotNull Identity identity() {
        return Identity.identity((UUID)this.getUniqueId());
    }

    public @UnmodifiableView @NotNull Iterable<? extends BossBar> activeBossBars();

    public @NotNull Component displayName();

    public void displayName(@Nullable Component var1);

    @Override
    @NotNull
    public String getName();

    @Deprecated
    @NotNull
    public String getDisplayName();

    @Deprecated
    public void setDisplayName(@Nullable String var1);

    public void playerListName(@Nullable Component var1);

    public @NotNull Component playerListName();

    public @Nullable Component playerListHeader();

    public @Nullable Component playerListFooter();

    @Deprecated
    @NotNull
    public String getPlayerListName();

    @Deprecated
    public void setPlayerListName(@Nullable String var1);

    @Deprecated
    @Nullable
    public String getPlayerListHeader();

    @Deprecated
    @Nullable
    public String getPlayerListFooter();

    @Deprecated
    public void setPlayerListHeader(@Nullable String var1);

    @Deprecated
    public void setPlayerListFooter(@Nullable String var1);

    @Deprecated
    public void setPlayerListHeaderFooter(@Nullable String var1, @Nullable String var2);

    public void setCompassTarget(@NotNull Location var1);

    @NotNull
    public Location getCompassTarget();

    @Override
    @Nullable
    public InetSocketAddress getAddress();

    @Nullable
    public InetSocketAddress getHAProxyAddress();

    public boolean isTransferred();

    @NotNull
    @ApiStatus.Experimental
    public CompletableFuture<byte[]> retrieveCookie(@NotNull NamespacedKey var1);

    @ApiStatus.Experimental
    public void storeCookie(@NotNull NamespacedKey var1, @NotNull byte[] var2);

    @ApiStatus.Experimental
    public void transfer(@NotNull String var1, int var2);

    @Override
    public void sendRawMessage(@NotNull String var1);

    @Deprecated
    public void kickPlayer(@Nullable String var1);

    public void kick();

    public void kick(@Nullable Component var1);

    public void kick(@Nullable Component var1,  @NotNull PlayerKickEvent.Cause var2);

    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E ban(@Nullable String var1, @Nullable Date var2, @Nullable String var3, boolean var4);

    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E ban(@Nullable String var1, @Nullable Instant var2, @Nullable String var3, boolean var4);

    @Nullable
    public <E extends BanEntry<? super PlayerProfile>> E ban(@Nullable String var1, @Nullable Duration var2, @Nullable String var3, boolean var4);

    @Nullable
    public BanEntry<InetAddress> banIp(@Nullable String var1, @Nullable Date var2, @Nullable String var3, boolean var4);

    @Nullable
    public BanEntry<InetAddress> banIp(@Nullable String var1, @Nullable Instant var2, @Nullable String var3, boolean var4);

    @Nullable
    public BanEntry<InetAddress> banIp(@Nullable String var1, @Nullable Duration var2, @Nullable String var3, boolean var4);

    public void chat(@NotNull String var1);

    public boolean performCommand(@NotNull String var1);

    @Override
    @Deprecated
    public boolean isOnGround();

    @Override
    public boolean isSneaking();

    @Override
    public void setSneaking(boolean var1);

    public boolean isSprinting();

    public void setSprinting(boolean var1);

    public void saveData();

    public void loadData();

    public void setSleepingIgnored(boolean var1);

    public boolean isSleepingIgnored();

    @Override
    @Deprecated
    @Nullable
    public Location getBedSpawnLocation();

    @Override
    @Nullable
    public Location getRespawnLocation();

    @Deprecated
    public void setBedSpawnLocation(@Nullable Location var1);

    public void setRespawnLocation(@Nullable Location var1);

    @Deprecated
    public void setBedSpawnLocation(@Nullable Location var1, boolean var2);

    public void setRespawnLocation(@Nullable Location var1, boolean var2);

    @Deprecated
    public void playNote(@NotNull Location var1, byte var2, byte var3);

    public void playNote(@NotNull Location var1, @NotNull Instrument var2, @NotNull Note var3);

    public void playSound(@NotNull Location var1, @NotNull Sound var2, float var3, float var4);

    public void playSound(@NotNull Location var1, @NotNull String var2, float var3, float var4);

    public void playSound(@NotNull Location var1, @NotNull Sound var2, @NotNull SoundCategory var3, float var4, float var5);

    public void playSound(@NotNull Location var1, @NotNull String var2, @NotNull SoundCategory var3, float var4, float var5);

    public void playSound(@NotNull Location var1, @NotNull Sound var2, @NotNull SoundCategory var3, float var4, float var5, long var6);

    public void playSound(@NotNull Location var1, @NotNull String var2, @NotNull SoundCategory var3, float var4, float var5, long var6);

    public void playSound(@NotNull Entity var1, @NotNull Sound var2, float var3, float var4);

    public void playSound(@NotNull Entity var1, @NotNull String var2, float var3, float var4);

    public void playSound(@NotNull Entity var1, @NotNull Sound var2, @NotNull SoundCategory var3, float var4, float var5);

    public void playSound(@NotNull Entity var1, @NotNull String var2, @NotNull SoundCategory var3, float var4, float var5);

    public void playSound(@NotNull Entity var1, @NotNull Sound var2, @NotNull SoundCategory var3, float var4, float var5, long var6);

    public void playSound(@NotNull Entity var1, @NotNull String var2, @NotNull SoundCategory var3, float var4, float var5, long var6);

    public void stopSound(@NotNull Sound var1);

    public void stopSound(@NotNull String var1);

    public void stopSound(@NotNull Sound var1, @Nullable SoundCategory var2);

    public void stopSound(@NotNull String var1, @Nullable SoundCategory var2);

    public void stopSound(@NotNull SoundCategory var1);

    public void stopAllSounds();

    @Deprecated
    public void playEffect(@NotNull Location var1, @NotNull Effect var2, int var3);

    public <T> void playEffect(@NotNull Location var1, @NotNull Effect var2, @Nullable T var3);

    public boolean breakBlock(@NotNull Block var1);

    @Deprecated
    public void sendBlockChange(@NotNull Location var1, @NotNull Material var2, byte var3);

    public void sendBlockChange(@NotNull Location var1, @NotNull BlockData var2);

    public void sendBlockChanges(@NotNull Collection<BlockState> var1);

    @Deprecated
    public void sendBlockChanges(@NotNull Collection<BlockState> var1, boolean var2);

    public void sendBlockDamage(@NotNull Location var1, float var2);

    public void sendMultiBlockChange(@NotNull Map<? extends Position, BlockData> var1);

    @Deprecated
    default public void sendMultiBlockChange(@NotNull Map<? extends Position, BlockData> blockChanges, boolean suppressLightUpdates) {
        this.sendMultiBlockChange(blockChanges);
    }

    public void sendBlockDamage(@NotNull Location var1, float var2, @NotNull Entity var3);

    public void sendBlockDamage(@NotNull Location var1, float var2, int var3);

    public void sendEquipmentChange(@NotNull LivingEntity var1, @NotNull EquipmentSlot var2, @Nullable ItemStack var3);

    public void sendEquipmentChange(@NotNull LivingEntity var1, @NotNull Map<EquipmentSlot, ItemStack> var2);

    @Deprecated
    default public void sendSignChange(@NotNull Location loc, @Nullable List<? extends Component> lines) throws IllegalArgumentException {
        this.sendSignChange(loc, lines, DyeColor.BLACK);
    }

    @Deprecated
    default public void sendSignChange(@NotNull Location loc, @Nullable List<? extends Component> lines, @NotNull DyeColor dyeColor) throws IllegalArgumentException {
        this.sendSignChange(loc, lines, dyeColor, false);
    }

    @Deprecated
    default public void sendSignChange(@NotNull Location loc, @Nullable List<? extends Component> lines, boolean hasGlowingText) throws IllegalArgumentException {
        this.sendSignChange(loc, lines, DyeColor.BLACK, hasGlowingText);
    }

    @Deprecated
    public void sendSignChange(@NotNull Location var1, @Nullable List<? extends Component> var2, @NotNull DyeColor var3, boolean var4) throws IllegalArgumentException;

    @Deprecated
    public void sendSignChange(@NotNull Location var1, @Nullable String[] var2) throws IllegalArgumentException;

    @Deprecated
    public void sendSignChange(@NotNull Location var1, @Nullable String[] var2, @NotNull DyeColor var3) throws IllegalArgumentException;

    @Deprecated
    public void sendSignChange(@NotNull Location var1, @Nullable String[] var2, @NotNull DyeColor var3, boolean var4) throws IllegalArgumentException;

    @ApiStatus.Experimental
    public void sendBlockUpdate(@NotNull Location var1, @NotNull TileState var2) throws IllegalArgumentException;

    public void sendPotionEffectChange(@NotNull LivingEntity var1, @NotNull PotionEffect var2);

    public void sendPotionEffectChangeRemove(@NotNull LivingEntity var1, @NotNull PotionEffectType var2);

    public void sendMap(@NotNull MapView var1);

    public void showWinScreen();

    public boolean hasSeenWinScreen();

    public void setHasSeenWinScreen(boolean var1);

    @Deprecated(since="1.20.4")
    @Nullable
    default public BanEntry banPlayerFull(@Nullable String reason) {
        return this.banPlayerFull(reason, null, null);
    }

    @Deprecated(since="1.20.4")
    @Nullable
    default public BanEntry banPlayerFull(@Nullable String reason, @Nullable String source) {
        return this.banPlayerFull(reason, null, source);
    }

    @Deprecated(since="1.20.4")
    @Nullable
    default public BanEntry banPlayerFull(@Nullable String reason, @Nullable Date expires) {
        return this.banPlayerFull(reason, expires, null);
    }

    @Deprecated(since="1.20.4")
    @Nullable
    default public BanEntry banPlayerFull(@Nullable String reason, @Nullable Date expires, @Nullable String source) {
        this.banPlayer(reason, expires, source);
        return this.banPlayerIP(reason, expires, source, true);
    }

    @Deprecated(since="1.20.4")
    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason, boolean kickPlayer) {
        return this.banPlayerIP(reason, null, null, kickPlayer);
    }

    @Deprecated(since="1.20.4")
    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason, @Nullable String source, boolean kickPlayer) {
        return this.banPlayerIP(reason, null, source, kickPlayer);
    }

    @Deprecated(since="1.20.4")
    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason, @Nullable Date expires, boolean kickPlayer) {
        return this.banPlayerIP(reason, expires, null, kickPlayer);
    }

    @Deprecated(since="1.20.4")
    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason) {
        return this.banPlayerIP(reason, null, null);
    }

    @Deprecated(since="1.20.4")
    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason, @Nullable String source) {
        return this.banPlayerIP(reason, null, source);
    }

    @Deprecated(since="1.20.4")
    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason, @Nullable Date expires) {
        return this.banPlayerIP(reason, expires, null);
    }

    @Deprecated(since="1.20.4")
    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason, @Nullable Date expires, @Nullable String source) {
        return this.banPlayerIP(reason, expires, source, true);
    }

    @Deprecated(since="1.20.4")
    @Nullable
    default public BanEntry banPlayerIP(@Nullable String reason, @Nullable Date expires, @Nullable String source, boolean kickPlayer) {
        BanEntry<String> banEntry = Bukkit.getServer().getBanList(BanList.Type.IP).addBan((String)this.getAddress().getAddress().getHostAddress(), reason, expires, source);
        if (kickPlayer && this.isOnline()) {
            this.getPlayer().kickPlayer(reason);
        }
        return banEntry;
    }

    @Deprecated
    public void sendActionBar(@NotNull String var1);

    @Deprecated
    public void sendActionBar(char var1, @NotNull String var2);

    @Deprecated
    public void sendActionBar(BaseComponent ... var1);

    @Override
    @Deprecated
    default public void sendMessage(@NotNull BaseComponent component) {
        this.spigot().sendMessage(component);
    }

    @Override
    @Deprecated
    default public void sendMessage(BaseComponent ... components) {
        this.spigot().sendMessage(components);
    }

    @Deprecated
    default public void sendMessage(ChatMessageType position, BaseComponent ... components) {
        this.spigot().sendMessage(position, components);
    }

    @Deprecated
    public void setPlayerListHeaderFooter(@Nullable BaseComponent[] var1, @Nullable BaseComponent[] var2);

    @Deprecated
    public void setPlayerListHeaderFooter(@Nullable BaseComponent var1, @Nullable BaseComponent var2);

    @Deprecated
    public void setTitleTimes(int var1, int var2, int var3);

    @Deprecated
    public void setSubtitle(BaseComponent[] var1);

    @Deprecated
    public void setSubtitle(BaseComponent var1);

    @Deprecated
    public void showTitle(@Nullable BaseComponent[] var1);

    @Deprecated
    public void showTitle(@Nullable BaseComponent var1);

    @Deprecated
    public void showTitle(@Nullable BaseComponent[] var1, @Nullable BaseComponent[] var2, int var3, int var4, int var5);

    @Deprecated
    public void showTitle(@Nullable BaseComponent var1, @Nullable BaseComponent var2, int var3, int var4, int var5);

    @Deprecated
    public void sendTitle(@NotNull Title var1);

    @Deprecated
    public void updateTitle(@NotNull Title var1);

    @Deprecated
    public void hideTitle();

    public void sendHurtAnimation(float var1);

    public void addCustomChatCompletions(@NotNull Collection<String> var1);

    public void removeCustomChatCompletions(@NotNull Collection<String> var1);

    public void setCustomChatCompletions(@NotNull Collection<String> var1);

    public void updateInventory();

    @Nullable
    public GameMode getPreviousGameMode();

    public void setPlayerTime(long var1, boolean var3);

    public long getPlayerTime();

    public long getPlayerTimeOffset();

    public boolean isPlayerTimeRelative();

    public void resetPlayerTime();

    public void setPlayerWeather(@NotNull WeatherType var1);

    @Nullable
    public WeatherType getPlayerWeather();

    public void resetPlayerWeather();

    default public void giveExp(int amount) {
        this.giveExp(amount, false);
    }

    public int getExpCooldown();

    public void setExpCooldown(int var1);

    public void giveExp(int var1, boolean var2);

    public int applyMending(int var1);

    public void giveExpLevels(int var1);

    public float getExp();

    public void setExp(float var1);

    public int getLevel();

    public void setLevel(int var1);

    public int getTotalExperience();

    public void setTotalExperience(int var1);

    public @Range(from=0L, to=0x7FFFFFFFL) int calculateTotalExperiencePoints();

    public void setExperienceLevelAndProgress(@Range(from=0L, to=0x7FFFFFFFL) int var1);

    public int getExperiencePointsNeededForNextLevel();

    public void sendExperienceChange(float var1);

    public void sendExperienceChange(float var1, int var2);

    public boolean getAllowFlight();

    public void setAllowFlight(boolean var1);

    public void setFlyingFallDamage(@NotNull TriState var1);

    @NotNull
    public TriState hasFlyingFallDamage();

    @Deprecated
    public void hidePlayer(@NotNull Player var1);

    public void hidePlayer(@NotNull Plugin var1, @NotNull Player var2);

    @Deprecated
    public void showPlayer(@NotNull Player var1);

    public void showPlayer(@NotNull Plugin var1, @NotNull Player var2);

    public boolean canSee(@NotNull Player var1);

    public void hideEntity(@NotNull Plugin var1, @NotNull Entity var2);

    public void showEntity(@NotNull Plugin var1, @NotNull Entity var2);

    public boolean canSee(@NotNull Entity var1);

    public boolean isListed(@NotNull Player var1);

    public boolean unlistPlayer(@NotNull Player var1);

    public boolean listPlayer(@NotNull Player var1);

    public boolean isFlying();

    public void setFlying(boolean var1);

    public void setFlySpeed(float var1) throws IllegalArgumentException;

    public void setWalkSpeed(float var1) throws IllegalArgumentException;

    public float getFlySpeed();

    public float getWalkSpeed();

    @Deprecated
    public void setTexturePack(@NotNull String var1);

    @Deprecated
    public void setResourcePack(@NotNull String var1);

    @Deprecated
    public void setResourcePack(@NotNull String var1, @Nullable byte[] var2);

    @Deprecated
    public void setResourcePack(@NotNull String var1, @Nullable byte[] var2, @Nullable String var3);

    default public void setResourcePack(@NotNull String url, byte @Nullable [] hash, @Nullable Component prompt) {
        this.setResourcePack(url, hash, prompt, false);
    }

    @Deprecated
    public void setResourcePack(@NotNull String var1, @Nullable byte[] var2, boolean var3);

    @Deprecated
    public void setResourcePack(@NotNull String var1, @Nullable byte[] var2, @Nullable String var3, boolean var4);

    default public void setResourcePack(@NotNull String url, byte @Nullable [] hash, @Nullable Component prompt, boolean force) {
        this.setResourcePack(UUID.nameUUIDFromBytes(url.getBytes(StandardCharsets.UTF_8)), url, hash, prompt, force);
    }

    @Deprecated
    public void setResourcePack(@NotNull UUID var1, @NotNull String var2, @Nullable byte[] var3, @Nullable String var4, boolean var5);

    public void setResourcePack(@NotNull UUID var1, @NotNull String var2, byte @Nullable [] var3, @Nullable Component var4, boolean var5);

    default public void setResourcePack(@NotNull String url, @NotNull String hash) {
        this.setResourcePack(url, hash, false);
    }

    default public void setResourcePack(@NotNull String url, @NotNull String hash, boolean required) {
        this.setResourcePack(url, hash, required, null);
    }

    default public void setResourcePack(@NotNull String url, @NotNull String hash, boolean required, @Nullable Component resourcePackPrompt) {
        this.setResourcePack(UUID.nameUUIDFromBytes(url.getBytes(StandardCharsets.UTF_8)), url, hash, resourcePackPrompt, required);
    }

    default public void setResourcePack(@NotNull UUID uuid, @NotNull String url, @NotNull String hash, @Nullable Component resourcePackPrompt, boolean required) {
        this.sendResourcePacks((ResourcePackRequestLike)ResourcePackRequest.resourcePackRequest().required(required).replace(true).prompt(resourcePackPrompt).packs((ResourcePackInfoLike)ResourcePackInfo.resourcePackInfo((UUID)uuid, (URI)URI.create(url), (String)hash), new ResourcePackInfoLike[0]));
    }

    public  @Nullable PlayerResourcePackStatusEvent.Status getResourcePackStatus();

    @Deprecated(forRemoval=true, since="1.13.2")
    @Contract(value="-> null")
    @Nullable
    default public String getResourcePackHash() {
        return null;
    }

    default public boolean hasResourcePack() {
        return this.getResourcePackStatus() == PlayerResourcePackStatusEvent.Status.SUCCESSFULLY_LOADED;
    }

    public void addResourcePack(@NotNull UUID var1, @NotNull String var2, @Nullable byte[] var3, @Nullable String var4, boolean var5);

    public void removeResourcePack(@NotNull UUID var1);

    public void removeResourcePacks();

    @NotNull
    public Scoreboard getScoreboard();

    public void setScoreboard(@NotNull Scoreboard var1) throws IllegalArgumentException, IllegalStateException;

    @Nullable
    public WorldBorder getWorldBorder();

    public void setWorldBorder(@Nullable WorldBorder var1);

    public void sendHealthUpdate(double var1, int var3, float var4);

    public void sendHealthUpdate();

    public boolean isHealthScaled();

    public void setHealthScaled(boolean var1);

    public void setHealthScale(double var1) throws IllegalArgumentException;

    public double getHealthScale();

    @Nullable
    public Entity getSpectatorTarget();

    public void setSpectatorTarget(@Nullable Entity var1);

    @Deprecated
    public void sendTitle(@Nullable String var1, @Nullable String var2);

    @Deprecated
    public void sendTitle(@Nullable String var1, @Nullable String var2, int var3, int var4, int var5);

    public void resetTitle();

    public void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3);

    public void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8);

    public <T> void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, @Nullable T var4);

    public <T> void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, @Nullable T var9);

    public void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, double var4, double var6, double var8);

    public void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13);

    public <T> void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, double var4, double var6, double var8, @Nullable T var10);

    public <T> void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, @Nullable T var15);

    public void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, double var4, double var6, double var8, double var10);

    public void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, double var15);

    public <T> void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, double var4, double var6, double var8, double var10, @Nullable T var12);

    public <T> void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, double var15, @Nullable T var17);

    public <T> void spawnParticle(@NotNull Particle var1, @NotNull Location var2, int var3, double var4, double var6, double var8, double var10, @Nullable T var12, boolean var13);

    public <T> void spawnParticle(@NotNull Particle var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, double var15, @Nullable T var17, boolean var18);

    @NotNull
    public AdvancementProgress getAdvancementProgress(@NotNull Advancement var1);

    public int getClientViewDistance();

    @NotNull
    public Locale locale();

    public int getPing();

    @Deprecated
    @NotNull
    public String getLocale();

    public boolean getAffectsSpawning();

    public void setAffectsSpawning(boolean var1);

    public int getViewDistance();

    public void setViewDistance(int var1);

    public int getSimulationDistance();

    public void setSimulationDistance(int var1);

    @Deprecated
    default public int getNoTickViewDistance() {
        return this.getViewDistance();
    }

    @Deprecated
    default public void setNoTickViewDistance(int viewDistance) {
        this.setViewDistance(viewDistance);
    }

    public int getSendViewDistance();

    public void setSendViewDistance(int var1);

    public void updateCommands();

    public void openBook(@NotNull ItemStack var1);

    @Override
    @Deprecated
    public void openSign(@NotNull Sign var1);

    @Override
    public void openSign(@NotNull Sign var1, @NotNull Side var2);

    public void showDemoScreen();

    public boolean isAllowingServerListings();

    @Override
    @NotNull
    default public HoverEvent<HoverEvent.ShowEntity> asHoverEvent(@NotNull UnaryOperator<HoverEvent.ShowEntity> op) {
        return HoverEvent.showEntity((HoverEvent.ShowEntity)((HoverEvent.ShowEntity)op.apply(HoverEvent.ShowEntity.of((Key)this.getType().getKey(), (UUID)this.getUniqueId(), (Component)this.displayName()))));
    }

    @Override
    public @NotNull PlayerProfile getPlayerProfile();

    public void setPlayerProfile(@NotNull PlayerProfile var1);

    public float getCooldownPeriod();

    public float getCooledAttackStrength(float var1);

    public void resetCooldown();

    @NotNull
    public <T> T getClientOption(@NotNull ClientOption<T> var1);

    @Nullable
    default public Firework boostElytra(@NotNull ItemStack firework) {
        Preconditions.checkState((boolean)this.isGliding(), (Object)"Player must be gliding");
        return this.fireworkBoost(firework);
    }

    public void sendOpLevel(byte var1);

    @Deprecated(since="1.20.1")
    public void addAdditionalChatCompletions(@NotNull Collection<String> var1);

    @Deprecated(since="1.20.1")
    public void removeAdditionalChatCompletions(@NotNull Collection<String> var1);

    @Nullable
    public String getClientBrandName();

    @Override
    public void setRotation(float var1, float var2);

    public void lookAt(double var1, double var3, double var5, @NotNull LookAnchor var7);

    default public void lookAt(@NotNull Position position, @NotNull LookAnchor playerAnchor) {
        this.lookAt(position.x(), position.y(), position.z(), playerAnchor);
    }

    public void lookAt(@NotNull Entity var1, @NotNull LookAnchor var2, @NotNull LookAnchor var3);

    default public void showElderGuardian() {
        this.showElderGuardian(false);
    }

    public void showElderGuardian(boolean var1);

    public int getWardenWarningCooldown();

    public void setWardenWarningCooldown(int var1);

    public int getWardenTimeSinceLastWarning();

    public void setWardenTimeSinceLastWarning(int var1);

    public int getWardenWarningLevel();

    public void setWardenWarningLevel(int var1);

    public void increaseWardenWarningLevel();

    @NotNull
    public Duration getIdleDuration();

    public void resetIdleDuration();

    @ApiStatus.Experimental
    public @NotNull @Unmodifiable Set<Long> getSentChunkKeys();

    @ApiStatus.Experimental
    public @NotNull @Unmodifiable Set<Chunk> getSentChunks();

    default public boolean isChunkSent(@NotNull Chunk chunk) {
        return this.isChunkSent(chunk.getChunkKey());
    }

    public boolean isChunkSent(long var1);

    @Override
    @NotNull
    public Spigot spigot();

    public static class Spigot
    extends Entity.Spigot {
        @NotNull
        public InetSocketAddress getRawAddress() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void respawn() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @NotNull
        public Set<Player> getHiddenPlayers() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        @Deprecated
        public void sendMessage(@NotNull BaseComponent component) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        @Deprecated
        public void sendMessage(BaseComponent ... components) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated
        public void sendMessage(@NotNull ChatMessageType position, @NotNull BaseComponent component) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated
        public void sendMessage(@NotNull ChatMessageType position, BaseComponent ... components) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated
        public void sendMessage(@NotNull ChatMessageType position, @Nullable UUID sender, @NotNull BaseComponent component) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated
        public void sendMessage(@NotNull ChatMessageType position, @Nullable UUID sender, BaseComponent ... components) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Deprecated
        public int getPing() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

