package io.papermc.paper.registry.keys;

import static net.kyori.adventure.key.Key.key;

import io.papermc.paper.generated.GeneratedFrom;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import net.kyori.adventure.key.Key;
import org.bukkit.block.Biome;
import org.jspecify.annotations.NullMarked;

/**
 * Vanilla keys for {@link RegistryKey#BIOME}.
 *
 * @apiNote The fields provided here are a direct representation of
 * what is available from the vanilla game source. They may be
 * changed (including removals) on any Minecraft version
 * bump, so cross-version compatibility is not provided on the
 * same level as it is on most of the other API.
 */
@SuppressWarnings({
        "unused",
        "SpellCheckingInspection"
})
@GeneratedFrom("1.21.4")
@NullMarked
public final class BiomeKeys {
    /**
     * {@code minecraft:badlands}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> BADLANDS = create(key("badlands"));

    /**
     * {@code minecraft:bamboo_jungle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> BAMBOO_JUNGLE = create(key("bamboo_jungle"));

    /**
     * {@code minecraft:basalt_deltas}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> BASALT_DELTAS = create(key("basalt_deltas"));

    /**
     * {@code minecraft:beach}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> BEACH = create(key("beach"));

    /**
     * {@code minecraft:birch_forest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> BIRCH_FOREST = create(key("birch_forest"));

    /**
     * {@code minecraft:cherry_grove}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> CHERRY_GROVE = create(key("cherry_grove"));

    /**
     * {@code minecraft:cold_ocean}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> COLD_OCEAN = create(key("cold_ocean"));

    /**
     * {@code minecraft:crimson_forest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> CRIMSON_FOREST = create(key("crimson_forest"));

    /**
     * {@code minecraft:dark_forest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> DARK_FOREST = create(key("dark_forest"));

    /**
     * {@code minecraft:deep_cold_ocean}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> DEEP_COLD_OCEAN = create(key("deep_cold_ocean"));

    /**
     * {@code minecraft:deep_dark}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> DEEP_DARK = create(key("deep_dark"));

    /**
     * {@code minecraft:deep_frozen_ocean}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> DEEP_FROZEN_OCEAN = create(key("deep_frozen_ocean"));

    /**
     * {@code minecraft:deep_lukewarm_ocean}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> DEEP_LUKEWARM_OCEAN = create(key("deep_lukewarm_ocean"));

    /**
     * {@code minecraft:deep_ocean}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> DEEP_OCEAN = create(key("deep_ocean"));

    /**
     * {@code minecraft:desert}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> DESERT = create(key("desert"));

    /**
     * {@code minecraft:dripstone_caves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> DRIPSTONE_CAVES = create(key("dripstone_caves"));

    /**
     * {@code minecraft:end_barrens}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> END_BARRENS = create(key("end_barrens"));

    /**
     * {@code minecraft:end_highlands}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> END_HIGHLANDS = create(key("end_highlands"));

    /**
     * {@code minecraft:end_midlands}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> END_MIDLANDS = create(key("end_midlands"));

    /**
     * {@code minecraft:eroded_badlands}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> ERODED_BADLANDS = create(key("eroded_badlands"));

    /**
     * {@code minecraft:flower_forest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> FLOWER_FOREST = create(key("flower_forest"));

    /**
     * {@code minecraft:forest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> FOREST = create(key("forest"));

    /**
     * {@code minecraft:frozen_ocean}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> FROZEN_OCEAN = create(key("frozen_ocean"));

    /**
     * {@code minecraft:frozen_peaks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> FROZEN_PEAKS = create(key("frozen_peaks"));

    /**
     * {@code minecraft:frozen_river}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> FROZEN_RIVER = create(key("frozen_river"));

    /**
     * {@code minecraft:grove}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> GROVE = create(key("grove"));

    /**
     * {@code minecraft:ice_spikes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> ICE_SPIKES = create(key("ice_spikes"));

    /**
     * {@code minecraft:jagged_peaks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> JAGGED_PEAKS = create(key("jagged_peaks"));

    /**
     * {@code minecraft:jungle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> JUNGLE = create(key("jungle"));

    /**
     * {@code minecraft:lukewarm_ocean}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> LUKEWARM_OCEAN = create(key("lukewarm_ocean"));

    /**
     * {@code minecraft:lush_caves}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> LUSH_CAVES = create(key("lush_caves"));

    /**
     * {@code minecraft:mangrove_swamp}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> MANGROVE_SWAMP = create(key("mangrove_swamp"));

    /**
     * {@code minecraft:meadow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> MEADOW = create(key("meadow"));

    /**
     * {@code minecraft:mushroom_fields}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> MUSHROOM_FIELDS = create(key("mushroom_fields"));

    /**
     * {@code minecraft:nether_wastes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> NETHER_WASTES = create(key("nether_wastes"));

    /**
     * {@code minecraft:ocean}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> OCEAN = create(key("ocean"));

    /**
     * {@code minecraft:old_growth_birch_forest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> OLD_GROWTH_BIRCH_FOREST = create(key("old_growth_birch_forest"));

    /**
     * {@code minecraft:old_growth_pine_taiga}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> OLD_GROWTH_PINE_TAIGA = create(key("old_growth_pine_taiga"));

    /**
     * {@code minecraft:old_growth_spruce_taiga}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> OLD_GROWTH_SPRUCE_TAIGA = create(key("old_growth_spruce_taiga"));

    /**
     * {@code minecraft:pale_garden}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> PALE_GARDEN = create(key("pale_garden"));

    /**
     * {@code minecraft:plains}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> PLAINS = create(key("plains"));

    /**
     * {@code minecraft:river}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> RIVER = create(key("river"));

    /**
     * {@code minecraft:savanna}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> SAVANNA = create(key("savanna"));

    /**
     * {@code minecraft:savanna_plateau}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> SAVANNA_PLATEAU = create(key("savanna_plateau"));

    /**
     * {@code minecraft:small_end_islands}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> SMALL_END_ISLANDS = create(key("small_end_islands"));

    /**
     * {@code minecraft:snowy_beach}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> SNOWY_BEACH = create(key("snowy_beach"));

    /**
     * {@code minecraft:snowy_plains}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> SNOWY_PLAINS = create(key("snowy_plains"));

    /**
     * {@code minecraft:snowy_slopes}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> SNOWY_SLOPES = create(key("snowy_slopes"));

    /**
     * {@code minecraft:snowy_taiga}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> SNOWY_TAIGA = create(key("snowy_taiga"));

    /**
     * {@code minecraft:soul_sand_valley}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> SOUL_SAND_VALLEY = create(key("soul_sand_valley"));

    /**
     * {@code minecraft:sparse_jungle}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> SPARSE_JUNGLE = create(key("sparse_jungle"));

    /**
     * {@code minecraft:stony_peaks}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> STONY_PEAKS = create(key("stony_peaks"));

    /**
     * {@code minecraft:stony_shore}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> STONY_SHORE = create(key("stony_shore"));

    /**
     * {@code minecraft:sunflower_plains}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> SUNFLOWER_PLAINS = create(key("sunflower_plains"));

    /**
     * {@code minecraft:swamp}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> SWAMP = create(key("swamp"));

    /**
     * {@code minecraft:taiga}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> TAIGA = create(key("taiga"));

    /**
     * {@code minecraft:the_end}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> THE_END = create(key("the_end"));

    /**
     * {@code minecraft:the_void}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> THE_VOID = create(key("the_void"));

    /**
     * {@code minecraft:warm_ocean}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> WARM_OCEAN = create(key("warm_ocean"));

    /**
     * {@code minecraft:warped_forest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> WARPED_FOREST = create(key("warped_forest"));

    /**
     * {@code minecraft:windswept_forest}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> WINDSWEPT_FOREST = create(key("windswept_forest"));

    /**
     * {@code minecraft:windswept_gravelly_hills}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> WINDSWEPT_GRAVELLY_HILLS = create(key("windswept_gravelly_hills"));

    /**
     * {@code minecraft:windswept_hills}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> WINDSWEPT_HILLS = create(key("windswept_hills"));

    /**
     * {@code minecraft:windswept_savanna}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> WINDSWEPT_SAVANNA = create(key("windswept_savanna"));

    /**
     * {@code minecraft:wooded_badlands}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<Biome> WOODED_BADLANDS = create(key("wooded_badlands"));

    private BiomeKeys() {
    }

    /**
     * Creates a key for {@link Biome} in the registry {@code minecraft:worldgen/biome}.
     *
     * @param key the value's key in the registry
     * @return a new typed key
     */
    public static TypedKey<Biome> create(final Key key) {
        return TypedKey.create(RegistryKey.BIOME, key);
    }
}
