package io.papermc.paper.registry.keys;

import static net.kyori.adventure.key.Key.key;

import io.papermc.paper.generated.GeneratedFrom;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import net.kyori.adventure.key.Key;
import org.bukkit.map.MapCursor;
import org.jspecify.annotations.NullMarked;

/**
 * Vanilla keys for {@link RegistryKey#MAP_DECORATION_TYPE}.
 *
 * @apiNote The fields provided here are a direct representation of
 * what is available from the vanilla game source. They may be
 * changed (including removals) on any Minecraft version
 * bump, so cross-version compatibility is not provided on the
 * same level as it is on most of the other API.
 */
@SuppressWarnings({
        "unused",
        "SpellCheckingInspection"
})
@GeneratedFrom("1.21.4")
@NullMarked
public final class MapDecorationTypeKeys {
    /**
     * {@code minecraft:banner_black}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_BLACK = create(key("banner_black"));

    /**
     * {@code minecraft:banner_blue}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_BLUE = create(key("banner_blue"));

    /**
     * {@code minecraft:banner_brown}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_BROWN = create(key("banner_brown"));

    /**
     * {@code minecraft:banner_cyan}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_CYAN = create(key("banner_cyan"));

    /**
     * {@code minecraft:banner_gray}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_GRAY = create(key("banner_gray"));

    /**
     * {@code minecraft:banner_green}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_GREEN = create(key("banner_green"));

    /**
     * {@code minecraft:banner_light_blue}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_LIGHT_BLUE = create(key("banner_light_blue"));

    /**
     * {@code minecraft:banner_light_gray}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_LIGHT_GRAY = create(key("banner_light_gray"));

    /**
     * {@code minecraft:banner_lime}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_LIME = create(key("banner_lime"));

    /**
     * {@code minecraft:banner_magenta}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_MAGENTA = create(key("banner_magenta"));

    /**
     * {@code minecraft:banner_orange}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_ORANGE = create(key("banner_orange"));

    /**
     * {@code minecraft:banner_pink}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_PINK = create(key("banner_pink"));

    /**
     * {@code minecraft:banner_purple}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_PURPLE = create(key("banner_purple"));

    /**
     * {@code minecraft:banner_red}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_RED = create(key("banner_red"));

    /**
     * {@code minecraft:banner_white}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_WHITE = create(key("banner_white"));

    /**
     * {@code minecraft:banner_yellow}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BANNER_YELLOW = create(key("banner_yellow"));

    /**
     * {@code minecraft:blue_marker}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> BLUE_MARKER = create(key("blue_marker"));

    /**
     * {@code minecraft:frame}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> FRAME = create(key("frame"));

    /**
     * {@code minecraft:jungle_temple}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> JUNGLE_TEMPLE = create(key("jungle_temple"));

    /**
     * {@code minecraft:mansion}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> MANSION = create(key("mansion"));

    /**
     * {@code minecraft:monument}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> MONUMENT = create(key("monument"));

    /**
     * {@code minecraft:player}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> PLAYER = create(key("player"));

    /**
     * {@code minecraft:player_off_limits}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> PLAYER_OFF_LIMITS = create(key("player_off_limits"));

    /**
     * {@code minecraft:player_off_map}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> PLAYER_OFF_MAP = create(key("player_off_map"));

    /**
     * {@code minecraft:red_marker}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> RED_MARKER = create(key("red_marker"));

    /**
     * {@code minecraft:red_x}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> RED_X = create(key("red_x"));

    /**
     * {@code minecraft:swamp_hut}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> SWAMP_HUT = create(key("swamp_hut"));

    /**
     * {@code minecraft:target_point}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> TARGET_POINT = create(key("target_point"));

    /**
     * {@code minecraft:target_x}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> TARGET_X = create(key("target_x"));

    /**
     * {@code minecraft:trial_chambers}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> TRIAL_CHAMBERS = create(key("trial_chambers"));

    /**
     * {@code minecraft:village_desert}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> VILLAGE_DESERT = create(key("village_desert"));

    /**
     * {@code minecraft:village_plains}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> VILLAGE_PLAINS = create(key("village_plains"));

    /**
     * {@code minecraft:village_savanna}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> VILLAGE_SAVANNA = create(key("village_savanna"));

    /**
     * {@code minecraft:village_snowy}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> VILLAGE_SNOWY = create(key("village_snowy"));

    /**
     * {@code minecraft:village_taiga}
     *
     * @apiNote This field is version-dependant and may be removed in future Minecraft versions
     */
    public static final TypedKey<MapCursor.Type> VILLAGE_TAIGA = create(key("village_taiga"));

    private MapDecorationTypeKeys() {
    }

    private static TypedKey<MapCursor.Type> create(final Key key) {
        return TypedKey.create(RegistryKey.MAP_DECORATION_TYPE, key);
    }
}
