/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.api.tasks.options.Option;
import paper.libs.org.jetbrains.annotations.NotNull;

@UntrackedTask(because="Always copy files")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lio/papermc/paperweight/tasks/CreateDiffOutput;", "Lio/papermc/paperweight/tasks/BaseTask;", "()V", "baseDir", "Lorg/gradle/api/file/DirectoryProperty;", "getBaseDir", "()Lorg/gradle/api/file/DirectoryProperty;", "inputDir", "getInputDir", "outputDir", "getOutputDir", "target", "Lorg/gradle/api/provider/Property;", "", "getTarget", "()Lorg/gradle/api/provider/Property;", "init", "", "run", "paperweight-lib"})
public abstract class CreateDiffOutput
extends BaseTask {
    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getInputDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Internal
    @NotNull
    public abstract DirectoryProperty getBaseDir();

    @Internal
    @Option(option="target", description="Directory name of the diff output")
    @NotNull
    public abstract Property<String> getTarget();

    @Override
    public void init() {
        this.getBaseDir().convention(UtilsKt.cacheDir(this.getLayout(), "paperweight/diff"));
        this.getOutputDir().convention(this.getBaseDir().flatMap(new Transformer(this){
            final /* synthetic */ CreateDiffOutput this$0;
            {
                this.this$0 = $receiver;
            }

            public final Provider<? extends Directory> transform(Directory it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.dir((Provider)this.this$0.getTarget());
            }
        }));
    }

    @TaskAction
    public final void run() {
        Path output = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputDir()));
        FileKt.deleteRecursive$default(output, null, null, 3, null);
        FileKt.copyRecursivelyTo(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputDir())), output);
    }
}

