/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.JavaLauncherZippedTask;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.FileSystemReference;
import io.papermc.paperweight.util.HashingAlgorithm;
import io.papermc.paperweight.util.NioKt;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.data.FileEntry;
import io.papermc.paperweight.util.data.LibraryChange;
import io.papermc.paperweight.util.data.ModuleId;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.gradle.api.Action;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import paper.libs.com.github.salomonbrys.kotson.GsonBuilderKt;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.reflect.TypeToken;
import paper.libs.io.sigpipe.jbsdiff.Diff;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0006,-./01B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016JD\u0010\"\u001a\u00020#*\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001c2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030(2\u0006\u0010*\u001a\u00020+H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006R\u0014\u0010\u0014\u001a\u00020\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00062"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar;", "Lio/papermc/paperweight/tasks/JavaLauncherZippedTask;", "()V", "bundlerJar", "Lorg/gradle/api/file/RegularFileProperty;", "getBundlerJar", "()Lorg/gradle/api/file/RegularFileProperty;", "jvmargs", "Lorg/gradle/api/provider/ListProperty;", "", "getJvmargs", "()Lorg/gradle/api/provider/ListProperty;", "libraryChangesJson", "getLibraryChangesJson", "mcVersion", "Lorg/gradle/api/provider/Property;", "getMcVersion", "()Lorg/gradle/api/provider/Property;", "originalBundlerJar", "getOriginalBundlerJar", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "createPatches", "", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$PatchEntry;", "rootDir", "Ljava/nio/file/Path;", "newBundlerRoot", "originalBundlerRoot", "init", "", "run", "submitPatchJob", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$PatchJob;", "Lorg/gradle/workers/WorkQueue;", "originalRoot", "newRoot", "originalEntry", "Lio/papermc/paperweight/util/data/FileEntry;", "newEntry", "location", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "DownloadContext", "EntryLocation", "PaperclipAction", "PaperclipParameters", "PatchEntry", "PatchJob", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nCreatePaperclipJar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreatePaperclipJar.kt\nio/papermc/paperweight/tasks/CreatePaperclipJar\n+ 2 utils.kt\nio/papermc/paperweight/util/UtilsKt\n+ 3 Gson.kt\ncom/github/salomonbrys/kotson/GsonKt\n+ 4 GsonBuilder.kt\ncom/github/salomonbrys/kotson/GsonBuilderKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 GradleApiKotlinDslExtensions_913w5ajggwmo37gebhdmau77q.kt\norg/gradle/kotlin/dsl/GradleApiKotlinDslExtensions_913w5ajggwmo37gebhdmau77qKt\n*L\n1#1,324:1\n97#2,2:325\n99#2:334\n100#2:342\n17#3:327\n19#3:336\n61#4:328\n13#4:329\n63#4,4:330\n13#4:337\n63#4,4:338\n1#5:335\n295#6,2:343\n295#6,2:345\n295#6,2:347\n295#6,2:349\n1557#6:351\n1628#6,3:352\n41#7:355\n*S KotlinDebug\n*F\n+ 1 CreatePaperclipJar.kt\nio/papermc/paperweight/tasks/CreatePaperclipJar\n*L\n119#1:325,2\n119#1:334\n119#1:342\n119#1:327\n119#1:336\n119#1:328\n119#1:329\n119#1:330,4\n119#1:337\n119#1:338,4\n119#1:335\n127#1:343,2\n140#1:345,2\n156#1:347,2\n158#1:349,2\n167#1:351\n167#1:352,3\n205#1:355\n*E\n"})
public abstract class CreatePaperclipJar
extends JavaLauncherZippedTask {
    @Classpath
    @NotNull
    public abstract RegularFileProperty getOriginalBundlerJar();

    @Classpath
    @NotNull
    public abstract RegularFileProperty getBundlerJar();

    @Input
    @NotNull
    public abstract Property<String> getMcVersion();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getLibraryChangesJson();

    @Internal
    @NotNull
    public abstract ListProperty<String> getJvmargs();

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @Override
    public void init() {
        super.init();
        this.getJvmargs().convention((Iterable)CollectionsKt.listOf((Object)"-Xmx1G"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(@NotNull Path rootDir) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        List<PatchEntry> patchEntries = null;
        Object object = NioKt.openZipSafe(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getBundlerJar())));
        Object object2 = null;
        try {
            FileSystemReference newBundlerFs = (FileSystemReference)object;
            boolean bl = false;
            AutoCloseable autoCloseable = NioKt.openZipSafe(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOriginalBundlerJar())));
            Throwable throwable = null;
            try {
                FileSystemReference originalBundlerFs = (FileSystemReference)autoCloseable;
                boolean bl2 = false;
                Path originalBundlerRoot = originalBundlerFs.getPath("/");
                Path newBundlerRoot = newBundlerFs.getPath("/");
                patchEntries = this.createPatches(rootDir, newBundlerRoot, originalBundlerRoot);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            newBundlerFs = Unit.INSTANCE;
        }
        catch (Throwable newBundlerFs) {
            object2 = newBundlerFs;
            throw newBundlerFs;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)object2);
        }
        Path path = rootDir.resolve("META-INF/patches.list");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"rootDir.resolve(PatchEntry.PATCHES_LIST)");
        object = path;
        OpenOption[] bl = new OpenOption[]{};
        object2 = Charsets.UTF_8;
        int newBundlerFs = 8192;
        object = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(bl, bl.length)), (Charset)object2), newBundlerFs);
        object2 = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl3 = false;
            for (PatchEntry entry : patchEntries) {
                writer.append(entry.toString()).append('\n');
            }
            writer = Unit.INSTANCE;
        }
        catch (Throwable writer) {
            object2 = writer;
            throw writer;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        Path originalJar = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOriginalBundlerJar()));
        String vanillaSha256Hash = FileKt.sha256asHex(originalJar);
        String vanillaSha1Hash = UtilsKt.asHexString(FileKt.hashFile(originalJar, HashingAlgorithm.SHA1));
        String vanillaUrl = "https://piston-data.mojang.com/v1/objects/" + vanillaSha1Hash + "/server.jar";
        String vanillaFileName = "mojang_" + this.getMcVersion().get() + ".jar";
        DownloadContext context = new DownloadContext(vanillaSha256Hash, vanillaUrl, vanillaFileName);
        Path path2 = rootDir.resolve("META-INF/download-context");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"rootDir.resolve(DownloadContext.FILE)");
        PathsKt.writeText$default((Path)path2, (CharSequence)context.toString(), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<PatchEntry> createPatches(Path rootDir, Path newBundlerRoot, Path originalBundlerRoot) {
        void $this$mapTo$iv$iv;
        Iterable originalLibrary;
        Object element$iv2;
        FileEntry it;
        Iterable $this$firstOrNull$iv;
        Object object;
        WorkQueue queue2 = this.getWorkerExecutor().processIsolation(new Action(this){
            final /* synthetic */ CreatePaperclipJar this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(ProcessWorkerSpec $this$processIsolation) {
                Intrinsics.checkNotNullParameter((Object)$this$processIsolation, (String)"$this$processIsolation");
                $this$processIsolation.getForkOptions().jvmArgs((Iterable)this.this$0.getJvmargs().get());
                JavaForkOptions javaForkOptions = $this$processIsolation.getForkOptions();
                RegularFile regularFile = ((JavaLauncher)this.this$0.getLauncher().get()).getExecutablePath();
                Intrinsics.checkNotNullExpressionValue((Object)regularFile, (String)"launcher.get().executablePath");
                javaForkOptions.executable((Object)((Object)FileKt.getPath((FileSystemLocation)regularFile).toAbsolutePath()).toString());
            }
        });
        List patchJobs = new ArrayList();
        Path path = originalBundlerRoot.resolve("META-INF/versions.list");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"originalBundlerRoot.reso\u2026(FileEntry.VERSIONS_LIST)");
        List<FileEntry<String>> originalVersions = FileEntry.Companion.parse(path);
        Path path2 = originalBundlerRoot.resolve("META-INF/libraries.list");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"originalBundlerRoot.reso\u2026FileEntry.LIBRARIES_LIST)");
        List originalLibraries2 = FileEntry.Companion.parse(path2, (Function1)new Function1<String, ModuleId>((Object)ModuleId.Companion){

            public final ModuleId invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ModuleId.Companion)this.receiver).parse(p0);
            }
        });
        FileKt.copyRecursivelyTo(newBundlerRoot, rootDir);
        Gson gson = UtilsKt.getGson();
        RegularFileProperty any$iv = this.getLibraryChangesJson();
        boolean $i$f$fromJson = false;
        if (any$iv instanceof String) {
            Type type;
            void var12_12 = $this$fromJson$iv;
            Object object2 = json$iv$iv = (String)any$iv;
            void var15_28 = var12_12;
            Type type2 = new TypeToken<List<? extends LibraryChange>>(){}.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {} .type");
            Type type$iv$iv$iv = type2;
            if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                Type type3 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                type = type3;
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
            } else {
                type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv);
            }
            var17_37 = type;
            Object t = var15_28.fromJson((String)object2, (Type)((Object)var17_37));
            object = t;
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
        } else {
            Path path3 = UtilsKt.convertToPath(any$iv);
            json$iv$iv = Charsets.UTF_8;
            OpenOption[] openOptionArray = new OpenOption[]{};
            int n = 8192;
            Closeable closeable = new BufferedReader(new InputStreamReader(Files.newInputStream(path3, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)json$iv$iv), n);
            json$iv$iv = null;
            try {
                Type type;
                BufferedReader it$iv = (BufferedReader)closeable;
                boolean bl = false;
                void $receiver$iv$iv = $this$fromJson$iv;
                var17_37 = it$iv;
                void $i$f$gsonTypeToken = $receiver$iv$iv;
                Type type4 = new TypeToken<List<? extends LibraryChange>>(){}.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"object : TypeToken<T>() {} .type");
                Type type$iv$iv$iv = type4;
                if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                    Type type5 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                    type = type5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"type.rawType");
                } else {
                    type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv);
                }
                Type $i$f$fromJson2 = type;
                Object t = $i$f$gsonTypeToken.fromJson((Reader)((Object)var17_37), $i$f$fromJson2);
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
                it$iv = t;
                object = it$iv;
            }
            catch (Throwable it$iv) {
                json$iv$iv = it$iv;
                throw it$iv;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)json$iv$iv);
            }
        }
        List libraryChanges = (List)object;
        Path path4 = newBundlerRoot.resolve("META-INF/versions.list");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"newBundlerRoot.resolve(FileEntry.VERSIONS_LIST)");
        List<FileEntry<String>> newVersions = FileEntry.Companion.parse(path4);
        Path path5 = newBundlerRoot.resolve("META-INF/libraries.list");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"newBundlerRoot.resolve(FileEntry.LIBRARIES_LIST)");
        List newLibraries2 = FileEntry.Companion.parse(path5, (Function1)new Function1<String, ModuleId>((Object)ModuleId.Companion){

            public final ModuleId invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ModuleId.Companion)this.receiver).parse(p0);
            }
        });
        for (FileEntry<String> fileEntry : newVersions) {
            FileEntry originalVersion;
            Object v13;
            block25: {
                $this$firstOrNull$iv = originalVersions;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    it = (FileEntry)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getId(), (Object)fileEntry.getId())) continue;
                    v13 = element$iv2;
                    break block25;
                }
                v13 = null;
            }
            if ((FileEntry)v13 == null) continue;
            if (Intrinsics.areEqual((Object)fileEntry.getHash(), (Object)originalVersion.getHash())) {
                EntryLocation.VERSION.removeEntry(rootDir, fileEntry.getPath());
                continue;
            }
            Collection collection = patchJobs;
            Intrinsics.checkNotNullExpressionValue((Object)queue2, (String)"queue");
            collection.add(this.submitPatchJob(queue2, rootDir, originalBundlerRoot, newBundlerRoot, originalVersion, fileEntry, EntryLocation.VERSION));
        }
        for (FileEntry<String> fileEntry : newLibraries2) {
            Object v15;
            block26: {
                $this$firstOrNull$iv = originalLibraries2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    it = (FileEntry)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getId(), (Object)fileEntry.getId())) continue;
                    v15 = element$iv2;
                    break block26;
                }
                v15 = null;
            }
            if ((FileEntry)v15 == null) continue;
            if (!Intrinsics.areEqual((Object)fileEntry.getPath(), (Object)((FileEntry)((Object)originalLibrary)).getPath()) && Intrinsics.areEqual((Object)fileEntry.getHash(), (Object)((FileEntry)((Object)originalLibrary)).getHash())) {
                throw new PaperweightException("Paperclip cannot currently handle non-patch libraries with new paths");
            }
            if (!Intrinsics.areEqual((Object)fileEntry.getHash(), (Object)((FileEntry)((Object)originalLibrary)).getHash())) {
                Collection collection = patchJobs;
                Intrinsics.checkNotNullExpressionValue((Object)queue2, (String)"queue");
                collection.add(this.submitPatchJob(queue2, rootDir, originalBundlerRoot, newBundlerRoot, (FileEntry<?>)((Object)originalLibrary), fileEntry, EntryLocation.LIBRARY));
                continue;
            }
            EntryLocation.LIBRARY.removeEntry(rootDir, fileEntry.getPath());
        }
        for (LibraryChange libraryChange : libraryChanges) {
            FileEntry newLibrary;
            Object v18;
            block28: {
                Object v17;
                block27: {
                    $this$firstOrNull$iv = originalLibraries2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        it = (FileEntry)element$iv2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getId(), (Object)libraryChange.getInputId())) continue;
                        v17 = element$iv2;
                        break block27;
                    }
                    v17 = null;
                }
                if ((FileEntry)v17 == null) {
                    throw new PaperweightException("Unmatched library change, original id: " + libraryChange.getInputId());
                }
                Iterable $this$firstOrNull$iv2 = newLibraries2;
                boolean $i$f$firstOrNull = false;
                element$iv2 = $this$firstOrNull$iv2.iterator();
                while (element$iv2.hasNext()) {
                    Object element$iv3 = element$iv2.next();
                    FileEntry it2 = (FileEntry)element$iv3;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it2.getId(), (Object)libraryChange.getOutputId())) continue;
                    v18 = element$iv3;
                    break block28;
                }
                v18 = null;
            }
            if ((FileEntry)v18 == null) {
                throw new PaperweightException("Unmatched library change, new id: " + libraryChange.getOutputId());
            }
            Collection collection = patchJobs;
            Intrinsics.checkNotNullExpressionValue((Object)queue2, (String)"queue");
            collection.add(this.submitPatchJob(queue2, rootDir, originalBundlerRoot, newBundlerRoot, (FileEntry<?>)((Object)originalLibrary), newLibrary, EntryLocation.LIBRARY));
        }
        queue2.await();
        Iterable $this$map$iv = patchJobs;
        boolean bl = false;
        originalLibrary = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void job;
            element$iv2 = (PatchJob)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Path patchLocation = EntryLocation.resolve$default(job.getEntryLocation(), rootDir, null, 2, null);
            String patchHash = FileKt.sha256asHex(job.getPatchFile());
            collection.add(new PatchEntry(job.getEntryLocation(), job.getOriginalEntry().getHash(), patchHash, job.getNewEntry().getHash(), job.getOriginalEntry().getPath(), PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)job.getPatchFile(), (Path)patchLocation)), job.getNewEntry().getPath()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final PatchJob submitPatchJob(WorkQueue $this$submitPatchJob, Path rootDir, Path originalRoot, Path newRoot, FileEntry<?> originalEntry, FileEntry<?> newEntry, EntryLocation location) {
        void workActionClass$iv;
        void $this$submit$iv;
        Path outputFile = location.resolve(rootDir, newEntry.getPath());
        FileKt.deleteForcefully(outputFile);
        Path path = Paths.get(originalEntry.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(originalEntry.path)");
        Path patchFile = outputFile.resolveSibling(PathsKt.getName((Path)path) + ".patch");
        Path originalFile = location.resolve(originalRoot, originalEntry.getPath());
        Object[] objectArray = new FileAttribute[]{};
        Path path2 = null;
        Path path3 = Files.createTempFile(path2, null, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createTempFile(...)");
        Path tempOriginal = path3;
        path2 = originalFile;
        objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Object object = objectArray;
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, tempOriginal, (CopyOption[])Arrays.copyOf(object, ((Object[])object).length)), (String)"copy(...)");
        Path newFile = location.resolve(newRoot, newEntry.getPath());
        Object[] objectArray2 = new FileAttribute[]{};
        objectArray = null;
        Path path4 = Files.createTempFile((String)objectArray, null, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"createTempFile(...)");
        Path tempNew = path4;
        objectArray = newFile;
        objectArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Object[] objectArray3 = objectArray2;
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)objectArray, tempNew, (CopyOption[])Arrays.copyOf(objectArray3, objectArray3.length)), (String)"copy(...)");
        objectArray = $this$submitPatchJob;
        object = PaperclipAction.class;
        Action parameterAction$iv = new Action(tempOriginal, tempNew, patchFile){
            final /* synthetic */ Path $tempOriginal;
            final /* synthetic */ Path $tempNew;
            final /* synthetic */ Path $patchFile;
            {
                this.$tempOriginal = $tempOriginal;
                this.$tempNew = $tempNew;
                this.$patchFile = $patchFile;
            }

            public final void execute(PaperclipParameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                FileKt.set((FileSystemLocationProperty)$this$submit.getOriginalFile(), this.$tempOriginal);
                FileKt.set((FileSystemLocationProperty)$this$submit.getPatchedFile(), this.$tempNew);
                FileKt.set((FileSystemLocationProperty)$this$submit.getOutputFile(), this.$patchFile);
            }
        };
        boolean $i$f$submit = false;
        $this$submit$iv.submit((Class)workActionClass$iv, parameterAction$iv);
        Intrinsics.checkNotNullExpressionValue((Object)patchFile, (String)"patchFile");
        return new PatchJob(originalEntry, newEntry, patchFile, location);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$DownloadContext;", "", "hash", "", "url", "fileName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFileName", "()Ljava/lang/String;", "getHash", "getUrl", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "paperweight-lib"})
    public static final class DownloadContext {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String hash;
        @NotNull
        private final String url;
        @NotNull
        private final String fileName;
        @NotNull
        public static final String FILE = "META-INF/download-context";

        public DownloadContext(@NotNull String hash2, @NotNull String url, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            this.hash = hash2;
            this.url = url;
            this.fileName = fileName;
        }

        @NotNull
        public final String getHash() {
            return this.hash;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public String toString() {
            return this.hash + "\t" + this.url + "\t" + this.fileName;
        }

        @NotNull
        public final String component1() {
            return this.hash;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final String component3() {
            return this.fileName;
        }

        @NotNull
        public final DownloadContext copy(@NotNull String hash2, @NotNull String url, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return new DownloadContext(hash2, url, fileName);
        }

        public static /* synthetic */ DownloadContext copy$default(DownloadContext downloadContext, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = downloadContext.hash;
            }
            if ((n & 2) != 0) {
                string2 = downloadContext.url;
            }
            if ((n & 4) != 0) {
                string3 = downloadContext.fileName;
            }
            return downloadContext.copy(string, string2, string3);
        }

        public int hashCode() {
            int result2 = this.hash.hashCode();
            result2 = result2 * 31 + this.url.hashCode();
            result2 = result2 * 31 + this.fileName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DownloadContext)) {
                return false;
            }
            DownloadContext downloadContext = (DownloadContext)other;
            if (!Intrinsics.areEqual((Object)this.hash, (Object)downloadContext.hash)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)downloadContext.url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fileName, (Object)downloadContext.fileName);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$DownloadContext$Companion;", "", "()V", "FILE", "", "paperweight-lib"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u001c\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "removeEntry", "", "dir", "Ljava/nio/file/Path;", "path", "resolve", "VERSION", "LIBRARY", "paperweight-lib"})
    public static final abstract class EntryLocation
    extends Enum<EntryLocation> {
        @NotNull
        private final String value;
        public static final /* enum */ EntryLocation VERSION = new VERSION("VERSION", 0);
        public static final /* enum */ EntryLocation LIBRARY = new LIBRARY("LIBRARY", 1);
        private static final /* synthetic */ EntryLocation[] $VALUES;

        private EntryLocation(String value2) {
            this.value = value2;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public abstract Path resolve(@NotNull Path var1, @Nullable String var2);

        public static /* synthetic */ Path resolve$default(EntryLocation entryLocation, Path path, String string, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolve");
            }
            if ((n & 2) != 0) {
                string = null;
            }
            return entryLocation.resolve(path, string);
        }

        public final void removeEntry(@NotNull Path dir2, @NotNull String path) {
            Path path2;
            Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Path entryDir = EntryLocation.resolve$default(this, dir2, null, 2, null);
            Path file2 = entryDir.resolve(path);
            do {
                Path path3;
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || Intrinsics.areEqual((Object)file2, (Object)entryDir)) break;
                Path path4 = file2;
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"file");
                FileKt.deleteForcefully(path4);
                path2 = file2 = file2.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
            } while (!(!((Collection)PathsKt.listDirectoryEntries$default((Path)path2, null, (int)1, null)).isEmpty()));
        }

        public static EntryLocation[] values() {
            return (EntryLocation[])$VALUES.clone();
        }

        public static EntryLocation valueOf(String value2) {
            return Enum.valueOf(EntryLocation.class, value2);
        }

        public /* synthetic */ EntryLocation(String $enum$name, int $enum$ordinal, String value2, DefaultConstructorMarker $constructor_marker) {
            this(value2);
        }

        static {
            $VALUES = entryLocationArray = new EntryLocation[]{EntryLocation.VERSION, EntryLocation.LIBRARY};
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation$LIBRARY;", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "resolve", "Ljava/nio/file/Path;", "dir", "path", "", "paperweight-lib"})
        static final class LIBRARY
        extends EntryLocation {
            /*
             * WARNING - void declaration
             */
            LIBRARY() {
                void var1_1;
            }

            @Override
            @NotNull
            public Path resolve(@NotNull Path dir2, @Nullable String path) {
                Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
                Path base = dir2.resolve("META-INF/libraries");
                if (path == null) {
                    Intrinsics.checkNotNullExpressionValue((Object)base, (String)"base");
                    return base;
                }
                Path path2 = base.resolve(path);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"base.resolve(path)");
                return path2;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation$VERSION;", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "resolve", "Ljava/nio/file/Path;", "dir", "path", "", "paperweight-lib"})
        static final class VERSION
        extends EntryLocation {
            /*
             * WARNING - void declaration
             */
            VERSION() {
                void var1_1;
            }

            @Override
            @NotNull
            public Path resolve(@NotNull Path dir2, @Nullable String path) {
                Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
                Path base = dir2.resolve("META-INF/versions");
                if (path == null) {
                    Intrinsics.checkNotNullExpressionValue((Object)base, (String)"base");
                    return base;
                }
                Path path2 = base.resolve(path);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"base.resolve(path)");
                return path2;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$PaperclipAction;", "Lorg/gradle/workers/WorkAction;", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$PaperclipParameters;", "()V", "execute", "", "paperweight-lib"})
    @SourceDebugExtension(value={"SMAP\nCreatePaperclipJar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreatePaperclipJar.kt\nio/papermc/paperweight/tasks/CreatePaperclipJar$PaperclipAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n1#2:325\n*E\n"})
    public static abstract class PaperclipAction
    implements WorkAction<PaperclipParameters> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute() {
            Object $this$execute_u24lambda_u241;
            Object object2;
            Object object;
            Path outputFile = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((PaperclipParameters)this.getParameters()).getOutputFile()));
            Path originalFile = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((PaperclipParameters)this.getParameters()).getOriginalFile()));
            Path patchedFile = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((PaperclipParameters)this.getParameters()).getPatchedFile()));
            byte[] byArray2 = Files.readAllBytes(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((PaperclipParameters)this.getParameters()).getOriginalFile())));
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"readAllBytes(...)");
            byte[] originalBytes = byArray2;
            byte[] byArray3 = Files.readAllBytes(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((PaperclipParameters)this.getParameters()).getPatchedFile())));
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"readAllBytes(...)");
            byte[] patchedBytes = byArray3;
            try {
                Path path = outputFile.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputFile.parent");
                object = path;
                object2 = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(object2, ((FileAttribute[])object2).length)), (String)"createDirectories(...)");
                OpenOption[] openOptionArray = new OpenOption[]{};
                OutputStream outputStream = Files.newOutputStream(outputFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                object = outputStream;
                object2 = null;
                try {
                    OutputStream patchOutput = (OutputStream)object;
                    boolean bl = false;
                    Diff.diff(originalBytes, patchedBytes, patchOutput);
                    patchOutput = Unit.INSTANCE;
                }
                catch (Throwable patchOutput) {
                    object2 = patchOutput;
                    throw patchOutput;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                object = this;
            }
            catch (Exception e) {
                try {
                    throw new PaperweightException("Error creating patch between " + originalFile + " and " + patchedFile, e);
                }
                catch (Throwable throwable) {
                    Object object3;
                    Object $this$execute_u24lambda_u2412;
                    PaperclipAction paperclipAction = this;
                    try {
                        $this$execute_u24lambda_u2412 = paperclipAction;
                        boolean bl = false;
                        FileKt.deleteForcefully(originalFile);
                        $this$execute_u24lambda_u2412 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable bl) {
                        $this$execute_u24lambda_u2412 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    paperclipAction = this;
                    try {
                        PaperclipAction $this$execute_u24lambda_u242 = paperclipAction;
                        boolean bl = false;
                        FileKt.deleteForcefully(patchedFile);
                        object3 = Result.constructor-impl((Object)Unit.INSTANCE);
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    }
                    throw throwable;
                }
            }
            try {
                $this$execute_u24lambda_u241 = (PaperclipAction)object;
                boolean bl = false;
                FileKt.deleteForcefully(originalFile);
                $this$execute_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$execute_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = this;
            try {
                PaperclipAction $this$execute_u24lambda_u242 = (PaperclipAction)object;
                boolean bl = false;
                FileKt.deleteForcefully(patchedFile);
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                return;
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                return;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$PaperclipParameters;", "Lorg/gradle/workers/WorkParameters;", "originalFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOriginalFile", "()Lorg/gradle/api/file/RegularFileProperty;", "outputFile", "getOutputFile", "patchedFile", "getPatchedFile", "paperweight-lib"})
    public static interface PaperclipParameters
    extends WorkParameters {
        @NotNull
        public RegularFileProperty getOriginalFile();

        @NotNull
        public RegularFileProperty getPatchedFile();

        @NotNull
        public RegularFileProperty getOutputFile();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003JO\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\b\u0010\"\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006$"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$PatchEntry;", "", "location", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "originalHash", "", "patchHash", "outputHash", "originalPath", "patchPath", "outputPath", "(Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLocation", "()Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "getOriginalHash", "()Ljava/lang/String;", "getOriginalPath", "getOutputHash", "getOutputPath", "getPatchHash", "getPatchPath", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "paperweight-lib"})
    public static final class PatchEntry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final EntryLocation location;
        @NotNull
        private final String originalHash;
        @NotNull
        private final String patchHash;
        @NotNull
        private final String outputHash;
        @NotNull
        private final String originalPath;
        @NotNull
        private final String patchPath;
        @NotNull
        private final String outputPath;
        @NotNull
        public static final String PATCHES_LIST = "META-INF/patches.list";

        public PatchEntry(@NotNull EntryLocation location, @NotNull String originalHash, @NotNull String patchHash, @NotNull String outputHash, @NotNull String originalPath, @NotNull String patchPath, @NotNull String outputPath) {
            Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
            Intrinsics.checkNotNullParameter((Object)originalHash, (String)"originalHash");
            Intrinsics.checkNotNullParameter((Object)patchHash, (String)"patchHash");
            Intrinsics.checkNotNullParameter((Object)outputHash, (String)"outputHash");
            Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
            Intrinsics.checkNotNullParameter((Object)patchPath, (String)"patchPath");
            Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
            this.location = location;
            this.originalHash = originalHash;
            this.patchHash = patchHash;
            this.outputHash = outputHash;
            this.originalPath = originalPath;
            this.patchPath = patchPath;
            this.outputPath = outputPath;
        }

        @NotNull
        public final EntryLocation getLocation() {
            return this.location;
        }

        @NotNull
        public final String getOriginalHash() {
            return this.originalHash;
        }

        @NotNull
        public final String getPatchHash() {
            return this.patchHash;
        }

        @NotNull
        public final String getOutputHash() {
            return this.outputHash;
        }

        @NotNull
        public final String getOriginalPath() {
            return this.originalPath;
        }

        @NotNull
        public final String getPatchPath() {
            return this.patchPath;
        }

        @NotNull
        public final String getOutputPath() {
            return this.outputPath;
        }

        @NotNull
        public String toString() {
            StringJoiner joiner = new StringJoiner("\t");
            joiner.add(this.location.getValue());
            joiner.add(this.originalHash);
            joiner.add(this.patchHash);
            joiner.add(this.outputHash);
            joiner.add(this.originalPath);
            joiner.add(this.patchPath);
            joiner.add(this.outputPath);
            String string = joiner.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"joiner.toString()");
            return string;
        }

        @NotNull
        public final EntryLocation component1() {
            return this.location;
        }

        @NotNull
        public final String component2() {
            return this.originalHash;
        }

        @NotNull
        public final String component3() {
            return this.patchHash;
        }

        @NotNull
        public final String component4() {
            return this.outputHash;
        }

        @NotNull
        public final String component5() {
            return this.originalPath;
        }

        @NotNull
        public final String component6() {
            return this.patchPath;
        }

        @NotNull
        public final String component7() {
            return this.outputPath;
        }

        @NotNull
        public final PatchEntry copy(@NotNull EntryLocation location, @NotNull String originalHash, @NotNull String patchHash, @NotNull String outputHash, @NotNull String originalPath, @NotNull String patchPath, @NotNull String outputPath) {
            Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
            Intrinsics.checkNotNullParameter((Object)originalHash, (String)"originalHash");
            Intrinsics.checkNotNullParameter((Object)patchHash, (String)"patchHash");
            Intrinsics.checkNotNullParameter((Object)outputHash, (String)"outputHash");
            Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
            Intrinsics.checkNotNullParameter((Object)patchPath, (String)"patchPath");
            Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
            return new PatchEntry(location, originalHash, patchHash, outputHash, originalPath, patchPath, outputPath);
        }

        public static /* synthetic */ PatchEntry copy$default(PatchEntry patchEntry, EntryLocation entryLocation, String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
            if ((n & 1) != 0) {
                entryLocation = patchEntry.location;
            }
            if ((n & 2) != 0) {
                string = patchEntry.originalHash;
            }
            if ((n & 4) != 0) {
                string2 = patchEntry.patchHash;
            }
            if ((n & 8) != 0) {
                string3 = patchEntry.outputHash;
            }
            if ((n & 0x10) != 0) {
                string4 = patchEntry.originalPath;
            }
            if ((n & 0x20) != 0) {
                string5 = patchEntry.patchPath;
            }
            if ((n & 0x40) != 0) {
                string6 = patchEntry.outputPath;
            }
            return patchEntry.copy(entryLocation, string, string2, string3, string4, string5, string6);
        }

        public int hashCode() {
            int result2 = this.location.hashCode();
            result2 = result2 * 31 + this.originalHash.hashCode();
            result2 = result2 * 31 + this.patchHash.hashCode();
            result2 = result2 * 31 + this.outputHash.hashCode();
            result2 = result2 * 31 + this.originalPath.hashCode();
            result2 = result2 * 31 + this.patchPath.hashCode();
            result2 = result2 * 31 + this.outputPath.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PatchEntry)) {
                return false;
            }
            PatchEntry patchEntry = (PatchEntry)other;
            if (this.location != patchEntry.location) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.originalHash, (Object)patchEntry.originalHash)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.patchHash, (Object)patchEntry.patchHash)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.outputHash, (Object)patchEntry.outputHash)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.originalPath, (Object)patchEntry.originalPath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.patchPath, (Object)patchEntry.patchPath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.outputPath, (Object)patchEntry.outputPath);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$PatchEntry$Companion;", "", "()V", "PATCHES_LIST", "", "paperweight-lib"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\r\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\r\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J9\u0010\u0015\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$PatchJob;", "", "originalEntry", "Lio/papermc/paperweight/util/data/FileEntry;", "newEntry", "patchFile", "Ljava/nio/file/Path;", "entryLocation", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "(Lio/papermc/paperweight/util/data/FileEntry;Lio/papermc/paperweight/util/data/FileEntry;Ljava/nio/file/Path;Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;)V", "getEntryLocation", "()Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "getNewEntry", "()Lio/papermc/paperweight/util/data/FileEntry;", "getOriginalEntry", "getPatchFile", "()Ljava/nio/file/Path;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "paperweight-lib"})
    public static final class PatchJob {
        @NotNull
        private final FileEntry<?> originalEntry;
        @NotNull
        private final FileEntry<?> newEntry;
        @NotNull
        private final Path patchFile;
        @NotNull
        private final EntryLocation entryLocation;

        public PatchJob(@NotNull FileEntry<?> originalEntry, @NotNull FileEntry<?> newEntry, @NotNull Path patchFile, @NotNull EntryLocation entryLocation) {
            Intrinsics.checkNotNullParameter(originalEntry, (String)"originalEntry");
            Intrinsics.checkNotNullParameter(newEntry, (String)"newEntry");
            Intrinsics.checkNotNullParameter((Object)patchFile, (String)"patchFile");
            Intrinsics.checkNotNullParameter((Object)((Object)entryLocation), (String)"entryLocation");
            this.originalEntry = originalEntry;
            this.newEntry = newEntry;
            this.patchFile = patchFile;
            this.entryLocation = entryLocation;
        }

        @NotNull
        public final FileEntry<?> getOriginalEntry() {
            return this.originalEntry;
        }

        @NotNull
        public final FileEntry<?> getNewEntry() {
            return this.newEntry;
        }

        @NotNull
        public final Path getPatchFile() {
            return this.patchFile;
        }

        @NotNull
        public final EntryLocation getEntryLocation() {
            return this.entryLocation;
        }

        @NotNull
        public final FileEntry<?> component1() {
            return this.originalEntry;
        }

        @NotNull
        public final FileEntry<?> component2() {
            return this.newEntry;
        }

        @NotNull
        public final Path component3() {
            return this.patchFile;
        }

        @NotNull
        public final EntryLocation component4() {
            return this.entryLocation;
        }

        @NotNull
        public final PatchJob copy(@NotNull FileEntry<?> originalEntry, @NotNull FileEntry<?> newEntry, @NotNull Path patchFile, @NotNull EntryLocation entryLocation) {
            Intrinsics.checkNotNullParameter(originalEntry, (String)"originalEntry");
            Intrinsics.checkNotNullParameter(newEntry, (String)"newEntry");
            Intrinsics.checkNotNullParameter((Object)patchFile, (String)"patchFile");
            Intrinsics.checkNotNullParameter((Object)((Object)entryLocation), (String)"entryLocation");
            return new PatchJob(originalEntry, newEntry, patchFile, entryLocation);
        }

        public static /* synthetic */ PatchJob copy$default(PatchJob patchJob, FileEntry fileEntry, FileEntry fileEntry2, Path path, EntryLocation entryLocation, int n, Object object) {
            if ((n & 1) != 0) {
                fileEntry = patchJob.originalEntry;
            }
            if ((n & 2) != 0) {
                fileEntry2 = patchJob.newEntry;
            }
            if ((n & 4) != 0) {
                path = patchJob.patchFile;
            }
            if ((n & 8) != 0) {
                entryLocation = patchJob.entryLocation;
            }
            return patchJob.copy(fileEntry, fileEntry2, path, entryLocation);
        }

        @NotNull
        public String toString() {
            return "PatchJob(originalEntry=" + this.originalEntry + ", newEntry=" + this.newEntry + ", patchFile=" + this.patchFile + ", entryLocation=" + this.entryLocation + ")";
        }

        public int hashCode() {
            int result2 = this.originalEntry.hashCode();
            result2 = result2 * 31 + this.newEntry.hashCode();
            result2 = result2 * 31 + ((Object)this.patchFile).hashCode();
            result2 = result2 * 31 + this.entryLocation.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PatchJob)) {
                return false;
            }
            PatchJob patchJob = (PatchJob)other;
            if (!Intrinsics.areEqual(this.originalEntry, patchJob.originalEntry)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.newEntry, patchJob.newEntry)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.patchFile, (Object)patchJob.patchFile)) {
                return false;
            }
            return this.entryLocation == patchJob.entryLocation;
        }
    }
}

