/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.HashingAlgorithm;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lio/papermc/paperweight/tasks/IncludeMappings;", "Lio/papermc/paperweight/tasks/BaseTask;", "()V", "inputJar", "Lorg/gradle/api/file/RegularFileProperty;", "getInputJar", "()Lorg/gradle/api/file/RegularFileProperty;", "mappings", "getMappings", "mappingsDest", "Lorg/gradle/api/provider/Property;", "", "getMappingsDest", "()Lorg/gradle/api/provider/Property;", "outputJar", "getOutputJar", "addMappings", "", "init", "paperweight-lib"})
public abstract class IncludeMappings
extends BaseTask {
    @InputFile
    @NotNull
    public abstract RegularFileProperty getInputJar();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getMappings();

    @Input
    @NotNull
    public abstract Property<String> getMappingsDest();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputJar();

    @Override
    public void init() {
        super.init();
        this.getOutputJar().convention((Provider)UtilsKt.defaultOutput(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void addMappings() {
        Path path = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputJar())).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputJar.path.parent");
        Object object = path;
        Object object2 = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(object2, ((FileAttribute[])object2).length)), (String)"createDirectories(...)");
        object = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputJar()));
        object2 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputJar()));
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        CopyOption[] copyOptionArray2 = copyOptionArray;
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object, (Path)object2, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
        object = FileKt.openZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputJar())));
        object2 = null;
        try {
            FileSystem fs = (FileSystem)object;
            boolean bl = false;
            Path dest = fs.getPath((String)this.getMappingsDest().get(), new String[0]);
            Path path2 = dest.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"dest.parent");
            Path path3 = path2;
            Object object3 = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path3, Arrays.copyOf(object3, ((FileAttribute[])object3).length)), (String)"createDirectories(...)");
            path3 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getMappings()));
            Intrinsics.checkNotNullExpressionValue((Object)dest, (String)"dest");
            object3 = dest;
            CopyOption[] copyOptionArray3 = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path3, (Path)object3, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"copy(...)");
            UtilsKt.modifyManifest$default(fs, false, (Function1)new Function1<Manifest, Unit>(this){
                final /* synthetic */ IncludeMappings this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(Manifest $this$modifyManifest) {
                    Intrinsics.checkNotNullParameter((Object)$this$modifyManifest, (String)"$this$modifyManifest");
                    Attributes attributes = $this$modifyManifest.getMainAttributes();
                    String string = UtilsKt.asHexString(FileKt.hashFile(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.this$0.getMappings())), HashingAlgorithm.SHA256)).toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                    attributes.putValue("Included-Mappings-Hash", string);
                }
            }, 1, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }
}

