/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.tasks.MergeAccessTransforms;
import io.papermc.paperweight.util.AtKt;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import paper.libs.org.cadixdev.at.AccessTransformSet;
import paper.libs.org.cadixdev.at.io.AccessTransformFormat;
import paper.libs.org.cadixdev.at.io.AccessTransformFormats;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lio/papermc/paperweight/tasks/MergeAccessTransforms;", "Lio/papermc/paperweight/tasks/BaseTask;", "()V", "firstFile", "Lorg/gradle/api/file/RegularFileProperty;", "getFirstFile", "()Lorg/gradle/api/file/RegularFileProperty;", "outputFile", "getOutputFile", "secondFile", "getSecondFile", "init", "", "run", "paperweight-lib"})
public abstract class MergeAccessTransforms
extends BaseTask {
    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getFirstFile();

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getSecondFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Override
    public void init() {
        this.getOutputFile().convention((Provider)UtilsKt.defaultOutput(this, "at"));
    }

    @TaskAction
    public final void run() {
        Object[] objectArray = new Path[]{FileKt.getPathOrNull((Provider<? extends FileSystemLocation>)((Provider)this.getFirstFile())), FileKt.getPathOrNull((Provider<? extends FileSystemLocation>)((Provider)this.getSecondFile()))};
        Sequence ats2 = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray)), (Function1)run.ats.1.INSTANCE), (Function1)run.ats.2.INSTANCE);
        AccessTransformSet outputAt = AccessTransformSet.create();
        for (AccessTransformSet at : ats2) {
            outputAt.merge(at);
        }
        AccessTransformFormat accessTransformFormat = AccessTransformFormats.FML;
        Intrinsics.checkNotNullExpressionValue((Object)accessTransformFormat, (String)"FML");
        Path path = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputFile()));
        Intrinsics.checkNotNullExpressionValue((Object)outputAt, (String)"outputAt");
        AtKt.writeLF$default(accessTransformFormat, path, outputAt, null, 4, null);
    }
}

