/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.JavaLauncherTask;
import io.papermc.paperweight.tasks.TinyRemapper;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.constants.ConstantsKt;
import java.io.Closeable;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0007\u00a8\u0006!"}, d2={"Lio/papermc/paperweight/tasks/RemapJar;", "Lio/papermc/paperweight/tasks/JavaLauncherTask;", "()V", "fromNamespace", "Lorg/gradle/api/provider/Property;", "", "getFromNamespace", "()Lorg/gradle/api/provider/Property;", "inputJar", "Lorg/gradle/api/file/RegularFileProperty;", "getInputJar", "()Lorg/gradle/api/file/RegularFileProperty;", "jvmArgs", "Lorg/gradle/api/provider/ListProperty;", "getJvmArgs", "()Lorg/gradle/api/provider/ListProperty;", "mappingsFile", "getMappingsFile", "outputJar", "getOutputJar", "remapClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getRemapClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "remapper", "getRemapper", "remapperArgs", "getRemapperArgs", "toNamespace", "getToNamespace", "init", "", "run", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nRemapJar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemapJar.kt\nio/papermc/paperweight/tasks/RemapJar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n1557#2:230\n1628#2,3:231\n*S KotlinDebug\n*F\n+ 1 RemapJar.kt\nio/papermc/paperweight/tasks/RemapJar\n*L\n94#1:230\n94#1:231,3\n*E\n"})
public abstract class RemapJar
extends JavaLauncherTask {
    @Classpath
    @NotNull
    public abstract RegularFileProperty getInputJar();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getMappingsFile();

    @Input
    @NotNull
    public abstract Property<String> getFromNamespace();

    @Input
    @NotNull
    public abstract Property<String> getToNamespace();

    @CompileClasspath
    @NotNull
    public abstract ConfigurableFileCollection getRemapClasspath();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getRemapper();

    @Input
    @NotNull
    public abstract ListProperty<String> getRemapperArgs();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputJar();

    @Internal
    @NotNull
    public abstract ListProperty<String> getJvmArgs();

    @Override
    public void init() {
        super.init();
        this.getOutputJar().convention((Provider)UtilsKt.defaultOutput(this));
        this.getJvmArgs().convention((Iterable)CollectionsKt.listOf((Object)"-Xmx1G"));
        this.getRemapperArgs().convention((Iterable)TinyRemapper.createArgsList$default(TinyRemapper.INSTANCE, false, false, null, 0, false, 31, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void run() {
        Object object;
        Object object2;
        Path path = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputJar())).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        Path path2 = path.normalize();
        Path path3 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputJar())).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toAbsolutePath(...)");
        if (Intrinsics.areEqual((Object)path2, (Object)path3.normalize())) {
            throw new PaperweightException("Invalid configuration, inputJar and outputJar point to the same path: " + FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputJar())) + "\nConsider removing customization of output locations, following the default Gradle conventions.");
        }
        if (!Intrinsics.areEqual((Object)this.getToNamespace().get(), (Object)this.getFromNamespace().get())) {
            Collection<Path> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Path logFile = UtilsKt.getCache(this.getLayout()).resolve(ConstantsKt.paperTaskOutput((Task)this, "log"));
            Object object3 = this.getRemapperArgs().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"remapperArgs.get()");
            List list = (List)object3;
            Intrinsics.checkNotNullExpressionValue((Object)logFile, (String)"logFile");
            Path path4 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputJar()));
            Path path5 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getMappingsFile()));
            Object object4 = this.getFromNamespace().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"fromNamespace.get()");
            String string = (String)object4;
            Object object5 = this.getToNamespace().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"toNamespace.get()");
            String string2 = (String)object5;
            Set set = this.getRemapClasspath().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"remapClasspath.files");
            object2 = set;
            String string3 = string2;
            String string4 = string;
            Path path6 = path5;
            Path path7 = path4;
            Path path8 = logFile;
            List list2 = list;
            TinyRemapper tinyRemapper = TinyRemapper.INSTANCE;
            boolean $i$f$map = false;
            void var4_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toPath());
            }
            collection = (List)destination$iv$iv;
            FileCollection fileCollection = (FileCollection)this.getRemapper();
            Path path9 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputJar()));
            Object object6 = this.getLauncher().get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"launcher.get()");
            JavaLauncher javaLauncher = (JavaLauncher)object6;
            Path path10 = UtilsKt.getCache(this.getLayout());
            Object object7 = this.getJvmArgs().get();
            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"jvmArgs.get()");
            tinyRemapper.run(list2, path8, path7, path6, string4, string3, (List<? extends Path>)collection, fileCollection, path9, javaLauncher, path10, (List)object7);
        } else {
            FileKt.deleteForcefully(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputJar())));
            Path path11 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputJar())).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"outputJar.path.parent");
            object = path11;
            object2 = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(object2, ((FileAttribute[])object2).length)), (String)"createDirectories(...)");
            object = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputJar()));
            object2 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputJar()));
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object, (Path)object2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
        }
        object = FileKt.openZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputJar())));
        object2 = null;
        try {
            FileSystem fs = (FileSystem)object;
            boolean bl = false;
            UtilsKt.modifyManifest$default(fs, false, (Function1)new Function1<Manifest, Unit>(this){
                final /* synthetic */ RemapJar this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(Manifest $this$modifyManifest) {
                    Intrinsics.checkNotNullParameter((Object)$this$modifyManifest, (String)"$this$modifyManifest");
                    $this$modifyManifest.getMainAttributes().putValue("paperweight-mappings-namespace", (String)this.this$0.getToNamespace().get());
                }
            }, 1, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }
}

