/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import paper.libs.com.github.salomonbrys.kotson.GsonBuilderKt;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.JsonObject;
import paper.libs.com.google.gson.reflect.TypeToken;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lio/papermc/paperweight/tasks/ServerBundler;", "", "()V", "extractFromBundler", "", "bundlerJar", "Ljava/nio/file/Path;", "serverJar", "serverLibraryJars", "serverLibrariesTxt", "serverLibrariesList", "serverVersionsList", "versionJson", "extractLibraryJars", "bundlerZip", "extractServerJar", "outputVersionJson", "writeLibrariesTxt", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nExtractFromBundler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractFromBundler.kt\nio/papermc/paperweight/tasks/ServerBundler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 utils.kt\nio/papermc/paperweight/util/UtilsKt\n+ 4 Gson.kt\ncom/github/salomonbrys/kotson/GsonKt\n+ 5 GsonBuilder.kt\ncom/github/salomonbrys/kotson/GsonBuilderKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1#2:125\n1#2:136\n97#3,2:126\n99#3:135\n100#3:143\n17#4:128\n19#4:137\n61#5:129\n13#5:130\n63#5,4:131\n13#5:138\n63#5,4:139\n1557#6:144\n1628#6,3:145\n1187#6,2:148\n1261#6,4:150\n1557#6:154\n1628#6,3:155\n*S KotlinDebug\n*F\n+ 1 ExtractFromBundler.kt\nio/papermc/paperweight/tasks/ServerBundler\n*L\n100#1:136\n100#1:126,2\n100#1:135\n100#1:143\n100#1:128\n100#1:137\n100#1:129\n100#1:130\n100#1:131,4\n100#1:138\n100#1:139,4\n102#1:144\n102#1:145,3\n103#1:148,2\n103#1:150,4\n118#1:154\n118#1:155,3\n*E\n"})
public final class ServerBundler {
    @NotNull
    public static final ServerBundler INSTANCE = new ServerBundler();

    private ServerBundler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extractFromBundler(@NotNull Path bundlerJar, @NotNull Path serverJar, @NotNull Path serverLibraryJars, @Nullable Path serverLibrariesTxt, @Nullable Path serverLibrariesList, @Nullable Path serverVersionsList, @Nullable Path versionJson) {
        Intrinsics.checkNotNullParameter((Object)bundlerJar, (String)"bundlerJar");
        Intrinsics.checkNotNullParameter((Object)serverJar, (String)"serverJar");
        Intrinsics.checkNotNullParameter((Object)serverLibraryJars, (String)"serverLibraryJars");
        Closeable closeable = FileKt.openZip(bundlerJar);
        Throwable throwable = null;
        try {
            Path path;
            CopyOption[] copyOptionArray;
            CopyOption[] copyOptionArray2;
            Path path2;
            Path it;
            FileSystem bundlerFs = (FileSystem)closeable;
            boolean bl = false;
            Iterable<Path> iterable = bundlerFs.getRootDirectories();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"bundlerFs.rootDirectories");
            Path root = (Path)CollectionsKt.first(iterable);
            Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
            INSTANCE.extractServerJar(root, serverJar, versionJson);
            INSTANCE.extractLibraryJars(root, serverLibraryJars);
            Path path3 = serverLibrariesTxt;
            if (path3 != null) {
                it = path3;
                boolean bl2 = false;
                INSTANCE.writeLibrariesTxt(root, it);
            }
            Path path4 = serverLibrariesList;
            if (path4 != null) {
                it = path4;
                boolean bl3 = false;
                Path path5 = root.resolve("META-INF/libraries.list");
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"root.resolve(FileEntry.LIBRARIES_LIST)");
                path2 = path5;
                copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                copyOptionArray = copyOptionArray2;
                Path path6 = Files.copy(path2, it, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
                v5 = path6;
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"copy(...)");
            } else {
                v5 = null;
            }
            Path path7 = serverVersionsList;
            if (path7 != null) {
                it = path7;
                boolean bl4 = false;
                Path path8 = root.resolve("META-INF/versions.list");
                Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"root.resolve(FileEntry.VERSIONS_LIST)");
                path2 = path8;
                copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                copyOptionArray = copyOptionArray2;
                Path path9 = Files.copy(path2, it, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
                path = path9;
                Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"copy(...)");
            } else {
                path = null;
            }
            Path path10 = path;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void extractServerJar(Path bundlerZip, Path serverJar, Path outputVersionJson) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object type$iv$iv$iv;
        Object object;
        Object object2;
        Object $receiver$iv$iv;
        CopyOption[] copyOptionArray;
        CopyOption[] copyOptionArray2;
        Object output;
        Path serverVersionJson = bundlerZip.resolve("version.json");
        Path path = outputVersionJson;
        if (path != null) {
            output = path;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)serverVersionJson, (String)"serverVersionJson");
            Path path2 = serverVersionJson;
            copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            copyOptionArray = copyOptionArray2;
            Path path3 = Files.copy(path2, (Path)output, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
            v2 = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"copy(...)");
        } else {
            v2 = null;
        }
        output = UtilsKt.getGson();
        Intrinsics.checkNotNullExpressionValue((Object)serverVersionJson, (String)"serverVersionJson");
        Iterable<Path> any$iv = serverVersionJson;
        boolean $i$f$fromJson = false;
        if (any$iv instanceof String) {
            Type type;
            copyOptionArray2 = $this$fromJson$iv;
            Object object3 = json$iv$iv = (String)((Object)any$iv);
            Path path4 = $receiver$iv$iv;
            Type type2 = new TypeToken<JsonObject>(){}.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {} .type");
            Type type$iv$iv$iv2 = type2;
            if (type$iv$iv$iv2 instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv2)) {
                Type type3 = ((ParameterizedType)type$iv$iv$iv2).getRawType();
                type = type3;
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
            } else {
                type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv2);
            }
            object2 = type;
            Object t = ((Gson)((Object)path4)).fromJson((String)object3, (Type)object2);
            object = t;
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
        } else {
            $receiver$iv$iv = UtilsKt.convertToPath(any$iv);
            json$iv$iv = Charsets.UTF_8;
            OpenOption[] openOptionArray = new OpenOption[]{};
            int n = 8192;
            $receiver$iv$iv = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)$receiver$iv$iv, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)json$iv$iv), n);
            json$iv$iv = null;
            try {
                Type type;
                BufferedReader it$iv = (BufferedReader)$receiver$iv$iv;
                boolean bl = false;
                void $receiver$iv$iv2 = $this$fromJson$iv;
                object2 = it$iv;
                void $i$f$gsonTypeToken = $receiver$iv$iv2;
                Type type4 = new TypeToken<JsonObject>(){}.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"object : TypeToken<T>() {} .type");
                type$iv$iv$iv = type4;
                if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                    Type type5 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                    type = type5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"type.rawType");
                } else {
                    type = GsonBuilderKt.removeTypeWildcards((Type)type$iv$iv$iv);
                }
                Type $i$f$fromJson2 = type;
                Object t = $i$f$gsonTypeToken.fromJson((Reader)object2, $i$f$fromJson2);
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
                it$iv = t;
                object = it$iv;
            }
            catch (Throwable it$iv) {
                json$iv$iv = it$iv;
                throw it$iv;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$receiver$iv$iv, (Throwable)json$iv$iv);
            }
        }
        String versionId = ((JsonObject)object).get("id").getAsString();
        Path path5 = bundlerZip.resolve("META-INF/versions.list");
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"bundlerZip.resolve(FileEntry.VERSIONS_LIST)");
        any$iv = path5;
        List<String> list = Files.readAllLines(any$iv, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
        any$iv = list;
        boolean $i$f$map = false;
        $receiver$iv$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            type$iv$iv$iv = new char[1];
            type$iv$iv$iv[0] = 9;
            collection.add(StringsKt.split$default((CharSequence)((CharSequence)it), (char[])type$iv$iv$iv, (boolean)false, (int)0, (int)6, null));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            List it = (List)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.get(1), it.get(2));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map versions = destination$iv$iv2;
        Path serverJarPath = bundlerZip.resolve("META-INF/versions/" + versions.get(versionId));
        Path path6 = serverJar.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"serverJar.parent");
        Path path7 = path6;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path7, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Intrinsics.checkNotNullExpressionValue((Object)serverJarPath, (String)"serverJarPath");
        path7 = serverJarPath;
        copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        CopyOption[] copyOptionArray3 = copyOptionArray;
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path7, serverJar, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"copy(...)");
    }

    private final void extractLibraryJars(Path bundlerZip, Path serverLibraryJars) {
        FileKt.deleteRecursive$default(serverLibraryJars, null, null, 3, null);
        Path path = serverLibraryJars.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"serverLibraryJars.parent");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Path path3 = bundlerZip.resolve("META-INF/libraries");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"bundlerZip.resolve(FileEntry.LIBRARIES_DIR)");
        FileKt.copyRecursivelyTo(path3, serverLibraryJars);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeLibrariesTxt(Path bundlerZip, Path serverLibrariesTxt) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Path path = bundlerZip.resolve("META-INF/libraries.list");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"bundlerZip.resolve(FileEntry.LIBRARIES_LIST)");
        Iterable<Path> iterable = path;
        List<String> list = Files.readAllLines(iterable, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
        iterable = list;
        boolean $i$f$map = false;
        OpenOption[] openOptionArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            char[] cArray = new char[]{'\t'};
            collection.add((String)StringsKt.split$default((CharSequence)((CharSequence)it), (char[])cArray, (boolean)false, (int)0, (int)6, null).get(1));
        }
        List libs = (List)destination$iv$iv;
        Path path2 = serverLibrariesTxt.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"serverLibrariesTxt.parent");
        iterable = path2;
        Object object = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(iterable, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"createDirectories(...)");
        iterable = serverLibrariesTxt;
        openOptionArray = new OpenOption[]{};
        object = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)Files.write(iterable, (Iterable<? extends CharSequence>)libs, (Charset)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"write(...)");
    }
}

