/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.action;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.userdev.internal.action.DirectoryOutputValue;
import io.papermc.paperweight.userdev.internal.action.DirectoryValue;
import io.papermc.paperweight.userdev.internal.action.FileOutputValue;
import io.papermc.paperweight.userdev.internal.action.FileValue;
import io.papermc.paperweight.userdev.internal.action.Value;
import io.papermc.paperweight.userdev.internal.action.WorkDispatcher;
import io.papermc.paperweight.userdev.internal.action.WorkDispatcherImpl;
import io.papermc.paperweight.userdev.internal.action.WorkDispatcherImpl$register$;
import io.papermc.paperweight.userdev.internal.action.WorkGraph;
import io.papermc.paperweight.userdev.internal.util.UtilsKt;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 .2\u00020\u0001:\u0002./B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J=\u0010\f\u001a\u00020\r2\u001a\u0010\u000e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u000f\"\u0006\u0012\u0002\b\u00030\u00072\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u0014\u0010\u0005\u001a\u00020\r2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J'\u0010\u001b\u001a\u0002H\u001c\"\b\b\u0000\u0010\u001c*\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u0002H\u001cH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001f\u0010 \u001a\u0002H\u001c\"\b\b\u0000\u0010\u001c*\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010!J-\u0010\"\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020%\u0012\u0002\b\u00030$0#\"\n\b\u0000\u0010&\u0018\u0001*\u00020'*\u0006\u0012\u0002\b\u00030(H\u0082\bJ<\u0010)\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020%\u0012\u0002\b\u00030$0#*\u0006\u0012\u0002\b\u00030(2\u001a\u0010*\u001a\u0016\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030$\u0012\u0004\u0012\u00020+0\u0011H\u0002J.\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070#*\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020%\u0012\u0002\b\u00030$0#2\u0006\u0010-\u001a\u00020\u001dH\u0002R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/papermc/paperweight/userdev/internal/action/WorkDispatcherImpl;", "Lio/papermc/paperweight/userdev/internal/action/WorkDispatcher;", "work", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "provided", "", "Lio/papermc/paperweight/userdev/internal/action/Value;", "registrations", "Lio/papermc/paperweight/userdev/internal/action/WorkDispatcherImpl$Registration;", "terminalInputHash", "", "dispatch", "", "targets", "", "progressEventListener", "Lkotlin/Function1;", "([Lio/papermc/paperweight/userdev/internal/action/Value;Lkotlin/jvm/functions/Function1;)V", "outputDir", "Lio/papermc/paperweight/userdev/internal/action/DirectoryValue;", "name", "outputFile", "Lio/papermc/paperweight/userdev/internal/action/FileValue;", "overrideTerminalInputHash", "hash", "value", "register", "T", "Lio/papermc/paperweight/userdev/internal/action/WorkDispatcher$Action;", "workUnit", "(Ljava/lang/String;Lio/papermc/paperweight/userdev/internal/action/WorkDispatcher$Action;)Lio/papermc/paperweight/userdev/internal/action/WorkDispatcher$Action;", "registered", "(Ljava/lang/String;)Lio/papermc/paperweight/userdev/internal/action/WorkDispatcher$Action;", "collectAnnotatedDeclaredProperties", "", "Lkotlin/reflect/KProperty1;", "", "A", "", "Lkotlin/reflect/KClass;", "collectDeclaredProperties", "filter", "", "extractValues", "action", "Companion", "Registration", "paperweight-userdev"})
@SourceDebugExtension(value={"SMAP\nWorkDispatcherImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkDispatcherImpl.kt\nio/papermc/paperweight/userdev/internal/action/WorkDispatcherImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n119#1,3:139\n119#1,3:142\n1755#2,3:133\n1755#2,3:136\n1755#2,3:145\n295#2,2:148\n1611#2,9:156\n1863#2:165\n1864#2:167\n1620#2:168\n774#2:169\n865#2,2:170\n1557#2:172\n1628#2,3:173\n31#3,6:150\n1#4:166\n*S KotlinDebug\n*F\n+ 1 WorkDispatcherImpl.kt\nio/papermc/paperweight/userdev/internal/action/WorkDispatcherImpl\n*L\n72#1:139,3\n73#1:142,3\n57#1:133,3\n66#1:136,3\n75#1:145,3\n84#1:148,2\n110#1:156,9\n110#1:165\n110#1:167\n110#1:168\n127#1:169\n127#1:170,2\n127#1:172\n127#1:173,3\n103#1:150,6\n110#1:166\n*E\n"})
public final class WorkDispatcherImpl
implements WorkDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path work;
    @NotNull
    private final Set<Value<?>> provided;
    @NotNull
    private final Set<Registration> registrations;
    @Nullable
    private String terminalInputHash;
    private static final Logger logger = Logging.getLogger(WorkDispatcherImpl.class);

    public WorkDispatcherImpl(@NotNull Path work) {
        Intrinsics.checkNotNullParameter((Object)work, (String)"work");
        this.work = work;
        this.provided = new LinkedHashSet();
        this.registrations = new LinkedHashSet();
    }

    @Override
    @NotNull
    public FileValue outputFile(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new FileOutputValue(name2);
    }

    @Override
    @NotNull
    public DirectoryValue outputDir(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return new DirectoryOutputValue(name2);
    }

    @Override
    public void provided(@NotNull Value<?> value2) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(value2, (String)"value");
            Iterable $this$any$iv = this.registrations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Registration it = (Registration)element$iv;
                    boolean bl2 = false;
                    if (!it.getOutputs().contains(value2)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new PaperweightException("Value " + value2 + " is an output of a registered work unit");
        }
        if (!this.provided.add(value2)) {
            throw new PaperweightException("Value " + value2 + " has already been provided");
        }
    }

    @Override
    @NotNull
    public <T extends WorkDispatcher.Action> T register(@NotNull String name2, @NotNull T workUnit) {
        boolean bl;
        Registration data;
        block9: {
            WorkDispatcherImpl this_$iv;
            boolean bl2;
            block8: {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter(workUnit, (String)"workUnit");
                Iterable $this$any$iv = this.registrations;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Registration it = (Registration)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                throw new PaperweightException("Work unit with name " + name2 + " has already been registered");
            }
            WorkDispatcherImpl $i$f$any = this;
            KClass $this$collectAnnotatedDeclaredProperties$iv = Reflection.getOrCreateKotlinClass(workUnit.getClass());
            boolean $i$f$collectAnnotatedDeclaredProperties = false;
            List<Value<?>> list = this.extractValues(super.collectDeclaredProperties($this$collectAnnotatedDeclaredProperties$iv, register$$inlined$collectAnnotatedDeclaredProperties$1.INSTANCE), workUnit);
            this_$iv = this;
            $this$collectAnnotatedDeclaredProperties$iv = Reflection.getOrCreateKotlinClass(workUnit.getClass());
            $i$f$collectAnnotatedDeclaredProperties = false;
            data = new Registration(name2, workUnit, list, this.extractValues(this_$iv.collectDeclaredProperties($this$collectAnnotatedDeclaredProperties$iv, register$$inlined$collectAnnotatedDeclaredProperties$2.INSTANCE), workUnit));
            Iterable $this$any$iv = data.getOutputs();
            boolean $i$f$any2 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Value it = (Value)element$iv;
                    boolean bl4 = false;
                    if (!this.provided.contains(it)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new PaperweightException("Output of work unit " + name2 + " has already been provided");
        }
        this.registrations.add(data);
        return workUnit;
    }

    @Override
    @NotNull
    public <T extends WorkDispatcher.Action> T registered(@NotNull String name2) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Iterable $this$firstOrNull$iv = this.registrations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Registration it = (Registration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Registration registration = v0;
        WorkDispatcher.Action action = registration != null ? registration.getAction() : null;
        WorkDispatcher.Action action2 = action instanceof WorkDispatcher.Action ? action : null;
        if (action2 == null) {
            throw new PaperweightException("No work unit registered with name " + name2);
        }
        return (T)action2;
    }

    @Override
    public void overrideTerminalInputHash(@NotNull String hash2) {
        Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
        this.terminalInputHash = hash2;
    }

    @Override
    public void dispatch(@NotNull Value<?>[] targets, @NotNull Function1<? super String, Unit> progressEventListener) {
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter(progressEventListener, (String)"progressEventListener");
        Set targetSet = ArraysKt.toSet((Object[])targets);
        long start = System.nanoTime();
        WorkGraph graph = new WorkGraph(CollectionsKt.toSet((Iterable)this.provided), CollectionsKt.toSet((Iterable)this.registrations), this.terminalInputHash, targetSet);
        long took = System.nanoTime() - start;
        logger.info("Graph building for " + targetSet + " took " + UtilsKt.formatNs(took));
        boolean $i$f$measureNanoTime = false;
        long start$iv = System.nanoTime();
        boolean bl = false;
        graph.execute(this.work, progressEventListener);
        long executedIn = System.nanoTime() - start$iv;
        logger.info("Execution of " + targetSet + " took " + UtilsKt.formatNs(executedIn));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Value<?>> extractValues(List<? extends KProperty1<Object, ?>> $this$extractValues, WorkDispatcher.Action action) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = $this$extractValues;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Value it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KProperty1 it = (KProperty1)element$iv$iv;
            boolean bl2 = false;
            KClass kClass = Reflection.getOrCreateKotlinClass(Value.class);
            KClassifier kClassifier = it.getReturnType().getClassifier();
            Intrinsics.checkNotNull((Object)kClassifier, (String)"null cannot be cast to non-null type kotlin.reflect.KClass<*>");
            if (!KClasses.isSuperclassOf((KClass)kClass, (KClass)((KClass)kClassifier))) {
                throw new PaperweightException("Input/output property " + it + " does not return a Value");
            }
            if ((Value)it.get((Object)action) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final /* synthetic */ <A extends Annotation> List<KProperty1<Object, ?>> collectAnnotatedDeclaredProperties(KClass<?> $this$collectAnnotatedDeclaredProperties) {
        boolean $i$f$collectAnnotatedDeclaredProperties = false;
        Intrinsics.needClassReification();
        return this.collectDeclaredProperties($this$collectAnnotatedDeclaredProperties, collectAnnotatedDeclaredProperties.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final List<KProperty1<Object, ?>> collectDeclaredProperties(KClass<?> $this$collectDeclaredProperties, Function1<? super KProperty1<?, ?>, Boolean> filter2) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = KClasses.getDeclaredMemberProperties($this$collectDeclaredProperties);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)filter2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KProperty1 kProperty1 = (KProperty1)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KCallablesJvm.setAccessible((KCallable)((KCallable)it), (boolean)true);
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.reflect.KProperty1<kotlin.Any, *>");
            collection.add(it);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/papermc/paperweight/userdev/internal/action/WorkDispatcherImpl$Companion;", "", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "paperweight-userdev"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u0012\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007H\u00c6\u0003J\u0013\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007H\u00c6\u0003JE\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00072\u0012\b\u0002\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lio/papermc/paperweight/userdev/internal/action/WorkDispatcherImpl$Registration;", "", "name", "", "action", "Lio/papermc/paperweight/userdev/internal/action/WorkDispatcher$Action;", "inputs", "", "Lio/papermc/paperweight/userdev/internal/action/Value;", "outputs", "(Ljava/lang/String;Lio/papermc/paperweight/userdev/internal/action/WorkDispatcher$Action;Ljava/util/List;Ljava/util/List;)V", "getAction", "()Lio/papermc/paperweight/userdev/internal/action/WorkDispatcher$Action;", "getInputs", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getOutputs", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "paperweight-userdev"})
    public static final class Registration {
        @NotNull
        private final String name;
        @NotNull
        private final WorkDispatcher.Action action;
        @NotNull
        private final List<Value<?>> inputs;
        @NotNull
        private final List<Value<?>> outputs;

        public Registration(@NotNull String name2, @NotNull WorkDispatcher.Action action, @NotNull List<? extends Value<?>> inputs, @NotNull List<? extends Value<?>> outputs) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
            Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
            this.name = name2;
            this.action = action;
            this.inputs = inputs;
            this.outputs = outputs;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final WorkDispatcher.Action getAction() {
            return this.action;
        }

        @NotNull
        public final List<Value<?>> getInputs() {
            return this.inputs;
        }

        @NotNull
        public final List<Value<?>> getOutputs() {
            return this.outputs;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final WorkDispatcher.Action component2() {
            return this.action;
        }

        @NotNull
        public final List<Value<?>> component3() {
            return this.inputs;
        }

        @NotNull
        public final List<Value<?>> component4() {
            return this.outputs;
        }

        @NotNull
        public final Registration copy(@NotNull String name2, @NotNull WorkDispatcher.Action action, @NotNull List<? extends Value<?>> inputs, @NotNull List<? extends Value<?>> outputs) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
            Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
            return new Registration(name2, action, inputs, outputs);
        }

        public static /* synthetic */ Registration copy$default(Registration registration, String string, WorkDispatcher.Action action, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = registration.name;
            }
            if ((n & 2) != 0) {
                action = registration.action;
            }
            if ((n & 4) != 0) {
                list = registration.inputs;
            }
            if ((n & 8) != 0) {
                list2 = registration.outputs;
            }
            return registration.copy(string, action, list, list2);
        }

        @NotNull
        public String toString() {
            return "Registration(name=" + this.name + ", action=" + this.action + ", inputs=" + this.inputs + ", outputs=" + this.outputs + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.action.hashCode();
            result2 = result2 * 31 + ((Object)this.inputs).hashCode();
            result2 = result2 * 31 + ((Object)this.outputs).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Registration)) {
                return false;
            }
            Registration registration = (Registration)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)registration.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.action, (Object)registration.action)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.inputs, registration.inputs)) {
                return false;
            }
            return Intrinsics.areEqual(this.outputs, registration.outputs);
        }
    }
}

