/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.action;

import io.papermc.paperweight.userdev.internal.action.Value;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.FileSystemReference;
import io.papermc.paperweight.util.InputStreamProvider;
import io.papermc.paperweight.util.NioKt;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0002H\u0016J\b\u0010\u0014\u001a\u00020\u0006H\u0016J%\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00160\u0018\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lio/papermc/paperweight/userdev/internal/action/ZippedFileValue;", "Lio/papermc/paperweight/userdev/internal/action/Value;", "", "zipFile", "Ljava/nio/file/Path;", "path", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "getZipFile", "()Ljava/nio/file/Path;", "bytes", "", "Lio/papermc/paperweight/util/InputStreamProvider;", "extractTo", "target", "overwrite", "", "get", "toString", "useEntry", "R", "op", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "paperweight-userdev"})
public final class ZippedFileValue
implements Value<Unit> {
    @NotNull
    private final Path zipFile;
    @NotNull
    private final String path;

    public ZippedFileValue(@NotNull Path zipFile, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.zipFile = zipFile;
        this.path = path;
    }

    @NotNull
    public final Path getZipFile() {
        return this.zipFile;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Override
    public void get() {
    }

    public final void extractTo(@NotNull Path target, boolean overwrite) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.useEntry((Function1)new Function1<Path, Path>(target, overwrite){
            final /* synthetic */ Path $target;
            final /* synthetic */ boolean $overwrite;
            {
                this.$target = $target;
                this.$overwrite = $overwrite;
                super(1);
            }

            public final Path invoke(Path it) {
                CopyOption[] copyOptionArray;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Path path = it;
                Path path2 = FileKt.createParentDirectories(this.$target, new FileAttribute[0]);
                if (this.$overwrite) {
                    CopyOption[] copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    copyOptionArray = copyOptionArray2;
                } else {
                    copyOptionArray = new CopyOption[]{};
                }
                CopyOption[] copyOptionArray3 = copyOptionArray;
                Path path3 = Files.copy(path, path2, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length));
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"copy(...)");
                return path3;
            }
        });
    }

    public static /* synthetic */ void extractTo$default(ZippedFileValue zippedFileValue, Path path, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        zippedFileValue.extractTo(path, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R useEntry(@NotNull Function1<? super Path, ? extends R> op2) {
        Intrinsics.checkNotNullParameter(op2, (String)"op");
        AutoCloseable autoCloseable = NioKt.openZipSafe(this.zipFile);
        Throwable throwable = null;
        try {
            FileSystemReference fs = (FileSystemReference)autoCloseable;
            boolean bl = false;
            Path path = fs.getPath("/").resolve(this.path);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            Object object = op2.invoke((Object)path);
            return (R)object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public List<InputStreamProvider> bytes() {
        return CollectionsKt.listOf((Object)new InputStreamProvider(this){
            final /* synthetic */ ZippedFileValue this$0;
            {
                this.this$0 = $receiver;
            }

            public <T> T use(Function1<? super InputStream, ? extends T> op2) {
                Intrinsics.checkNotNullParameter(op2, (String)"op");
                return (T)this.this$0.useEntry((Function1)new Function1<Path, T>(op2){
                    final /* synthetic */ Function1<InputStream, T> $op;
                    {
                        this.$op = $op;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final T invoke(Path it) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        OpenOption[] openOptionArray = new OpenOption[]{};
                        InputStream inputStream = Files.newInputStream(it, Arrays.copyOf(openOptionArray, openOptionArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                        Closeable closeable = inputStream;
                        Function1<InputStream, T> function1 = this.$op;
                        Throwable throwable = null;
                        try {
                            object = function1.invoke((Object)closeable);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        return (T)object;
                    }
                });
            }
        });
    }

    @NotNull
    public String toString() {
        return "ZippedFileValue(zipFile='" + this.zipFile + "', path='" + this.path + "')";
    }
}

