/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup.action;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.userdev.internal.action.FileValue;
import io.papermc.paperweight.userdev.internal.action.Input;
import io.papermc.paperweight.userdev.internal.action.Output;
import io.papermc.paperweight.userdev.internal.action.StringValue;
import io.papermc.paperweight.userdev.internal.action.WorkDispatcher;
import io.papermc.paperweight.userdev.internal.setup.action.ApplyDevBundlePatchesAction;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.FileSystemReference;
import io.papermc.paperweight.util.NioKt;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.ZipKt;
import java.io.Closeable;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import paper.libs.codechicken.diffpatch.cli.PatchOperation;
import paper.libs.codechicken.diffpatch.util.LogLevel;
import paper.libs.codechicken.diffpatch.util.archiver.ArchiveFormat;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001c\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u000bR\u001c\u0010\u0007\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u000b\u001a\u0004\b\u0010\u0010\rR\u0018\u0010\b\u001a\u0004\u0018\u00010\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u000bR\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/action/ApplyDevBundlePatchesAction;", "Lio/papermc/paperweight/userdev/internal/action/WorkDispatcher$Action;", "decompiledJar", "Lio/papermc/paperweight/userdev/internal/action/FileValue;", "bundleZip", "patchesPath", "Lio/papermc/paperweight/userdev/internal/action/StringValue;", "outputJar", "patchedJar", "(Lio/papermc/paperweight/userdev/internal/action/FileValue;Lio/papermc/paperweight/userdev/internal/action/FileValue;Lio/papermc/paperweight/userdev/internal/action/StringValue;Lio/papermc/paperweight/userdev/internal/action/FileValue;Lio/papermc/paperweight/userdev/internal/action/FileValue;)V", "getBundleZip$annotations", "()V", "getBundleZip", "()Lio/papermc/paperweight/userdev/internal/action/FileValue;", "getDecompiledJar$annotations", "getOutputJar$annotations", "getOutputJar", "getPatchedJar$annotations", "getPatchesPath$annotations", "getPatchesPath", "()Lio/papermc/paperweight/userdev/internal/action/StringValue;", "execute", "", "paperweight-userdev"})
@SourceDebugExtension(value={"SMAP\nApplyDevBundlePatchesAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplyDevBundlePatchesAction.kt\nio/papermc/paperweight/userdev/internal/setup/action/ApplyDevBundlePatchesAction\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,115:1\n2707#2,10:116\n1317#2,2:126\n*S KotlinDebug\n*F\n+ 1 ApplyDevBundlePatchesAction.kt\nio/papermc/paperweight/userdev/internal/setup/action/ApplyDevBundlePatchesAction\n*L\n59#1:116,10\n102#1:126,2\n*E\n"})
public final class ApplyDevBundlePatchesAction
implements WorkDispatcher.Action {
    @NotNull
    private final FileValue decompiledJar;
    @NotNull
    private final FileValue bundleZip;
    @NotNull
    private final StringValue patchesPath;
    @NotNull
    private final FileValue outputJar;
    @Nullable
    private final FileValue patchedJar;

    public ApplyDevBundlePatchesAction(@NotNull FileValue decompiledJar, @NotNull FileValue bundleZip, @NotNull StringValue patchesPath, @NotNull FileValue outputJar, @Nullable FileValue patchedJar) {
        Intrinsics.checkNotNullParameter((Object)decompiledJar, (String)"decompiledJar");
        Intrinsics.checkNotNullParameter((Object)bundleZip, (String)"bundleZip");
        Intrinsics.checkNotNullParameter((Object)patchesPath, (String)"patchesPath");
        Intrinsics.checkNotNullParameter((Object)outputJar, (String)"outputJar");
        this.decompiledJar = decompiledJar;
        this.bundleZip = bundleZip;
        this.patchesPath = patchesPath;
        this.outputJar = outputJar;
        this.patchedJar = patchedJar;
    }

    public /* synthetic */ ApplyDevBundlePatchesAction(FileValue fileValue, FileValue fileValue2, StringValue stringValue, FileValue fileValue3, FileValue fileValue4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            fileValue4 = null;
        }
        this(fileValue, fileValue2, stringValue, fileValue3, fileValue4);
    }

    @Input
    private static /* synthetic */ void getDecompiledJar$annotations() {
    }

    @NotNull
    public final FileValue getBundleZip() {
        return this.bundleZip;
    }

    @Input
    public static /* synthetic */ void getBundleZip$annotations() {
    }

    @NotNull
    public final StringValue getPatchesPath() {
        return this.patchesPath;
    }

    @Input
    public static /* synthetic */ void getPatchesPath$annotations() {
    }

    @NotNull
    public final FileValue getOutputJar() {
        return this.outputJar;
    }

    @Output
    public static /* synthetic */ void getOutputJar$annotations() {
    }

    @Input
    private static /* synthetic */ void getPatchedJar$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void execute() {
        Object[] objectArray;
        Path outputDir;
        Path tempPatchDir;
        block37: {
            tempPatchDir = UtilsKt.findOutputDir((Path)this.outputJar.get());
            outputDir = UtilsKt.findOutputDir((Path)this.outputJar.get());
            Path log = io.papermc.paperweight.userdev.internal.util.UtilsKt.siblingLogFile((Path)this.outputJar.get());
            try {
                Object object;
                Throwable throwable;
                Object object2;
                objectArray = (Object[])NioKt.openZipSafe((Path)this.bundleZip.get());
                Throwable throwable2 = null;
                try {
                    Object stream2;
                    FileSystemReference fs = (FileSystemReference)objectArray;
                    boolean bl = false;
                    Path patchesDir = fs.getPath(this.patchesPath.get());
                    object2 = Files.walk(patchesDir, new FileVisitOption[0]);
                    throwable = null;
                    try {
                        void $this$partition$iv;
                        stream2 = (Stream)object2;
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)stream2, (String)"stream");
                        object = SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)stream2), (Function1)execute.1.1.1.INSTANCE);
                        boolean $i$f$partition = false;
                        ArrayList first$iv = new ArrayList();
                        ArrayList second$iv = new ArrayList();
                        for (Object element$iv : $this$partition$iv) {
                            Path it = (Path)element$iv;
                            boolean bl3 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (StringsKt.endsWith$default((String)PathsKt.getName((Path)it), (String)".patch", (boolean)false, (int)2, null)) {
                                first$iv.add(element$iv);
                                continue;
                            }
                            second$iv.add(element$iv);
                        }
                        stream2 = new Pair(first$iv, second$iv);
                    }
                    catch (Throwable stream2) {
                        throwable = stream2;
                        throw stream2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)throwable);
                    }
                    Stream stream3 = stream2;
                    List patches = (List)stream3.component1();
                    List newFiles = (List)stream3.component2();
                    for (Path patch : patches) {
                        Intrinsics.checkNotNullExpressionValue((Object)patch, (String)"patch");
                        FileKt.relativeCopy(patchesDir, patch, tempPatchDir);
                    }
                    stream2 = new Object[]{log};
                    UtilsKt.ensureDeleted((Object[])stream2);
                    stream2 = new PrintStream(log.toFile(), Charsets.UTF_8);
                    Throwable patch = null;
                    try {
                        PrintStream logOut = (PrintStream)stream2;
                        boolean bl4 = false;
                        PatchOperation op2 = PatchOperation.builder().logTo(logOut).level(LogLevel.ALL).summary(true).basePath((Path)this.decompiledJar.get(), ArchiveFormat.ZIP).patchesPath(tempPatchDir).outputPath(outputDir).build();
                        try {
                            op2.operate().throwOnError();
                        }
                        catch (Exception ex) {
                            throw new PaperweightException("Failed to apply dev bundle patches. See the log file at '" + log.toFile() + "' for more details.", ex);
                        }
                        object = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        patch = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)stream2, (Throwable)patch);
                    }
                    for (Path file2 : newFiles) {
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                        FileKt.relativeCopy(patchesDir, file2, outputDir);
                    }
                    fs = Unit.INSTANCE;
                }
                catch (Throwable fs) {
                    throwable2 = fs;
                    throw fs;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)objectArray, (Throwable)throwable2);
                }
                objectArray = new Object[]{this.outputJar.get()};
                UtilsKt.ensureDeleted(objectArray);
                ZipKt.zip(outputDir, this.outputJar.get());
                FileValue fileValue = this.patchedJar;
                if (fileValue == null) break block37;
                FileValue patched = fileValue;
                boolean bl = false;
                Closeable closeable = FileKt.openZip((Path)this.outputJar.get());
                object2 = null;
                try {
                    FileSystem fs = (FileSystem)closeable;
                    boolean bl5 = false;
                    Path out = fs.getPath("/", new String[0]);
                    object = FileKt.openZip((Path)patched.get());
                    Throwable throwable4 = null;
                    try {
                        void $this$forEach$iv;
                        Object element$iv;
                        FileSystem patchedFs = (FileSystem)object;
                        boolean bl6 = false;
                        Path patchedRoot = patchedFs.getPath("/", new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)patchedRoot, (String)"patchedRoot");
                        element$iv = SequencesKt.filter((Sequence)PathsKt.walk((Path)patchedRoot, (PathWalkOption[])new PathWalkOption[0]), (Function1)execute.2.1.1.1.INSTANCE);
                        boolean $i$f$forEach = false;
                        for (Object element$iv2 : $this$forEach$iv) {
                            Path file3 = (Path)element$iv2;
                            boolean bl7 = false;
                            Path copyTo = out.resolve(PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)file3, (Path)patchedRoot)));
                            Intrinsics.checkNotNullExpressionValue((Object)copyTo, (String)"copyTo");
                            FileKt.createParentDirectories(copyTo, new FileAttribute[0]);
                            Path path = file3;
                            Path path2 = copyTo;
                            CopyOption[] copyOptionArray = new CopyOption[]{};
                            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path, path2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable4);
                    }
                    throwable = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    object2 = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
                }
            }
            catch (Throwable throwable) {
                Object[] objectArray2 = new Object[]{outputDir, tempPatchDir};
                UtilsKt.ensureDeleted(objectArray2);
                throw throwable;
            }
        }
        objectArray = new Object[]{outputDir, tempPatchDir};
        UtilsKt.ensureDeleted(objectArray);
    }
}

