/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup.action;

import io.papermc.paperweight.userdev.internal.action.FileValue;
import io.papermc.paperweight.userdev.internal.action.Input;
import io.papermc.paperweight.userdev.internal.action.Output;
import io.papermc.paperweight.userdev.internal.action.StringValue;
import io.papermc.paperweight.userdev.internal.action.Value;
import io.papermc.paperweight.userdev.internal.action.WorkDispatcher;
import io.papermc.paperweight.util.FileSystemReference;
import io.papermc.paperweight.util.Jar_runnerKt;
import io.papermc.paperweight.util.NioKt;
import io.papermc.paperweight.util.UtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.jvm.toolchain.JavaLauncher;
import paper.libs.com.github.salomonbrys.kotson.GsonBuilderKt;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.JsonObject;
import paper.libs.com.google.gson.reflect.TypeToken;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001BE\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\t\u001a\u00020!H\u0002J\u0018\u0010#\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\t\u001a\u00020!H\u0002J0\u0010$\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020!2\u0006\u0010\n\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020%2\u0006\u0010\f\u001a\u00020\rH\u0002R\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0010R\u001c\u0010\u000b\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0010\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\n\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0010\u001a\u0004\b\u0018\u0010\u0012R\u001c\u0010\t\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u0010\u001a\u0004\b\u001a\u0010\u0012R\u001c\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u0010\u001a\u0004\b\u001c\u0010\u0016\u00a8\u0006&"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/action/RunPaperclipAction;", "Lio/papermc/paperweight/userdev/internal/action/WorkDispatcher$Action;", "javaLauncher", "Lio/papermc/paperweight/userdev/internal/action/Value;", "Lorg/gradle/jvm/toolchain/JavaLauncher;", "bundleZip", "Lio/papermc/paperweight/userdev/internal/action/FileValue;", "paperclipPath", "Lio/papermc/paperweight/userdev/internal/action/StringValue;", "outputJar", "mojangJar", "minecraftVersion", "bundler", "", "(Lio/papermc/paperweight/userdev/internal/action/Value;Lio/papermc/paperweight/userdev/internal/action/FileValue;Lio/papermc/paperweight/userdev/internal/action/StringValue;Lio/papermc/paperweight/userdev/internal/action/FileValue;Lio/papermc/paperweight/userdev/internal/action/FileValue;Lio/papermc/paperweight/userdev/internal/action/StringValue;Z)V", "getBundleZip$annotations", "()V", "getBundleZip", "()Lio/papermc/paperweight/userdev/internal/action/FileValue;", "getJavaLauncher$annotations", "getMinecraftVersion$annotations", "getMinecraftVersion", "()Lio/papermc/paperweight/userdev/internal/action/StringValue;", "getMojangJar$annotations", "getMojangJar", "getOutputJar$annotations", "getOutputJar", "getPaperclipPath$annotations", "getPaperclipPath", "execute", "", "handleBundler", "paperclip", "Ljava/nio/file/Path;", "work", "handleOldPaperclip", "patchPaperclip", "", "paperweight-userdev"})
@SourceDebugExtension(value={"SMAP\nRunPaperclipAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunPaperclipAction.kt\nio/papermc/paperweight/userdev/internal/setup/action/RunPaperclipAction\n+ 2 utils.kt\nio/papermc/paperweight/util/UtilsKt\n+ 3 Gson.kt\ncom/github/salomonbrys/kotson/GsonKt\n+ 4 GsonBuilder.kt\ncom/github/salomonbrys/kotson/GsonBuilderKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n97#2,2:117\n99#2:126\n100#2:134\n17#3:119\n19#3:128\n61#4:120\n13#4:121\n63#4,4:122\n13#4:129\n63#4,4:130\n1#5:127\n1#5:145\n1557#6:135\n1628#6,3:136\n1187#6,2:139\n1261#6,4:141\n*S KotlinDebug\n*F\n+ 1 RunPaperclipAction.kt\nio/papermc/paperweight/userdev/internal/setup/action/RunPaperclipAction\n*L\n99#1:117,2\n99#1:126\n99#1:134\n99#1:119\n99#1:128\n99#1:120\n99#1:121\n99#1:122,4\n99#1:129\n99#1:130,4\n99#1:127\n101#1:135\n101#1:136,3\n102#1:139,2\n102#1:141,4\n*E\n"})
public final class RunPaperclipAction
implements WorkDispatcher.Action {
    @NotNull
    private final Value<JavaLauncher> javaLauncher;
    @NotNull
    private final FileValue bundleZip;
    @NotNull
    private final StringValue paperclipPath;
    @NotNull
    private final FileValue outputJar;
    @NotNull
    private final FileValue mojangJar;
    @NotNull
    private final StringValue minecraftVersion;
    private final boolean bundler;

    public RunPaperclipAction(@NotNull Value<JavaLauncher> javaLauncher, @NotNull FileValue bundleZip, @NotNull StringValue paperclipPath, @NotNull FileValue outputJar, @NotNull FileValue mojangJar, @NotNull StringValue minecraftVersion2, boolean bundler) {
        Intrinsics.checkNotNullParameter(javaLauncher, (String)"javaLauncher");
        Intrinsics.checkNotNullParameter((Object)bundleZip, (String)"bundleZip");
        Intrinsics.checkNotNullParameter((Object)paperclipPath, (String)"paperclipPath");
        Intrinsics.checkNotNullParameter((Object)outputJar, (String)"outputJar");
        Intrinsics.checkNotNullParameter((Object)mojangJar, (String)"mojangJar");
        Intrinsics.checkNotNullParameter((Object)minecraftVersion2, (String)"minecraftVersion");
        this.javaLauncher = javaLauncher;
        this.bundleZip = bundleZip;
        this.paperclipPath = paperclipPath;
        this.outputJar = outputJar;
        this.mojangJar = mojangJar;
        this.minecraftVersion = minecraftVersion2;
        this.bundler = bundler;
    }

    public /* synthetic */ RunPaperclipAction(Value value2, FileValue fileValue, StringValue stringValue, FileValue fileValue2, FileValue fileValue3, StringValue stringValue2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            bl = true;
        }
        this(value2, fileValue, stringValue, fileValue2, fileValue3, stringValue2, bl);
    }

    @Input
    private static /* synthetic */ void getJavaLauncher$annotations() {
    }

    @NotNull
    public final FileValue getBundleZip() {
        return this.bundleZip;
    }

    @Input
    public static /* synthetic */ void getBundleZip$annotations() {
    }

    @NotNull
    public final StringValue getPaperclipPath() {
        return this.paperclipPath;
    }

    @Input
    public static /* synthetic */ void getPaperclipPath$annotations() {
    }

    @NotNull
    public final FileValue getOutputJar() {
        return this.outputJar;
    }

    @Output
    public static /* synthetic */ void getOutputJar$annotations() {
    }

    @NotNull
    public final FileValue getMojangJar() {
        return this.mojangJar;
    }

    @Input
    public static /* synthetic */ void getMojangJar$annotations() {
    }

    @NotNull
    public final StringValue getMinecraftVersion() {
        return this.minecraftVersion;
    }

    @Input
    public static /* synthetic */ void getMinecraftVersion$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Path path = ((Path)this.outputJar.get()).resolveSibling("paperclip-tmp.jar");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputJar.get().resolveS\u2026ling(\"paperclip-tmp.jar\")");
        Path paperclip = UtilsKt.cleanFile(path);
        AutoCloseable autoCloseable = NioKt.openZipSafe((Path)this.bundleZip.get());
        Throwable throwable = null;
        try {
            FileSystemReference fs = (FileSystemReference)autoCloseable;
            boolean bl = false;
            Path path2 = fs.getPath(this.paperclipPath.get());
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Path path3 = Files.copy(path2, paperclip, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"copy(...)");
            Path path4 = path3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        try {
            this.patchPaperclip(paperclip, (Path)this.outputJar.get(), (Path)this.mojangJar.get(), this.minecraftVersion.get(), this.bundler);
        }
        finally {
            Files.deleteIfExists(paperclip);
        }
    }

    private final void patchPaperclip(Path paperclip, Path outputJar, Path mojangJar, String minecraftVersion2, boolean bundler) {
        Path logFile = io.papermc.paperweight.userdev.internal.util.UtilsKt.siblingLogFile(outputJar);
        Object[] objectArray = outputJar.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"outputJar.parent");
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new FileAttribute[]{};
        Path path = Files.createDirectories((Path)objectArray2, Arrays.copyOf(objectArray3, objectArray3.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createDirectories(...)");
        Path work = PathsKt.createTempDirectory((Path)path, (String)"paperclip", (FileAttribute[])new FileAttribute[0]);
        objectArray2 = new Object[]{logFile};
        UtilsKt.ensureDeleted(objectArray2);
        Path cache2 = work.resolve("cache");
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"cache");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(cache2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        objectArray3 = mojangJar;
        Path path2 = cache2.resolve("mojang_" + minecraftVersion2 + ".jar");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"cache.resolve(\"mojang_$minecraftVersion.jar\")");
        Path path3 = path2;
        CopyOption[] copyOptionArray = new CopyOption[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)objectArray3, path3, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
        Jar_runnerKt.runJar(this.javaLauncher.get(), CollectionsKt.listOf((Object)paperclip.toFile()), (Object)work, (Object)logFile, (List<String>)CollectionsKt.listOf((Object)"-Dpaperclip.patchonly=true"), new String[0]);
        if (bundler) {
            this.handleBundler(paperclip, work, outputJar);
        } else {
            this.handleOldPaperclip(work, outputJar);
        }
        objectArray3 = new Object[]{work};
        UtilsKt.ensureDeleted(objectArray3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void handleBundler(Path paperclip, Path work, Path outputJar) {
        AutoCloseable autoCloseable = NioKt.openZipSafe(paperclip);
        Throwable throwable = null;
        try {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object type$iv$iv$iv;
            Object object;
            Object object2;
            Object $receiver$iv$iv;
            FileSystemReference fs = (FileSystemReference)autoCloseable;
            boolean bl = false;
            Path root = fs.getPath("/");
            Path serverVersionJson = root.resolve("version.json");
            Gson gson = UtilsKt.getGson();
            Intrinsics.checkNotNullExpressionValue((Object)serverVersionJson, (String)"serverVersionJson");
            Iterable<Path> any$iv = serverVersionJson;
            boolean $i$f$fromJson = false;
            if (any$iv instanceof String) {
                Type type;
                void var13_16 = $this$fromJson$iv;
                Object object3 = json$iv$iv = (String)((Object)any$iv);
                Path path = $receiver$iv$iv;
                Type type2 = new TypeToken<JsonObject>(){}.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {} .type");
                Type type$iv$iv$iv2 = type2;
                if (type$iv$iv$iv2 instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv2)) {
                    Type type3 = ((ParameterizedType)type$iv$iv$iv2).getRawType();
                    type = type3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
                } else {
                    type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv2);
                }
                object2 = type;
                Object t = ((Gson)((Object)path)).fromJson((String)object3, (Type)object2);
                object = t;
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
            } else {
                $receiver$iv$iv = UtilsKt.convertToPath(any$iv);
                json$iv$iv = Charsets.UTF_8;
                OpenOption[] openOptionArray = new OpenOption[]{};
                int n = 8192;
                $receiver$iv$iv = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)$receiver$iv$iv, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)json$iv$iv), n);
                json$iv$iv = null;
                try {
                    Type type;
                    BufferedReader it$iv = (BufferedReader)$receiver$iv$iv;
                    boolean bl2 = false;
                    void $receiver$iv$iv2 = $this$fromJson$iv;
                    object2 = it$iv;
                    void $i$f$gsonTypeToken = $receiver$iv$iv2;
                    Type type4 = new TypeToken<JsonObject>(){}.getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"object : TypeToken<T>() {} .type");
                    type$iv$iv$iv = type4;
                    if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                        Type type5 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                        type = type5;
                        Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"type.rawType");
                    } else {
                        type = GsonBuilderKt.removeTypeWildcards((Type)type$iv$iv$iv);
                    }
                    Type $i$f$fromJson2 = type;
                    Object t = $i$f$gsonTypeToken.fromJson((Reader)object2, $i$f$fromJson2);
                    Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
                    it$iv = t;
                    object = it$iv;
                }
                catch (Throwable it$iv) {
                    json$iv$iv = it$iv;
                    throw it$iv;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)$receiver$iv$iv, (Throwable)json$iv$iv);
                }
            }
            String versionId = ((JsonObject)object).get("id").getAsString();
            Path path = root.resolve("META-INF/versions.list");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"root.resolve(FileEntry.VERSIONS_LIST)");
            List<String> list = Files.readAllLines(path, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
            any$iv = list;
            boolean $i$f$map = false;
            $receiver$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                type$iv$iv$iv = new char[1];
                type$iv$iv$iv[0] = 9;
                collection.add(StringsKt.split$default((CharSequence)((CharSequence)it), (char[])type$iv$iv$iv, (boolean)false, (int)0, (int)6, null));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                List it = (List)element$iv$iv;
                boolean bl4 = false;
                Pair pair = TuplesKt.to(it.get(1), it.get(2));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map versions = destination$iv$iv2;
            Path serverJarPath = work.resolve("versions/" + versions.get(versionId));
            Path path2 = outputJar.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"outputJar.parent");
            Path path3 = path2;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path3, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            Intrinsics.checkNotNullExpressionValue((Object)serverJarPath, (String)"serverJarPath");
            path3 = serverJarPath;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Path path4 = Files.copy(path3, outputJar, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length));
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"copy(...)");
            Path path5 = path4;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void handleOldPaperclip(Path work, Path outputJar) {
        Path patched;
        Object v1;
        CopyOption[] copyOptionArray;
        block2: {
            Path path = work.resolve("cache");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"work.resolve(\"cache\")");
            copyOptionArray = (CopyOption[])PathsKt.listDirectoryEntries$default((Path)path, null, (int)1, null);
            for (Object t : copyOptionArray) {
                Path it = (Path)t;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)PathsKt.getName((Path)it), (String)"patched", (boolean)false, (int)2, null)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        Path path = v1;
        if (path == null) {
            throw new IllegalStateException("Can't find patched jar!".toString());
        }
        Path path2 = patched = path;
        copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        CopyOption[] copyOptionArray2 = copyOptionArray;
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, outputJar, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
    }
}

