/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.HashingAlgorithm;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u00ba\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003\u001a(\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u001e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003\u001a\u001c\u0010\u0015\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u001a\u001c\u0010\u0015\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u001a\u001a\u0010\u001a\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0003\u001a \u0010\u001a\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u001a \u0010\u001a\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u001a\u0012\u0010\u001f\u001a\u00020\u000e*\u00020\u00032\u0006\u0010 \u001a\u00020\u0003\u001a+\u0010!\u001a\u00020\u0003*\u00020\u00032\u001a\u0010\"\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030$0#\"\u0006\u0012\u0002\b\u00030$\u00a2\u0006\u0002\u0010%\u001a\n\u0010&\u001a\u00020\u000e*\u00020\u0003\u001a0\u0010'\u001a\u00020\u000e*\u00020\u00032\u000e\b\u0002\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0014\b\u0002\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0,\u001a\u0014\u0010-\u001a\u00020.*\u00020.2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u001a\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000300*\u00020\u00032\b\b\u0002\u00101\u001a\u000202\u001a\f\u00103\u001a\u00020\u000e*\u00020\u0003H\u0002\u001a\n\u00104\u001a\u000205*\u00020\u0017\u001a\n\u00104\u001a\u000206*\u000207\u001a\u0012\u00108\u001a\u000209*\u00020\u00032\u0006\u0010:\u001a\u00020;\u001a\f\u0010<\u001a\u00020=*\u00020\u0003H\u0002\u001a\n\u0010>\u001a\u00020?*\u00020\u0003\u001a+\u0010@\u001a\u0002HA\"\f\b\u0000\u0010A*\u0006\u0012\u0002\b\u00030B*\u0002HA2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010C\u001a\u0018\u0010D\u001a\u00020\u000e*\u0006\u0012\u0002\b\u00030B2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u001a\n\u0010E\u001a\u000202*\u00020\u0003\u001a\u0010\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00030G*\u00020?\u001a)\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00030I*\u00020?2\u0012\u0010J\u001a\n\u0012\u0006\b\u0001\u0012\u00020K0#\"\u00020K\u00a2\u0006\u0002\u0010L\u001a\u0012\u0010M\u001a\u00020\u0003*\u00020\u00032\u0006\u0010N\u001a\u000202\u001a\n\u0010O\u001a\u00020?*\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0003*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001d\u0010\u0005\u001a\u00020\u0003*\n\u0012\u0006\b\u0001\u0012\u00020\u00060\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\"\u001f\u0010\u000b\u001a\u0004\u0018\u00010\u0003*\n\u0012\u0006\b\u0001\u0012\u00020\u00060\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006P"}, d2={"isWindows", "", "isLibraryJar", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)Z", "path", "Lorg/gradle/api/file/FileSystemLocation;", "getPath", "(Lorg/gradle/api/file/FileSystemLocation;)Ljava/nio/file/Path;", "Lorg/gradle/api/provider/Provider;", "(Lorg/gradle/api/provider/Provider;)Ljava/nio/file/Path;", "pathOrNull", "getPathOrNull", "relativeCopy", "", "baseDir", "file", "outputDir", "relativeCopyOrMove", "move", "relativeMove", "contentEquals", "two", "Ljava/io/InputStream;", "bufferSizeBytes", "", "convention", "Lorg/gradle/api/file/DirectoryProperty;", "project", "Lorg/gradle/api/Project;", "Lorg/gradle/api/file/RegularFileProperty;", "copyRecursivelyTo", "target", "createParentDirectories", "attributes", "", "Ljava/nio/file/attribute/FileAttribute;", "(Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/file/Path;", "deleteForcefully", "deleteRecursive", "excludes", "", "Ljava/nio/file/PathMatcher;", "preDelete", "Lkotlin/Function1;", "directory", "Ljava/lang/ProcessBuilder;", "filesMatchingRecursive", "", "glob", "", "fixWindowsPermissionsForDeletion", "gzip", "Ljava/util/zip/GZIPInputStream;", "Ljava/util/zip/GZIPOutputStream;", "Ljava/io/OutputStream;", "hashFile", "", "algorithm", "Lio/papermc/paperweight/util/HashingAlgorithm;", "jarUri", "Ljava/net/URI;", "openZip", "Ljava/nio/file/FileSystem;", "pathProvider", "P", "Lorg/gradle/api/file/FileSystemLocationProperty;", "(Lorg/gradle/api/file/FileSystemLocationProperty;Lorg/gradle/api/provider/Provider;)Lorg/gradle/api/file/FileSystemLocationProperty;", "set", "sha256asHex", "walk", "Ljava/util/stream/Stream;", "walkSequence", "Lkotlin/sequences/Sequence;", "options", "Lkotlin/io/path/PathWalkOption;", "(Ljava/nio/file/FileSystem;[Lkotlin/io/path/PathWalkOption;)Lkotlin/sequences/Sequence;", "withDifferentExtension", "ext", "writeZip", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nfile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 file.kt\nio/papermc/paperweight/util/FileKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n1#2:253\n1755#3,3:254\n1863#3,2:257\n1863#3,2:259\n*S KotlinDebug\n*F\n+ 1 file.kt\nio/papermc/paperweight/util/FileKt\n*L\n77#1:254,3\n90#1:257,2\n91#1:259,2\n*E\n"})
public final class FileKt {
    private static final boolean isWindows;

    public static final void set(@NotNull FileSystemLocationProperty<?> $this$set, @Nullable Path path) {
        Intrinsics.checkNotNullParameter($this$set, (String)"<this>");
        Path path2 = path;
        $this$set.set(path2 != null ? path2.toFile() : null);
    }

    @NotNull
    public static final <P extends FileSystemLocationProperty<?>> P pathProvider(@NotNull P $this$pathProvider, @NotNull Provider<Path> path) {
        P p;
        Intrinsics.checkNotNullParameter($this$pathProvider, (String)"<this>");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        P $this$pathProvider_u24lambda_u240 = p = $this$pathProvider;
        boolean bl = false;
        $this$pathProvider_u24lambda_u240.fileProvider(path.map((Transformer)pathProvider.1.1.INSTANCE));
        return p;
    }

    @NotNull
    public static final DirectoryProperty convention(@NotNull DirectoryProperty $this$convention, @NotNull Project project, @NotNull Provider<Path> path) {
        Intrinsics.checkNotNullParameter((Object)$this$convention, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        DirectoryProperty directoryProperty = $this$convention.convention(project.getLayout().dir(path.map((Transformer)convention.1.INSTANCE)));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"convention(project.layou\u2026ath.map { it.toFile() }))");
        return directoryProperty;
    }

    @NotNull
    public static final RegularFileProperty convention(@NotNull RegularFileProperty $this$convention, @NotNull Project project, @NotNull Provider<Path> path) {
        Intrinsics.checkNotNullParameter((Object)$this$convention, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        RegularFileProperty regularFileProperty = $this$convention.convention(project.getLayout().file(path.map((Transformer)convention.2.INSTANCE)));
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"convention(project.layou\u2026ath.map { it.toFile() }))");
        return regularFileProperty;
    }

    @NotNull
    public static final DirectoryProperty convention(@NotNull DirectoryProperty $this$convention, @NotNull Project project, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$convention, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        DirectoryProperty directoryProperty = $this$convention.convention(project.getLayout().dir(project.provider(new Callable(path){
            final /* synthetic */ Path $path;
            {
                this.$path = $path;
            }

            public final File call() {
                return this.$path.toFile();
            }
        })));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"path: Path) = convention\u2026vider { path.toFile() }))");
        return directoryProperty;
    }

    public static final boolean isLibraryJar(@NotNull Path $this$isLibraryJar) {
        Intrinsics.checkNotNullParameter((Object)$this$isLibraryJar, (String)"<this>");
        return StringsKt.endsWith$default((String)PathsKt.getName((Path)$this$isLibraryJar), (String)".jar", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)PathsKt.getName((Path)$this$isLibraryJar), (String)"-sources.jar", (boolean)false, (int)2, null);
    }

    public static final void deleteForcefully(@NotNull Path $this$deleteForcefully) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteForcefully, (String)"<this>");
        FileKt.fixWindowsPermissionsForDeletion($this$deleteForcefully);
        Files.deleteIfExists($this$deleteForcefully);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void deleteRecursive(@NotNull Path $this$deleteRecursive, @NotNull Iterable<? extends PathMatcher> excludes, @NotNull Function1<? super Path, Unit> preDelete) {
        Path f;
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)$this$deleteRecursive, (String)"<this>");
        Intrinsics.checkNotNullParameter(excludes, (String)"excludes");
        Intrinsics.checkNotNullParameter(preDelete, (String)"preDelete");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($this$deleteRecursive, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.isDirectory($this$deleteRecursive, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            boolean bl;
            block14: {
                Iterable<? extends PathMatcher> $this$any$iv = excludes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator<? extends PathMatcher> iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        PathMatcher element$iv;
                        PathMatcher it = element$iv = iterator2.next();
                        boolean bl2 = false;
                        if (!it.matches($this$deleteRecursive)) continue;
                        bl = true;
                        break block14;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
            preDelete.invoke((Object)$this$deleteRecursive);
            FileKt.fixWindowsPermissionsForDeletion($this$deleteRecursive);
            Files.deleteIfExists($this$deleteRecursive);
            return;
        }
        AutoCloseable $i$f$any = Files.walk($this$deleteRecursive, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)$i$f$any;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"stream");
            iterator = SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)((Function1)new Function1<Path, Boolean>(excludes){
                final /* synthetic */ Iterable<PathMatcher> $excludes;
                {
                    this.$excludes = $excludes;
                    super(1);
                }

                public final Boolean invoke(Path file2) {
                    boolean bl;
                    block3: {
                        Iterable<PathMatcher> $this$any$iv = this.$excludes;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            Iterator<PathMatcher> iterator = $this$any$iv.iterator();
                            while (iterator.hasNext()) {
                                PathMatcher element$iv;
                                PathMatcher it = element$iv = iterator.next();
                                boolean bl2 = false;
                                if (!it.matches(file2)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
            })));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)$i$f$any, (Throwable)throwable);
        }
        List fileList2 = iterator;
        Iterable $this$forEach$iv = fileList2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            f = (Path)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)f, (String)"f");
            FileKt.fixWindowsPermissionsForDeletion(f);
        }
        $this$forEach$iv = CollectionsKt.asReversed((List)fileList2);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            f = (Path)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)f, (String)"f");
            preDelete.invoke((Object)f);
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (Files.isRegularFile(f, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                Files.deleteIfExists(f);
                continue;
            }
            LinkOption[] linkOptionArray4 = new LinkOption[]{};
            if (!Files.isDirectory(f, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length)) || !PathsKt.listDirectoryEntries$default((Path)f, null, (int)1, null).isEmpty()) continue;
            Files.deleteIfExists(f);
        }
    }

    public static /* synthetic */ void deleteRecursive$default(Path path, Iterable iterable, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            function1 = deleteRecursive.1.INSTANCE;
        }
        FileKt.deleteRecursive(path, iterable, (Function1<? super Path, Unit>)function1);
    }

    private static final void fixWindowsPermissionsForDeletion(Path $this$fixWindowsPermissionsForDeletion) {
        block7: {
            block6: {
                if (!isWindows) break block6;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.notExists($this$fixWindowsPermissionsForDeletion, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block7;
            }
            return;
        }
        Path path = $this$fixWindowsPermissionsForDeletion;
        try {
            Path $this$fixWindowsPermissionsForDeletion_u24lambda_u245 = path;
            boolean bl = false;
            Path path2 = $this$fixWindowsPermissionsForDeletion_u24lambda_u245;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            DosFileAttributeView dosFileAttributeView = Files.getFileAttributeView(path2, DosFileAttributeView.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            if (dosFileAttributeView == null) {
                PathsKt.fileAttributeViewNotAvailable((Path)path2, DosFileAttributeView.class);
                throw new KotlinNothingValueException();
            }
            DosFileAttributeView dosAttr = dosFileAttributeView;
            dosAttr.setHidden(false);
            dosAttr.setReadOnly(false);
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyRecursivelyTo(@NotNull Path $this$copyRecursivelyTo, @NotNull Path target) {
        Intrinsics.checkNotNullParameter((Object)$this$copyRecursivelyTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(target, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($this$copyRecursivelyTo, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        AutoCloseable autoCloseable = Files.walk($this$copyRecursivelyTo, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            Iterator iterator = stream.iterator();
            while (iterator.hasNext()) {
                Path f = (Path)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)f, (String)"f");
                Path targetPath = target.resolve(PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)f, (Path)$this$copyRecursivelyTo)));
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.isDirectory(f, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    Intrinsics.checkNotNullExpressionValue((Object)targetPath, (String)"targetPath");
                    FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(targetPath, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"createDirectories(...)");
                    continue;
                }
                Path path = f;
                Intrinsics.checkNotNullExpressionValue((Object)targetPath, (String)"targetPath");
                Path path2 = targetPath;
                CopyOption[] copyOptionArray = new CopyOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path, path2, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final GZIPInputStream gzip(@NotNull InputStream $this$gzip) {
        Intrinsics.checkNotNullParameter((Object)$this$gzip, (String)"<this>");
        return new GZIPInputStream($this$gzip);
    }

    @NotNull
    public static final GZIPOutputStream gzip(@NotNull OutputStream $this$gzip) {
        Intrinsics.checkNotNullParameter((Object)$this$gzip, (String)"<this>");
        return new GZIPOutputStream($this$gzip);
    }

    @NotNull
    public static final ProcessBuilder directory(@NotNull ProcessBuilder $this$directory, @Nullable Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$directory, (String)"<this>");
        Path path2 = path;
        ProcessBuilder processBuilder = $this$directory.directory(path2 != null ? path2.toFile() : null);
        Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"directory(path?.toFile())");
        return processBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] hashFile(@NotNull Path $this$hashFile, @NotNull HashingAlgorithm algorithm) {
        byte[] byArray2;
        Intrinsics.checkNotNullParameter((Object)$this$hashFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream($this$hashFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            byArray2 = UtilsKt.hash$default(input, algorithm, 0, 2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray2;
    }

    @NotNull
    public static final String sha256asHex(@NotNull Path $this$sha256asHex) {
        Intrinsics.checkNotNullParameter((Object)$this$sha256asHex, (String)"<this>");
        return UtilsKt.asHexString(FileKt.hashFile($this$sha256asHex, HashingAlgorithm.SHA256));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean contentEquals(@NotNull Path $this$contentEquals, @NotNull InputStream two, int bufferSizeBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$contentEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)two, (String)"two");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream($this$contentEquals, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            block9: {
                int readOne;
                InputStream one = (InputStream)closeable;
                boolean bl = false;
                byte[] bufOne = new byte[bufferSizeBytes];
                byte[] bufTwo = new byte[bufferSizeBytes];
                do {
                    int readTwo;
                    if ((readOne = one.read(bufOne)) != (readTwo = two.read(bufTwo))) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    if (readOne == -1) break block9;
                } while (Arrays.equals(bufOne, 0, readOne, bufTwo, 0, readOne));
                boolean bl3 = false;
                return bl3;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return true;
    }

    public static /* synthetic */ boolean contentEquals$default(Path path, InputStream inputStream, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        return FileKt.contentEquals(path, inputStream, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean contentEquals(@NotNull Path $this$contentEquals, @NotNull Path file2, int bufferSizeBytes) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$contentEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(file2, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream two = (InputStream)closeable;
            boolean bl2 = false;
            bl = FileKt.contentEquals($this$contentEquals, two, bufferSizeBytes);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return bl;
    }

    public static /* synthetic */ boolean contentEquals$default(Path path, Path path2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        return FileKt.contentEquals(path, path2, n);
    }

    @NotNull
    public static final Path withDifferentExtension(@NotNull Path $this$withDifferentExtension, @NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)$this$withDifferentExtension, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        Path path = $this$withDifferentExtension.resolveSibling(PathsKt.getNameWithoutExtension((Path)$this$withDifferentExtension) + "." + ext);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(\"$nameWithoutExtension.$ext\")");
        return path;
    }

    public static final void relativeCopy(@NotNull Path baseDir, @NotNull Path file2, @NotNull Path outputDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        FileKt.relativeCopyOrMove(baseDir, file2, outputDir, false);
    }

    public static final void relativeMove(@NotNull Path baseDir, @NotNull Path file2, @NotNull Path outputDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        FileKt.relativeCopyOrMove(baseDir, file2, outputDir, true);
    }

    private static final void relativeCopyOrMove(Path baseDir, Path file2, Path outputDir, boolean move) {
        Path destination = outputDir.resolve(PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)file2, (Path)baseDir)));
        Path path = destination.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"destination.parent");
        Path path2 = path;
        Object object = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"createDirectories(...)");
        if (move) {
            path2 = file2;
            Intrinsics.checkNotNullExpressionValue((Object)destination, (String)"destination");
            object = destination;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.move(path2, (Path)object, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"move(...)");
        } else {
            path2 = file2;
            Intrinsics.checkNotNullExpressionValue((Object)destination, (String)"destination");
            object = destination;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray3 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, (Path)object, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"copy(...)");
        }
    }

    @NotNull
    public static final Path createParentDirectories(@NotNull Path $this$createParentDirectories, FileAttribute<?> ... attributes) {
        Path path;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$createParentDirectories, (String)"<this>");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            Path it = path = $this$createParentDirectories;
            boolean bl = false;
            Path parent = it.getParent();
            if (parent != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isDirectory(parent, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    try {
                        FileAttribute<?>[] fileAttributeArray = Arrays.copyOf(attributes, attributes.length);
                        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(parent, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
                    }
                    catch (FileAlreadyExistsException e) {
                        LinkOption[] linkOptionArray2 = new LinkOption[]{};
                        if (Files.isDirectory(parent, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block4;
                        throw e;
                    }
                }
            }
        }
        return path;
    }

    @NotNull
    public static final Path getPath(@NotNull FileSystemLocation $this$path) {
        Intrinsics.checkNotNullParameter((Object)$this$path, (String)"<this>");
        Path path = $this$path.getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"asFile.toPath()");
        return path;
    }

    @NotNull
    public static final Path getPath(@NotNull Provider<? extends FileSystemLocation> $this$path) {
        Intrinsics.checkNotNullParameter($this$path, (String)"<this>");
        return FileKt.getPath((FileSystemLocation)$this$path.get());
    }

    @Nullable
    public static final Path getPathOrNull(@NotNull Provider<? extends FileSystemLocation> $this$pathOrNull) {
        Intrinsics.checkNotNullParameter($this$pathOrNull, (String)"<this>");
        FileSystemLocation fileSystemLocation = (FileSystemLocation)$this$pathOrNull.getOrNull();
        return fileSystemLocation != null ? FileKt.getPath(fileSystemLocation) : null;
    }

    private static final URI jarUri(Path $this$jarUri) {
        URI uRI = URI.create("jar:" + $this$jarUri.toUri());
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(\"jar:${toUri()}\")");
        return uRI;
    }

    @NotNull
    public static final FileSystem openZip(@NotNull Path $this$openZip) {
        FileSystem fileSystem;
        Intrinsics.checkNotNullParameter((Object)$this$openZip, (String)"<this>");
        try {
            FileSystem fileSystem2 = FileSystems.getFileSystem(FileKt.jarUri($this$openZip));
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem2, (String)"{\n        FileSystems.ge\u2026ileSystem(jarUri())\n    }");
            fileSystem = fileSystem2;
        }
        catch (FileSystemNotFoundException e) {
            FileSystem fileSystem3 = FileSystems.newFileSystem(FileKt.jarUri($this$openZip), MapsKt.emptyMap());
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem3, (String)"{\n        FileSystems.ne\u2026Map<String, Any>())\n    }");
            fileSystem = fileSystem3;
        }
        return fileSystem;
    }

    @NotNull
    public static final FileSystem writeZip(@NotNull Path $this$writeZip) {
        Intrinsics.checkNotNullParameter((Object)$this$writeZip, (String)"<this>");
        FileSystem fileSystem = FileSystems.newFileSystem(FileKt.jarUri($this$writeZip), MapsKt.mapOf((Pair)TuplesKt.to((Object)"create", (Object)"true")));
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"newFileSystem(jarUri(), mapOf(\"create\" to \"true\"))");
        return fileSystem;
    }

    @NotNull
    public static final Sequence<Path> walkSequence(@NotNull FileSystem $this$walkSequence, PathWalkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)$this$walkSequence, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Stream<Path> stream = StreamSupport.stream($this$walkSequence.getRootDirectories().spliterator(), false);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(rootDirectories.spliterator(), false)");
        return SequencesKt.flatMap((Sequence)StreamsKt.asSequence(stream), (Function1)((Function1)new Function1<Path, Sequence<? extends Path>>(options){
            final /* synthetic */ PathWalkOption[] $options;
            {
                this.$options = $options;
                super(1);
            }

            public final Sequence<Path> invoke(Path it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return PathsKt.walk((Path)it, (PathWalkOption[])Arrays.copyOf(this.$options, this.$options.length));
            }
        }));
    }

    @NotNull
    public static final Stream<Path> walk(@NotNull FileSystem $this$walk) {
        Intrinsics.checkNotNullParameter((Object)$this$walk, (String)"<this>");
        Stream<Path> stream = StreamSupport.stream($this$walk.getRootDirectories().spliterator(), false).flatMap(walk.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(rootDirectories.s\u2026latMap { Files.walk(it) }");
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> filesMatchingRecursive(@NotNull Path $this$filesMatchingRecursive, @NotNull String glob) {
        List<Path> list;
        Intrinsics.checkNotNullParameter((Object)$this$filesMatchingRecursive, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)glob, (String)"glob");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($this$filesMatchingRecursive, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return CollectionsKt.emptyList();
        }
        PathMatcher matcher = $this$filesMatchingRecursive.getFileSystem().getPathMatcher("glob:" + glob);
        AutoCloseable autoCloseable = Files.walk($this$filesMatchingRecursive, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            List<Path> list2 = stream.filter(new Predicate(matcher){
                final /* synthetic */ PathMatcher $matcher;
                {
                    this.$matcher = $matcher;
                }

                public final boolean test(Path it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && this.$matcher.matches(it.getFileName());
                }
            }).collect(Collectors.toList());
            list = list2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue(list, (String)"walk(this).use { stream \u2026ollectors.toList())\n    }");
        return list;
    }

    public static /* synthetic */ List filesMatchingRecursive$default(Path path, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "*";
        }
        return FileKt.filesMatchingRecursive(path, string);
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        isWindows = StringsKt.contains((CharSequence)string, (CharSequence)"windows", (boolean)true);
    }
}

