/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.util.Command;
import io.papermc.paperweight.util.Git;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import paper.libs.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a<\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"checkoutRepoFromUpstream", "", "git", "Lio/papermc/paperweight/util/Git;", "upstream", "Ljava/nio/file/Path;", "upstreamBranch", "", "upstreamName", "branchName", "ref", "", "paperweight-lib"})
public final class GitKt {
    public static final void checkoutRepoFromUpstream(@NotNull Git git, @NotNull Path upstream, @NotNull String upstreamBranch, @NotNull String upstreamName, @NotNull String branchName, boolean ref) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)upstream, (String)"upstream");
        Intrinsics.checkNotNullParameter((Object)upstreamBranch, (String)"upstreamBranch");
        Intrinsics.checkNotNullParameter((Object)upstreamName, (String)"upstreamName");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        String[] stringArray = new String[]{"init", "--quiet"};
        Command.executeSilently$default(git.invoke(stringArray), false, true, 1, null);
        git.disableAutoGpgSigningInRepo();
        stringArray = new String[]{"remote", "remove", upstreamName};
        Command.runSilently$default(git.invoke(stringArray), false, true, 1, null);
        stringArray = new String[4];
        stringArray[0] = "remote";
        stringArray[1] = "add";
        stringArray[2] = upstreamName;
        Intrinsics.checkNotNullExpressionValue((Object)upstream.toUri().toString(), (String)"upstream.toUri().toString()");
        Command.executeSilently$default(git.invoke(stringArray), false, true, 1, null);
        stringArray = new String[]{"fetch", upstreamName, "--prune", "--prune-tags", "--force"};
        Command.executeSilently$default(git.invoke(stringArray), false, true, 1, null);
        stringArray = new String[]{"checkout", branchName};
        if (Command.runSilently$default(git.invoke(stringArray), false, true, 1, null) != 0) {
            stringArray = new String[]{"checkout", "-b", branchName};
            Command.runSilently$default(git.invoke(stringArray), false, true, 1, null);
        }
        stringArray = new String[]{"reset", "--hard", ref ? upstreamBranch : upstreamName + "/" + upstreamBranch};
        Command.executeSilently$default(git.invoke(stringArray), false, true, 1, null);
        stringArray = new String[]{"gc"};
        Command.runSilently$default(git.invoke(stringArray), false, true, 1, null);
    }

    public static /* synthetic */ void checkoutRepoFromUpstream$default(Git git, Path path, String string, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "upstream";
        }
        if ((n & 0x10) != 0) {
            string3 = "master";
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        GitKt.checkoutRepoFromUpstream(git, path, string, string2, string3, bl);
    }
}

