/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.DownloadService;
import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.FileSystemReference;
import io.papermc.paperweight.util.HashingAlgorithm;
import io.papermc.paperweight.util.InputStreamProvider;
import io.papermc.paperweight.util.NioKt;
import io.papermc.paperweight.util.PathJsonConverter;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.constants.ConstantsKt;
import io.papermc.paperweight.util.data.mache.MacheMeta;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.gradle.api.Action;
import org.gradle.api.PolymorphicDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.kotlin.dsl.NamedDomainObjectContainerExtensionsKt;
import org.gradle.kotlin.dsl.RegisteringDomainObjectDelegateProviderWithType;
import org.gradle.kotlin.dsl.RegisteringDomainObjectDelegateProviderWithTypeAndAction;
import paper.libs.com.github.salomonbrys.kotson.GsonBuilderKt;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.GsonBuilder;
import paper.libs.com.google.gson.reflect.TypeToken;
import paper.libs.dev.denwav.hypo.model.ClassProviderRoot;
import paper.libs.kotlinx.coroutines.ExecutorCoroutineDispatcher;
import paper.libs.kotlinx.coroutines.ExecutorsKt;
import paper.libs.org.cadixdev.lorenz.merge.MergeResult;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u00ce\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010+\u001a\u00020,\u001a\u0014\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H'0\u0001\"\u0004\b\u0000\u0010'\u001a\u001f\u0010-\u001a\u00020.2\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020100\"\u000201\u00a2\u0006\u0002\u00102\u001a\u001f\u00103\u001a\u00020.2\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020100\"\u000201\u00a2\u0006\u0002\u00102\u001a\u000e\u00104\u001a\u00020\u00152\u0006\u00105\u001a\u00020\u0015\u001a\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\r\u001a\u0006\u00109\u001a\u00020\"\u001a\b\u0010:\u001a\u00020;H\u0002\u001a1\u0010<\u001a\u00020.2\u0006\u0010=\u001a\u00020\u00152\b\b\u0002\u0010>\u001a\u00020\"2\u0017\u0010?\u001a\u0013\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020.0@\u00a2\u0006\u0002\bB\u001a!\u0010C\u001a\u00020.\"\u0006\b\u0000\u0010D\u0018\u00012\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020GH\u0086\b\u001a\u001c\u0010H\u001a\b\u0012\u0004\u0012\u00020.0I2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M\u001a\n\u0010N\u001a\u00020\r*\u00020O\u001a\u0012\u0010P\u001a\u00020Q*\u00020\u00162\u0006\u0010=\u001a\u00020\r\u001a\n\u0010R\u001a\u00020\r*\u00020\r\u001a\u001d\u0010S\u001a\u0002HD\"\f\b\u0000\u0010D*\u0006\u0012\u0002\b\u00030T*\u0002HD\u00a2\u0006\u0002\u0010U\u001a\n\u0010V\u001a\u00020\u0015*\u00020\u0015\u001a\n\u0010W\u001a\u00020\u0015*\u00020\u0015\u001a@\u0010X\u001a\b\u0012\u0004\u0012\u0002H'0\u001a\"\n\b\u0000\u0010'\u0018\u0001*\u000201*\u00020\u001c2\u0006\u0010Y\u001a\u00020Z2\u0014\b\u0004\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H'0@H\u0086\b\u00f8\u0001\u0000\u001a \u0010\\\u001a\b\u0012\u0004\u0012\u00020]0\u001a*\u0002012\u0006\u0010^\u001a\u00020\u00162\u0006\u0010_\u001a\u00020$\u001a\n\u0010`\u001a\u00020\u0015*\u000201\u001a\u000e\u0010a\u001a\u0004\u0018\u00010\u0015*\u0004\u0018\u000101\u001a\n\u0010b\u001a\u00020c*\u000201\u001a\u0018\u0010d\u001a\b\u0012\u0004\u0012\u00020e0\u001a*\u00020f2\u0006\u0010g\u001a\u00020\u001c\u001a\n\u0010h\u001a\u00020Z*\u00020i\u001a\u0012\u0010h\u001a\u00020Z*\u00020i2\u0006\u0010j\u001a\u00020\r\u001a\u001a\u0010h\u001a\u00020Z*\u00020i2\u0006\u00108\u001a\u00020\r2\u0006\u0010j\u001a\u00020\r\u001a.\u0010k\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H'0\u001a\"\b\b\u0000\u0010'*\u00020l*\n\u0012\u0006\b\u0001\u0012\u0002H'0\u001a2\u0006\u0010g\u001a\u00020\u001c\u001a\u001d\u0010m\u001a\u0002HD\"\f\b\u0000\u0010D*\u0006\u0012\u0002\b\u00030T*\u0002HD\u00a2\u0006\u0002\u0010U\u001a\"\u0010n\u001a\u0002H'\"\u0006\b\u0000\u0010'\u0018\u0001*\u00020\u00042\u0006\u0010o\u001a\u000201H\u0086\b\u00a2\u0006\u0002\u0010p\u001a\u001c\u0010q\u001a\u00020O*\u00020K2\u0006\u0010r\u001a\u00020s2\b\b\u0002\u0010t\u001a\u00020;\u001a\u0012\u0010q\u001a\u00020O*\u00020\r2\u0006\u0010r\u001a\u00020s\u001a\"\u0010q\u001a\u00020O*\b\u0012\u0004\u0012\u00020v0u2\u0006\u0010r\u001a\u00020s2\b\b\u0002\u0010t\u001a\u00020;\u001a-\u0010<\u001a\u00020.*\u00020w2\b\b\u0002\u0010>\u001a\u00020\"2\u0017\u0010?\u001a\u0013\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020.0@\u00a2\u0006\u0002\bB\u001a\n\u0010x\u001a\u00020\"*\u00020\u001c\u001aJ\u0010y\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H'0z0\u001a\"\u0006\b\u0000\u0010'\u0018\u0001*\u00020{2\"\u0010_\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u0002H'0\u001a00\"\n\u0012\u0006\b\u0001\u0012\u0002H'0\u001aH\u0086\b\u00a2\u0006\u0002\u0010|\u001a(\u0010}\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u007f\u0012\u0004\u0012\u0002H'0~\"\u000b\b\u0000\u0010'\u0018\u0001*\u00030\u0080\u0001*\u00020\u007fH\u0086\b\u001aH\u0010}\u001a\u0011\u0012\u0006\b\u0001\u0012\u00020\u007f\u0012\u0004\u0012\u0002H'0\u0081\u0001\"\u000b\b\u0000\u0010'\u0018\u0001*\u00030\u0080\u0001*\u00020\u007f2\u001a\b\b\u0010\u0082\u0001\u001a\u0013\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u00020.0@\u00a2\u0006\u0002\bBH\u0086\b\u00f8\u0001\u0000\u001a\r\u0010\u0083\u0001\u001a\u00030\u0084\u0001*\u00030\u0085\u0001\u001a\r\u0010\u0083\u0001\u001a\u00030\u0084\u0001*\u00030\u0086\u0001\u001a\u0014\u0010\u0087\u0001\u001a\n\u0012\u0005\u0012\u00030\u0089\u00010\u0088\u0001*\u00030\u0086\u0001\u001a\u0011\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020Q0\u001a*\u00020\u001c\u001a\u0011\u0010\u008b\u0001\u001a\b\u0012\u0004\u0012\u00020\"0\u001a*\u00020$\"\u0016\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"!\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a*\u00020\u001c8F\u00a2\u0006\f\u0012\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \"\u0015\u0010!\u001a\u00020\"*\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010#\"\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001a*\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010%\"#\u0010&\u001a\u0004\u0018\u0001H'\"\u0004\b\u0000\u0010'*\b\u0012\u0004\u0012\u0002H'0(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u008c\u0001"}, d2={"emptyMergeResult", "Lpaper/libs/org/cadixdev/lorenz/merge/MergeResult;", "", "gson", "Lpaper/libs/com/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "hexChars", "", "ioDispatcherCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "mainCapabilityAttribute", "Lorg/gradle/api/attributes/Attribute;", "", "getMainCapabilityAttribute", "()Lorg/gradle/api/attributes/Attribute;", "redirectThreadCount", "Ljava/util/concurrent/atomic/AtomicLong;", "getRedirectThreadCount", "()Ljava/util/concurrent/atomic/AtomicLong;", "cache", "Ljava/nio/file/Path;", "Lorg/gradle/api/file/ProjectLayout;", "getCache", "(Lorg/gradle/api/file/ProjectLayout;)Ljava/nio/file/Path;", "download", "Lorg/gradle/api/provider/Provider;", "Lio/papermc/paperweight/DownloadService;", "Lorg/gradle/api/Project;", "getDownload$annotations", "(Lorg/gradle/api/Project;)V", "getDownload", "(Lorg/gradle/api/Project;)Lorg/gradle/api/provider/Provider;", "isBaseExecution", "", "(Lorg/gradle/api/Project;)Z", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/provider/ProviderFactory;)Lorg/gradle/api/provider/Provider;", "orNull", "T", "Ljava/util/Optional;", "getOrNull", "(Ljava/util/Optional;)Ljava/lang/Object;", "commentRegex", "Lkotlin/text/Regex;", "ensureDeleted", "", "files", "", "", "([Ljava/lang/Object;)V", "ensureParentExists", "findOutputDir", "baseFile", "ioDispatcher", "Lpaper/libs/kotlinx/coroutines/ExecutorCoroutineDispatcher;", "name", "isIDEASync", "javaVersion", "", "modifyManifest", "path", "create", "op", "Lkotlin/Function1;", "Ljava/util/jar/Manifest;", "Lkotlin/ExtensionFunctionType;", "printId", "P", "pluginId", "gradle", "Lorg/gradle/api/invocation/Gradle;", "redirect", "Ljava/util/concurrent/CompletableFuture;", "input", "Ljava/io/InputStream;", "out", "Ljava/io/OutputStream;", "asHexString", "", "cacheDir", "Lorg/gradle/api/file/Directory;", "capitalized", "changesDisallowed", "Lorg/gradle/api/provider/Property;", "(Lorg/gradle/api/provider/Property;)Lorg/gradle/api/provider/Property;", "cleanDir", "cleanFile", "contents", "contentFile", "Lorg/gradle/api/file/RegularFileProperty;", "convert", "convertToFileProvider", "Lorg/gradle/api/file/RegularFile;", "layout", "providers", "convertToPath", "convertToPathOrNull", "convertToUrl", "Ljava/net/URL;", "defaultJavaLauncher", "Lorg/gradle/jvm/toolchain/JavaLauncher;", "Lorg/gradle/jvm/toolchain/JavaToolchainService;", "project", "defaultOutput", "Lio/papermc/paperweight/tasks/BaseTask;", "ext", "fileExists", "Lorg/gradle/api/file/FileSystemLocation;", "finalizedOnRead", "fromJson", "any", "(Lcom/google/gson/Gson;Ljava/lang/Object;)Ljava/lang/Object;", "hash", "algorithm", "Lio/papermc/paperweight/util/HashingAlgorithm;", "bufferSize", "", "Lio/papermc/paperweight/util/InputStreamProvider;", "Ljava/nio/file/FileSystem;", "offlineMode", "providerSet", "", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;[Lorg/gradle/api/provider/Provider;)Lorg/gradle/api/provider/Provider;", "registering", "Lorg/gradle/kotlin/dsl/RegisteringDomainObjectDelegateProviderWithType;", "Lorg/gradle/api/tasks/TaskContainer;", "Lorg/gradle/api/Task;", "Lorg/gradle/kotlin/dsl/RegisteringDomainObjectDelegateProviderWithTypeAndAction;", "configuration", "resolveMacheMeta", "Lio/papermc/paperweight/util/data/mache/MacheMeta;", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "Lorg/gradle/api/file/FileCollection;", "toJarClassProviderRoots", "", "Lpaper/libs/dev/denwav/hypo/model/ClassProviderRoot;", "upstreamsDirectory", "verboseApplyPatches", "paperweight-lib"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\nio/papermc/paperweight/util/UtilsKt\n+ 2 Gson.kt\ncom/github/salomonbrys/kotson/GsonKt\n+ 3 GsonBuilder.kt\ncom/github/salomonbrys/kotson/GsonBuilderKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 ExtensionContainerExtensions.kt\norg/gradle/kotlin/dsl/ExtensionContainerExtensionsKt\n+ 7 TypeOfExtensions.kt\norg/gradle/kotlin/dsl/TypeOfExtensionsKt\n+ 8 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 9 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 10 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n*L\n1#1,503:1\n17#2:504\n19#2:512\n17#2:535\n61#3:505\n13#3:506\n63#3,4:507\n61#3:513\n13#3:514\n63#3,4:515\n61#3:536\n13#3:537\n63#3,4:538\n1#4:511\n13484#5,3:519\n123#6:522\n28#7:523\n739#8,9:524\n37#9,2:533\n68#10:542\n*S KotlinDebug\n*F\n+ 1 utils.kt\nio/papermc/paperweight/util/UtilsKt\n*L\n98#1:504\n99#1:512\n445#1:535\n98#1:505\n98#1:506\n98#1:507,4\n99#1:513\n99#1:514\n99#1:515,4\n445#1:536\n445#1:537\n445#1:538,4\n373#1:519,3\n387#1:522\n387#1:523\n402#1:524,9\n402#1:533,2\n455#1:542\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final Gson gson;
    @NotNull
    private static final AtomicLong redirectThreadCount;
    @NotNull
    private static final MergeResult emptyMergeResult;
    @NotNull
    private static final char[] hexChars;
    @NotNull
    private static final Attribute<String> mainCapabilityAttribute;
    @NotNull
    private static final AtomicInteger ioDispatcherCount;

    @NotNull
    public static final Gson getGson() {
        return gson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T> T fromJson(Gson $this$fromJson, Object any2) {
        Object t;
        Intrinsics.checkNotNullParameter((Object)$this$fromJson, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)any2, (String)"any");
        boolean $i$f$fromJson = false;
        if (any2 instanceof String) {
            Type type;
            void $receiver$iv;
            String json$iv;
            Gson gson = $this$fromJson;
            String string = json$iv = (String)any2;
            void var6_12 = $receiver$iv;
            Intrinsics.needClassReification();
            Type type2 = new TypeToken<T>(){}.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {} .type");
            Type type$iv$iv = type2;
            if (type$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv)) {
                Type type3 = ((ParameterizedType)type$iv$iv).getRawType();
                type = type3;
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
            } else {
                type = GsonBuilderKt.removeTypeWildcards(type$iv$iv);
            }
            Type type4 = type;
            Object t2 = var6_12.fromJson(string, type4);
            t = t2;
            Intrinsics.checkExpressionValueIsNotNull(t2, (String)"fromJson(json, typeToken<T>())");
        } else {
            Object object = UtilsKt.convertToPath(any2);
            Object object2 = Charsets.UTF_8;
            OpenOption[] openOptionArray = new OpenOption[]{};
            int n = 8192;
            object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
            object2 = null;
            try {
                Type type;
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                Gson $receiver$iv = $this$fromJson;
                Reader reader = it;
                Gson gson = $receiver$iv;
                Intrinsics.needClassReification();
                Type type5 = new TypeToken<T>(){}.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"object : TypeToken<T>() {} .type");
                Type type$iv$iv = type5;
                if (type$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv)) {
                    Type type6 = ((ParameterizedType)type$iv$iv).getRawType();
                    type = type6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"type.rawType");
                } else {
                    type = GsonBuilderKt.removeTypeWildcards(type$iv$iv);
                }
                Type type7 = type;
                Object t3 = gson.fromJson(reader, type7);
                Intrinsics.checkExpressionValueIsNotNull(t3, (String)"fromJson(json, typeToken<T>())");
                Object t4 = t3;
                t = t4;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                InlineMarker.finallyEnd((int)1);
            }
        }
        return t;
    }

    @NotNull
    public static final Path getCache(@NotNull ProjectLayout $this$cache) {
        Intrinsics.checkNotNullParameter((Object)$this$cache, (String)"<this>");
        Directory directory = $this$cache.getProjectDirectory().dir(".gradle/caches");
        Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"projectDirectory.dir(\".gradle/$CACHE_PATH\")");
        return FileKt.getPath((FileSystemLocation)directory);
    }

    @NotNull
    public static final Directory cacheDir(@NotNull ProjectLayout $this$cacheDir, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$cacheDir, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Directory directory = $this$cacheDir.getProjectDirectory().dir(".gradle/caches").dir(path);
        Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"projectDirectory.dir(\".g\u2026e/$CACHE_PATH\").dir(path)");
        return directory;
    }

    public static final boolean offlineMode(@NotNull Project $this$offlineMode) {
        Intrinsics.checkNotNullParameter((Object)$this$offlineMode, (String)"<this>");
        return $this$offlineMode.getGradle().getStartParameter().isOffline();
    }

    @NotNull
    public static final <T extends FileSystemLocation> Provider<? extends T> fileExists(@NotNull Provider<? extends T> $this$fileExists, @NotNull Project project) {
        Intrinsics.checkNotNullParameter($this$fileExists, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Provider provider = $this$fileExists.flatMap(new Transformer(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public final Provider<? extends T> transform(T it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.$project.provider(new Callable(it){
                    final /* synthetic */ T $it;
                    {
                        this.$it = $it;
                    }

                    public final T call() {
                        T t;
                        T f = t = this.$it;
                        boolean bl = false;
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        return (T)(Files.exists(FileKt.getPath(f), Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? t : null);
                    }
                });
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"T : FileSystemLocation> \u2026 -> f.path.exists() } } }");
        return provider;
    }

    @NotNull
    public static final Provider<DownloadService> getDownload(@NotNull Project $this$download) {
        Intrinsics.checkNotNullParameter((Object)$this$download, (String)"<this>");
        Provider provider = ((BuildServiceRegistration)$this$download.getGradle().getSharedServices().getRegistrations().getByName("paperweightDownloadService")).getService();
        Intrinsics.checkNotNull((Object)provider, (String)"null cannot be cast to non-null type org.gradle.api.provider.Provider<io.papermc.paperweight.DownloadService>");
        return provider;
    }

    public static /* synthetic */ void getDownload$annotations(Project project) {
    }

    @NotNull
    public static final Regex commentRegex() {
        return new Regex("\\s*#.*");
    }

    @NotNull
    public static final Provider<Boolean> isBaseExecution(@NotNull ProviderFactory $this$isBaseExecution) {
        Intrinsics.checkNotNullParameter((Object)$this$isBaseExecution, (String)"<this>");
        Provider provider = $this$isBaseExecution.gradleProperty("paperweightUpstreamWorkDir").orElse($this$isBaseExecution.provider((Callable)isBaseExecution.1.INSTANCE)).map((Transformer)isBaseExecution.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"gradleProperty(UPSTREAM_\u2026   .map { it == \"false\" }");
        return provider;
    }

    public static final boolean isBaseExecution(@NotNull Project $this$isBaseExecution) {
        Intrinsics.checkNotNullParameter((Object)$this$isBaseExecution, (String)"<this>");
        ProviderFactory providerFactory = $this$isBaseExecution.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"providers");
        Object object = UtilsKt.isBaseExecution(providerFactory).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"providers.isBaseExecution.get()");
        return (Boolean)object;
    }

    @NotNull
    public static final Provider<Boolean> verboseApplyPatches(@NotNull ProviderFactory $this$verboseApplyPatches) {
        Intrinsics.checkNotNullParameter((Object)$this$verboseApplyPatches, (String)"<this>");
        Provider provider = $this$verboseApplyPatches.gradleProperty("paperweight.verboseApplyPatches").map((Transformer)verboseApplyPatches.1.INSTANCE).orElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"gradleProperty(PAPERWEIG\u2026 }\n        .orElse(false)");
        return provider;
    }

    @NotNull
    public static final AtomicLong getRedirectThreadCount() {
        return redirectThreadCount;
    }

    @NotNull
    public static final CompletableFuture<Unit> redirect(@NotNull InputStream input, @NotNull OutputStream out) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        CompletableFuture<Unit> future = new CompletableFuture<Unit>();
        Thread thread2 = new Thread(new Runnable(input, out, future){
            final /* synthetic */ InputStream $input;
            final /* synthetic */ OutputStream $out;
            final /* synthetic */ CompletableFuture<Unit> $future;
            {
                this.$input = $input;
                this.$out = $out;
                this.$future = $future;
            }

            public final void run() {
                try {
                    ByteStreamsKt.copyTo$default((InputStream)this.$input, (OutputStream)this.$out, (int)0, (int)2, null);
                    this.$future.complete(Unit.INSTANCE);
                }
                catch (Throwable e) {
                    this.$future.completeExceptionally(new PaperweightException("Failed to copy " + this.$input + " to " + this.$out, e));
                }
            }
        });
        thread2.setName("paperweight stream redirect thread #" + redirectThreadCount.getAndIncrement());
        thread2.setDaemon(true);
        thread2.start();
        return future;
    }

    @NotNull
    public static final Path cleanFile(@NotNull Path $this$cleanFile) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanFile, (String)"<this>");
        FileKt.deleteRecursive$default($this$cleanFile, null, null, 3, null);
        return FileKt.createParentDirectories($this$cleanFile, new FileAttribute[0]);
    }

    @NotNull
    public static final Path cleanDir(@NotNull Path $this$cleanDir) {
        Intrinsics.checkNotNullParameter((Object)$this$cleanDir, (String)"<this>");
        FileKt.deleteRecursive$default($this$cleanDir, null, null, 3, null);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories($this$cleanDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        return $this$cleanDir;
    }

    @NotNull
    public static final Provider<RegularFile> convertToFileProvider(@NotNull Object $this$convertToFileProvider, @NotNull ProjectLayout layout, @NotNull ProviderFactory providers) {
        Provider provider;
        Intrinsics.checkNotNullParameter((Object)$this$convertToFileProvider, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        Object object = $this$convertToFileProvider;
        if (object instanceof Path) {
            Provider provider2 = layout.file(providers.provider(new Callable($this$convertToFileProvider){
                final /* synthetic */ Object $this_convertToFileProvider;
                {
                    this.$this_convertToFileProvider = $receiver;
                }

                public final File call() {
                    return ((Path)this.$this_convertToFileProvider).toFile();
                }
            }));
            provider = provider2;
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"Any.convertToFileProvide\u2026rs.provider { toFile() })");
        } else if (object instanceof File) {
            Provider provider3 = layout.file(providers.provider(new Callable($this$convertToFileProvider){
                final /* synthetic */ Object $this_convertToFileProvider;
                {
                    this.$this_convertToFileProvider = $receiver;
                }

                public final File call() {
                    return (File)this.$this_convertToFileProvider;
                }
            }));
            provider = provider3;
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"Any.convertToFileProvide\u2026viders.provider { this })");
        } else if (object instanceof FileSystemLocation) {
            Provider provider4 = layout.file(providers.provider(new Callable($this$convertToFileProvider){
                final /* synthetic */ Object $this_convertToFileProvider;
                {
                    this.$this_convertToFileProvider = $receiver;
                }

                public final File call() {
                    return ((FileSystemLocation)this.$this_convertToFileProvider).getAsFile();
                }
            }));
            provider = provider4;
            Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"Any.convertToFileProvide\u2026ders.provider { asFile })");
        } else if (object instanceof Provider) {
            Provider provider5 = ((Provider)$this$convertToFileProvider).flatMap(new Transformer(layout, providers){
                final /* synthetic */ ProjectLayout $layout;
                final /* synthetic */ ProviderFactory $providers;
                {
                    this.$layout = $layout;
                    this.$providers = $providers;
                }

                public final Provider<? extends RegularFile> transform(Object it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return UtilsKt.convertToFileProvider(it, this.$layout, this.$providers);
                }
            });
            provider = provider5;
            Intrinsics.checkNotNullExpressionValue((Object)provider5, (String)"layout: ProjectLayout, p\u2026ider(layout, providers) }");
        } else {
            throw new PaperweightException("Unknown type representing a file: " + $this$convertToFileProvider.getClass().getName());
        }
        return provider;
    }

    @NotNull
    public static final Path convertToPath(@NotNull Object $this$convertToPath) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$convertToPath, (String)"<this>");
        Object object = $this$convertToPath;
        if (object instanceof Path) {
            path = (Path)$this$convertToPath;
        } else if (object instanceof File) {
            Path path2 = ((File)$this$convertToPath).toPath();
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.toPath()");
        } else if (object instanceof FileSystemLocation) {
            path = FileKt.getPath((FileSystemLocation)$this$convertToPath);
        } else if (object instanceof Provider) {
            Object object2 = ((Provider)$this$convertToPath).get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this.get()");
            path = UtilsKt.convertToPath(object2);
        } else {
            throw new PaperweightException("Unknown type representing a file: " + $this$convertToPath.getClass().getName());
        }
        return path;
    }

    @Nullable
    public static final Path convertToPathOrNull(@Nullable Object $this$convertToPathOrNull) {
        if ($this$convertToPathOrNull == null) {
            return null;
        }
        return UtilsKt.convertToPath($this$convertToPathOrNull);
    }

    @NotNull
    public static final URL convertToUrl(@NotNull Object $this$convertToUrl) {
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)$this$convertToUrl, (String)"<this>");
        Object object = $this$convertToUrl;
        if (object instanceof URL) {
            uRL = (URL)$this$convertToUrl;
        } else if (object instanceof URI) {
            URL uRL2 = ((URI)$this$convertToUrl).toURL();
            uRL = uRL2;
            Intrinsics.checkNotNullExpressionValue((Object)uRL2, (String)"this.toURL()");
        } else if (object instanceof String) {
            URL uRL3 = URI.create((String)$this$convertToUrl).toURL();
            uRL = uRL3;
            Intrinsics.checkNotNullExpressionValue((Object)uRL3, (String)"create(this).toURL()");
        } else if (object instanceof Provider) {
            Object object2 = ((Provider)$this$convertToUrl).get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this.get()");
            uRL = UtilsKt.convertToUrl(object2);
        } else {
            throw new PaperweightException("Unknown URL type: " + $this$convertToUrl.getClass().getName());
        }
        return uRL;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String capitalized(@NotNull String $this$capitalized) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$capitalized, (String)"<this>");
        String string2 = $this$capitalized;
        if (((CharSequence)string2).length() > 0) {
            void p0;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean $i$f$capitalized$stub_for_inlining = false;
            boolean bl = false;
            String string3 = String.valueOf((char)p0);
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
            String string5 = string2;
            int n = 1;
            String string6 = string5.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            string = stringBuilder2.append(string6).toString();
        } else {
            string = string2;
        }
        return string;
    }

    public static final void ensureParentExists(Object ... files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        for (Object file2 : files) {
            Path parent = UtilsKt.convertToPath(file2).getParent();
            try {
                Intrinsics.checkNotNullExpressionValue((Object)parent, (String)"parent");
                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(parent, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            }
            catch (Exception e) {
                throw new PaperweightException("Failed to create directory " + parent, e);
            }
        }
    }

    public static final void ensureDeleted(Object ... files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        for (Object file2 : files) {
            Path f = UtilsKt.convertToPath(file2);
            try {
                FileKt.deleteRecursive$default(f, null, null, 3, null);
            }
            catch (Exception e) {
                throw new PaperweightException("Failed to delete file or directory " + f, e);
            }
        }
    }

    @NotNull
    public static final RegularFileProperty defaultOutput(@NotNull BaseTask $this$defaultOutput, @NotNull String name2, @NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$defaultOutput), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        RegularFileProperty regularFileProperty = $this$defaultOutput.getObjects().fileProperty().convention(new RegularFile($this$defaultOutput, name2, ext){
            final /* synthetic */ BaseTask $this_defaultOutput;
            final /* synthetic */ String $name;
            final /* synthetic */ String $ext;
            {
                this.$this_defaultOutput = $receiver;
                this.$name = $name;
                this.$ext = $ext;
            }

            public final File getAsFile() {
                return UtilsKt.getCache(this.$this_defaultOutput.getLayout()).resolve(ConstantsKt.paperTaskOutput(this.$name, this.$ext)).toFile();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"BaseTask.defaultOutput(n\u2026ame, ext)).toFile()\n    }");
        return regularFileProperty;
    }

    @NotNull
    public static final RegularFileProperty defaultOutput(@NotNull BaseTask $this$defaultOutput, @NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$defaultOutput), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        String string = $this$defaultOutput.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        return UtilsKt.defaultOutput($this$defaultOutput, string, ext);
    }

    @NotNull
    public static final RegularFileProperty defaultOutput(@NotNull BaseTask $this$defaultOutput) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$defaultOutput), (String)"<this>");
        return UtilsKt.defaultOutput($this$defaultOutput, "jar");
    }

    @Nullable
    public static final <T> T getOrNull(@NotNull Optional<T> $this$orNull) {
        Intrinsics.checkNotNullParameter($this$orNull, (String)"<this>");
        return $this$orNull.orElse(null);
    }

    public static final /* synthetic */ <T> Provider<T> contents(Project $this$contents, RegularFileProperty contentFile, Function1<? super String, ? extends T> convert) {
        Intrinsics.checkNotNullParameter((Object)$this$contents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentFile, (String)"contentFile");
        Intrinsics.checkNotNullParameter(convert, (String)"convert");
        boolean $i$f$contents = false;
        Provider provider = $this$contents.getProviders().fileContents((Provider)contentFile).getAsText().map(new Transformer(convert){
            final /* synthetic */ Function1<String, T> $convert;
            {
                this.$convert = $convert;
            }

            public final T transform(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (T)this.$convert.invoke((Object)it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"crossinline convert: (St\u2026     .map { convert(it) }");
        return provider;
    }

    @NotNull
    public static final Path findOutputDir(@NotNull Path baseFile) {
        LinkOption[] linkOptionArray;
        Intrinsics.checkNotNullParameter((Object)baseFile, (String)"baseFile");
        Path dir2 = null;
        do {
            Intrinsics.checkNotNullExpressionValue((Object)baseFile.resolveSibling(PathsKt.getName((Path)baseFile) + "-" + ThreadLocalRandom.current().nextInt()), (String)"baseFile.resolveSibling(\u2026ndom.current().nextInt())");
            linkOptionArray = new LinkOption[]{};
        } while (Files.exists(dir2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)));
        return dir2;
    }

    @NotNull
    public static final <T> MergeResult<T> emptyMergeResult() {
        MergeResult mergeResult = emptyMergeResult;
        Intrinsics.checkNotNull((Object)mergeResult, (String)"null cannot be cast to non-null type org.cadixdev.lorenz.merge.MergeResult<T of io.papermc.paperweight.util.UtilsKt.emptyMergeResult?>");
        return mergeResult;
    }

    public static final /* synthetic */ <T extends Task> RegisteringDomainObjectDelegateProviderWithTypeAndAction<? extends TaskContainer, T> registering(TaskContainer $this$registering, Function1<? super T, Unit> configuration) {
        Intrinsics.checkNotNullParameter((Object)$this$registering, (String)"<this>");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        boolean $i$f$registering = false;
        PolymorphicDomainObjectContainer polymorphicDomainObjectContainer = (PolymorphicDomainObjectContainer)$this$registering;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return NamedDomainObjectContainerExtensionsKt.registering((PolymorphicDomainObjectContainer)polymorphicDomainObjectContainer, (KClass)Reflection.getOrCreateKotlinClass(Task.class), configuration);
    }

    public static final /* synthetic */ <T extends Task> RegisteringDomainObjectDelegateProviderWithType<? extends TaskContainer, T> registering(TaskContainer $this$registering) {
        Intrinsics.checkNotNullParameter((Object)$this$registering, (String)"<this>");
        boolean $i$f$registering = false;
        PolymorphicDomainObjectContainer polymorphicDomainObjectContainer = (PolymorphicDomainObjectContainer)$this$registering;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return NamedDomainObjectContainerExtensionsKt.registering((PolymorphicDomainObjectContainer)polymorphicDomainObjectContainer, (KClass)Reflection.getOrCreateKotlinClass(Task.class));
    }

    @NotNull
    public static final byte[] hash(@NotNull String $this$hash, @NotNull HashingAlgorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)$this$hash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        MessageDigest it = algorithm.getThreadLocalDigest();
        boolean bl = false;
        byte[] byArray2 = $this$hash.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        it.update(byArray2);
        byte[] byArray3 = it.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"algorithm.threadLocalDig\u2026rray())\n    it.digest()\n}");
        return byArray3;
    }

    @NotNull
    public static final byte[] hash(@NotNull InputStream $this$hash, @NotNull HashingAlgorithm algorithm, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)$this$hash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        return UtilsKt.hash(CollectionsKt.listOf((Object)InputStreamProvider.Companion.wrap($this$hash)), algorithm, bufferSize);
    }

    public static /* synthetic */ byte[] hash$default(InputStream inputStream, HashingAlgorithm hashingAlgorithm, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        return UtilsKt.hash(inputStream, hashingAlgorithm, n);
    }

    @NotNull
    public static final byte[] hash(@NotNull Iterable<? extends InputStreamProvider> $this$hash, @NotNull HashingAlgorithm algorithm, int bufferSize) {
        Intrinsics.checkNotNullParameter($this$hash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)algorithm), (String)"algorithm");
        MessageDigest digest = algorithm.getThreadLocalDigest();
        byte[] buffer = new byte[bufferSize];
        for (InputStreamProvider inputStreamProvider : $this$hash) {
            inputStreamProvider.use((Function1)new Function1<InputStream, Unit>(buffer, digest){
                final /* synthetic */ byte[] $buffer;
                final /* synthetic */ MessageDigest $digest;
                {
                    this.$buffer = $buffer;
                    this.$digest = $digest;
                    super(1);
                }

                public final void invoke(InputStream input) {
                    int count2;
                    Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                    while ((count2 = input.read(this.$buffer)) != -1) {
                        this.$digest.update(this.$buffer, 0, count2);
                    }
                }
            });
        }
        byte[] byArray2 = digest.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest.digest()");
        return byArray2;
    }

    public static /* synthetic */ byte[] hash$default(Iterable iterable, HashingAlgorithm hashingAlgorithm, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        return UtilsKt.hash(iterable, hashingAlgorithm, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String asHexString(@NotNull byte[] $this$asHexString) {
        Intrinsics.checkNotNullParameter((Object)$this$asHexString, (String)"<this>");
        char[] chars = new char[2 * $this$asHexString.length];
        byte[] $this$forEachIndexed$iv = $this$asHexString;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (byte item$iv : $this$forEachIndexed$iv) {
            void byteVal;
            int n = index$iv++;
            byte by = item$iv;
            int i2 = n;
            boolean bl = false;
            int unsigned = byteVal & 0xFF;
            chars[2 * i2] = hexChars[unsigned / 16];
            chars[2 * i2 + 1] = hexChars[unsigned % 16];
        }
        return new String(chars);
    }

    @NotNull
    public static final Provider<JavaLauncher> defaultJavaLauncher(@NotNull JavaToolchainService $this$defaultJavaLauncher, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultJavaLauncher, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Provider provider = $this$defaultJavaLauncher.launcherFor((Action)defaultJavaLauncher.fallback.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"launcherFor {\n        la\u2026uageVersion.of(21))\n    }");
        Provider fallback2 = provider;
        ExtensionContainer extensionContainer = project.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
        ExtensionContainer $this$findByType$iv = extensionContainer;
        boolean $i$f$findByType = false;
        boolean $i$f$typeOf = false;
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)$this$findByType$iv.findByType((TypeOf)new TypeOf<JavaPluginExtension>(){});
        if (javaPluginExtension == null) {
            return fallback2;
        }
        JavaPluginExtension ext = javaPluginExtension;
        Provider provider2 = $this$defaultJavaLauncher.launcherFor(ext.getToolchain()).orElse(fallback2);
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"launcherFor(ext.toolchain).orElse(fallback)");
        return provider2;
    }

    @NotNull
    public static final <P extends Property<?>> P changesDisallowed(@NotNull P $this$changesDisallowed) {
        P p;
        Intrinsics.checkNotNullParameter($this$changesDisallowed, (String)"<this>");
        P $this$changesDisallowed_u24lambda_u243 = p = $this$changesDisallowed;
        boolean bl = false;
        $this$changesDisallowed_u24lambda_u243.disallowChanges();
        return p;
    }

    @NotNull
    public static final <P extends Property<?>> P finalizedOnRead(@NotNull P $this$finalizedOnRead) {
        P p;
        Intrinsics.checkNotNullParameter($this$finalizedOnRead, (String)"<this>");
        P $this$finalizedOnRead_u24lambda_u244 = p = $this$finalizedOnRead;
        boolean bl = false;
        $this$finalizedOnRead_u24lambda_u244.finalizeValueOnRead();
        return p;
    }

    @NotNull
    public static final List<ClassProviderRoot> toJarClassProviderRoots(@NotNull FileCollection $this$toJarClassProviderRoots) {
        Intrinsics.checkNotNullParameter((Object)$this$toJarClassProviderRoots, (String)"<this>");
        Set set = $this$toJarClassProviderRoots.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"files");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)toJarClassProviderRoots.1.INSTANCE), (Function1)toJarClassProviderRoots.2.INSTANCE), (Function1)toJarClassProviderRoots.3.INSTANCE));
    }

    private static final int javaVersion() {
        int n;
        List list;
        String version = System.getProperty("java.specification.version");
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
        CharSequence charSequence = version;
        Regex regex = new Regex("\\.");
        int n2 = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n2);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] parts = thisCollection$iv.toArray(new String[0]);
        String errorMsg = "Could not determine version of the current JVM";
        if (!(!(parts.length == 0))) {
            boolean $i$a$-check-UtilsKt$javaVersion$32 = false;
            String $i$a$-check-UtilsKt$javaVersion$32 = errorMsg;
            throw new IllegalStateException($i$a$-check-UtilsKt$javaVersion$32.toString());
        }
        if (Intrinsics.areEqual((Object)parts[0], (Object)"1")) {
            if (!(parts.length >= 2)) {
                boolean bl = false;
                String string = errorMsg;
                throw new IllegalStateException(string.toString());
            }
            n = Integer.parseInt(parts[1]);
        } else {
            n = Integer.parseInt(parts[0]);
        }
        return n;
    }

    public static final /* synthetic */ <P> void printId(String pluginId, Gradle gradle) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter((Object)gradle, (String)"gradle");
        boolean $i$f$printId = false;
        if (gradle.getStartParameter().getLogLevel() == LogLevel.QUIET) {
            return;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"P");
        System.out.println((Object)(pluginId + " v" + Object.class.getPackage().getImplementationVersion() + " (running on '" + System.getProperty("os.name") + "')"));
    }

    public static final void modifyManifest(@NotNull FileSystem $this$modifyManifest, boolean create, @NotNull Function1<? super Manifest, Unit> op2) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyManifest, (String)"<this>");
        Intrinsics.checkNotNullParameter(op2, (String)"op");
        Path path = $this$modifyManifest.getPath("META-INF/MANIFEST.MF", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(\"META-INF/MANIFEST.MF\")");
        UtilsKt.modifyManifest(path, create, op2);
    }

    public static /* synthetic */ void modifyManifest$default(FileSystem fileSystem, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        UtilsKt.modifyManifest(fileSystem, bl, (Function1<? super Manifest, Unit>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void modifyManifest(@NotNull Path path, boolean create, @NotNull Function1<? super Manifest, Unit> op2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(op2, (String)"op");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean exists = Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        if (exists || create) {
            Object object;
            Object it2;
            Object object2;
            if (exists) {
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                object2 = inputStream;
                int n = 8192;
                object2 = object2 instanceof BufferedInputStream ? (BufferedInputStream)object2 : new BufferedInputStream((InputStream)object2, n);
                var6_6 = null;
                try {
                    it2 = (BufferedInputStream)object2;
                    boolean bl = false;
                    it2 = new Manifest((InputStream)it2);
                    object = it2;
                }
                catch (Throwable it2) {
                    var6_6 = it2;
                    throw it2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)var6_6);
                }
            } else {
                Path path2 = path.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.parent");
                object2 = path2;
                var6_6 = new FileAttribute[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object2, Arrays.copyOf(var6_6, ((FileAttribute[])var6_6).length)), (String)"createDirectories(...)");
                Manifest manifest = new Manifest();
                Attributes attributes = manifest.getMainAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"manifest.mainAttributes");
                var6_6 = attributes;
                it2 = Attributes.Name.MANIFEST_VERSION;
                String bl = "1.0";
                var6_6.put(it2, bl);
                object = manifest;
            }
            Object mf = object;
            op2.invoke(mf);
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            object2 = outputStream;
            int n = 8192;
            object2 = object2 instanceof BufferedOutputStream ? (BufferedOutputStream)object2 : new BufferedOutputStream((OutputStream)object2, n);
            Throwable throwable = null;
            try {
                it2 = (BufferedOutputStream)object2;
                boolean bl = false;
                ((Manifest)mf).write((OutputStream)it2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
    }

    public static /* synthetic */ void modifyManifest$default(Path path, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        UtilsKt.modifyManifest(path, bl, (Function1<? super Manifest, Unit>)function1);
    }

    @NotNull
    public static final Attribute<String> getMainCapabilityAttribute() {
        return mainCapabilityAttribute;
    }

    @NotNull
    public static final MacheMeta resolveMacheMeta(@NotNull ConfigurationContainer $this$resolveMacheMeta) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveMacheMeta, (String)"<this>");
        Configuration configuration = $this$resolveMacheMeta.getByName("mache");
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getByName(MACHE_CONFIG)");
        return UtilsKt.resolveMacheMeta((FileCollection)configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final MacheMeta resolveMacheMeta(@NotNull FileCollection $this$resolveMacheMeta) {
        MacheMeta macheMeta;
        Intrinsics.checkNotNullParameter((Object)$this$resolveMacheMeta, (String)"<this>");
        Path path = $this$resolveMacheMeta.getSingleFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"singleFile.toPath()");
        AutoCloseable autoCloseable = NioKt.openZipSafe(path);
        Throwable throwable = null;
        try {
            Type type;
            void $receiver$iv;
            String json$iv;
            FileSystemReference zip2 = (FileSystemReference)autoCloseable;
            boolean bl = false;
            Gson gson = UtilsKt.gson;
            String string = json$iv = PathsKt.readText$default((Path)zip2.getPath("/mache.json"), null, (int)1, null);
            void var8_10 = $receiver$iv;
            Type type2 = new TypeToken<MacheMeta>(){}.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {} .type");
            Type type$iv$iv = type2;
            if (type$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv)) {
                Type type3 = ((ParameterizedType)type$iv$iv).getRawType();
                type = type3;
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
            } else {
                type = GsonBuilderKt.removeTypeWildcards(type$iv$iv);
            }
            Type type4 = type;
            Object t = var8_10.fromJson(string, type4);
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
            macheMeta = (MacheMeta)t;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return macheMeta;
    }

    public static final boolean isIDEASync() {
        return Boolean.getBoolean("idea.sync.active");
    }

    public static final /* synthetic */ <T> Provider<Set<T>> providerSet(ObjectFactory $this$providerSet, Provider<? extends T> ... providers) {
        Intrinsics.checkNotNullParameter((Object)$this$providerSet, (String)"<this>");
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        boolean $i$f$providerSet = false;
        if (providers.length == 0) {
            ObjectFactory $this$setProperty$iv = $this$providerSet;
            boolean $i$f$setProperty = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            SetProperty setProperty = $this$setProperty$iv.setProperty(Object.class);
            Intrinsics.checkNotNullExpressionValue((Object)setProperty, (String)"setProperty(T::class.java)");
            return (Provider)setProperty;
        }
        Provider current = null;
        for (Provider<? extends T> provider : providers) {
            current = current == null ? provider.map((Transformer)providerSet.1.INSTANCE) : current.zip(provider, (BiFunction)providerSet.2.INSTANCE);
        }
        Provider provider = current;
        Intrinsics.checkNotNull(provider);
        return provider;
    }

    @NotNull
    public static final Provider<Directory> upstreamsDirectory(@NotNull Project $this$upstreamsDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$upstreamsDirectory, (String)"<this>");
        Provider provider = $this$upstreamsDirectory.getProviders().gradleProperty("paperweightUpstreamWorkDir");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"providers.gradleProperty\u2026STREAM_WORK_DIR_PROPERTY)");
        Provider workDirProp = provider;
        Provider provider2 = $this$upstreamsDirectory.getLayout().dir(workDirProp.map((Transformer)upstreamsDirectory.workDirFromProp.1.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"layout.dir(workDirProp.map { File(it) })");
        Provider workDirFromProp2 = provider2;
        ProjectLayout projectLayout = $this$upstreamsDirectory.getRootProject().getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"rootProject.layout");
        Provider provider3 = workDirFromProp2.orElse((Object)UtilsKt.cacheDir(projectLayout, "paperweight/upstreams"));
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"workDirFromProp.orElse(r\u2026yout.cacheDir(UPSTREAMS))");
        return provider3;
    }

    @NotNull
    public static final ExecutorCoroutineDispatcher ioDispatcher(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(name2){
            private final int id;
            private final Logger logger;
            private final AtomicInteger count;
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                this.id = UtilsKt.access$getIoDispatcherCount$p().getAndIncrement();
                this.logger = Logging.getLogger((String)($name + "-ioDispatcher-" + this.id));
                this.count = new AtomicInteger(0);
            }

            public final int getId() {
                return this.id;
            }

            public final Logger getLogger() {
                return this.logger;
            }

            public final AtomicInteger getCount() {
                return this.count;
            }

            public Thread newThread(Runnable r) {
                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                Thread thr = new Thread(r, this.$name + "-ioDispatcher-" + this.id + "-Thread-" + this.count.getAndIncrement());
                thr.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){
                    final /* synthetic */ ioDispatcher.1 this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void uncaughtException(Thread thread2, Throwable ex) {
                        this.this$0.getLogger().error("Uncaught exception in thread " + thread2, ex);
                    }
                });
                thr.setDaemon(true);
                return thr;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"name: String): ExecutorC\u2026        }\n        }\n    )");
        return ExecutorsKt.from(executorService);
    }

    public static final /* synthetic */ AtomicInteger access$getIoDispatcherCount$p() {
        return ioDispatcherCount;
    }

    static {
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().registerTypeHierarchyAdapter(Path.class, new PathJsonConverter()).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder().disableHtm\u2026JsonConverter()).create()");
        UtilsKt.gson = gson;
        redirectThreadCount = new AtomicLong(0L);
        emptyMergeResult = new MergeResult<Object>(null);
        char[] cArray = "0123456789abcdef".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        hexChars = cArray;
        Attribute attribute = Attribute.of((String)"io.papermc.paperweight.main-capability", String.class);
        Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"of(\"io.papermc.paperweig\u2026ity\", String::class.java)");
        mainCapabilityAttribute = attribute;
        ioDispatcherCount = new AtomicInteger(0);
    }
}

