/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u001a\u0016\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"unzip", "Ljava/nio/file/Path;", "zip", "", "target", "", "inputDir", "paperweight-lib"})
public final class ZipKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Path unzip(@NotNull Object zip2, @Nullable Object target) {
        Intrinsics.checkNotNullParameter((Object)zip2, (String)"zip");
        Path input = UtilsKt.convertToPath(zip2);
        Object object = target;
        if (object == null || (object = UtilsKt.convertToPath(object)) == null) {
            object = input.resolveSibling(PathsKt.getName((Path)input) + "-" + ThreadLocalRandom.current().nextInt());
        }
        Object outputDir = object;
        Closeable closeable = FileKt.openZip(input);
        Throwable throwable = null;
        try {
            FileSystem fs = (FileSystem)closeable;
            boolean bl = false;
            AutoCloseable autoCloseable = FileKt.walk(fs);
            Throwable throwable2 = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl2 = false;
                stream.forEach(new Consumer((Path)outputDir){
                    final /* synthetic */ Path $outputDir;
                    {
                        this.$outputDir = $outputDir;
                    }

                    public final void accept(Path p) {
                        Intrinsics.checkNotNullExpressionValue((Object)p, (String)"p");
                        String string = ((Object)p.toAbsolutePath()).toString().substring(1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        Path targetFile = this.$outputDir.resolve(string);
                        Path path = targetFile.getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"targetFile.parent");
                        Path path2 = path;
                        Object object = new FileAttribute[]{};
                        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"createDirectories(...)");
                        path2 = p;
                        Intrinsics.checkNotNullExpressionValue((Object)targetFile, (String)"targetFile");
                        object = targetFile;
                        CopyOption[] copyOptionArray = new CopyOption[]{};
                        Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, (Path)object, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"copy(...)");
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)outputDir, (String)"outputDir");
        return outputDir;
    }

    public static /* synthetic */ Path unzip$default(Object object, Object object2, int n, Object object3) {
        if ((n & 2) != 0) {
            object2 = null;
        }
        return ZipKt.unzip(object, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void zip(@NotNull Object inputDir, @NotNull Object zip2) {
        Intrinsics.checkNotNullParameter((Object)inputDir, (String)"inputDir");
        Intrinsics.checkNotNullParameter((Object)zip2, (String)"zip");
        Path outputZipFile = UtilsKt.convertToPath(zip2);
        try {
            Files.deleteIfExists(outputZipFile);
        }
        catch (Exception e) {
            throw new PaperweightException("Could not delete " + outputZipFile, e);
        }
        Path dirPath = UtilsKt.convertToPath(inputDir);
        Closeable closeable = FileKt.writeZip(outputZipFile);
        Throwable throwable = null;
        try {
            FileSystem fs = (FileSystem)closeable;
            boolean bl = false;
            Path path = Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(dirPath, fs){
                final /* synthetic */ Path $dirPath;
                final /* synthetic */ FileSystem $fs;
                {
                    this.$dirPath = $dirPath;
                    this.$fs = $fs;
                }

                public FileVisitResult preVisitDirectory(Path dir2, BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    if (!Intrinsics.areEqual((Object)dir2, (Object)this.$dirPath)) {
                        Files.createDirectories(this.$fs.getPath(((Object)this.$dirPath.relativize(dir2)).toString(), new String[0]), new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) {
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                    Files.copy(file2, this.$fs.getPath(((Object)this.$dirPath.relativize(file2)).toString(), new String[0]), new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

