/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util.data;

import io.papermc.paperweight.util.Hash;
import io.papermc.paperweight.util.HashingAlgorithm;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0015B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0004J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0006\u0010\u0012\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0005J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/papermc/paperweight/util/data/MinecraftVersionManifest;", "", "downloads", "", "", "Lio/papermc/paperweight/util/data/MinecraftVersionManifest$Download;", "(Ljava/util/Map;)V", "getDownloads", "()Ljava/util/Map;", "component1", "copy", "download", "name", "equals", "", "other", "hashCode", "", "serverDownload", "serverMappingsDownload", "toString", "Download", "paperweight-lib"})
public final class MinecraftVersionManifest {
    @NotNull
    private final Map<String, Download> downloads;

    public MinecraftVersionManifest(@NotNull Map<String, Download> downloads) {
        Intrinsics.checkNotNullParameter(downloads, (String)"downloads");
        this.downloads = downloads;
    }

    @NotNull
    public final Map<String, Download> getDownloads() {
        return this.downloads;
    }

    @NotNull
    public final Download download(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Download download = this.downloads.get(name2);
        if (download == null) {
            throw new IllegalStateException(("No such download '" + name2 + "' in version manifest").toString());
        }
        return download;
    }

    @NotNull
    public final Download serverDownload() {
        return this.download("server");
    }

    @NotNull
    public final Download serverMappingsDownload() {
        return this.download("server_mappings");
    }

    @NotNull
    public final Map<String, Download> component1() {
        return this.downloads;
    }

    @NotNull
    public final MinecraftVersionManifest copy(@NotNull Map<String, Download> downloads) {
        Intrinsics.checkNotNullParameter(downloads, (String)"downloads");
        return new MinecraftVersionManifest(downloads);
    }

    public static /* synthetic */ MinecraftVersionManifest copy$default(MinecraftVersionManifest minecraftVersionManifest, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            map2 = minecraftVersionManifest.downloads;
        }
        return minecraftVersionManifest.copy(map2);
    }

    @NotNull
    public String toString() {
        return "MinecraftVersionManifest(downloads=" + this.downloads + ")";
    }

    public int hashCode() {
        return ((Object)this.downloads).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MinecraftVersionManifest)) {
            return false;
        }
        MinecraftVersionManifest minecraftVersionManifest = (MinecraftVersionManifest)other;
        return Intrinsics.areEqual(this.downloads, minecraftVersionManifest.downloads);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u000f\u001a\u00020\u0010J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lio/papermc/paperweight/util/data/MinecraftVersionManifest$Download;", "", "sha1", "", "url", "(Ljava/lang/String;Ljava/lang/String;)V", "getSha1", "()Ljava/lang/String;", "getUrl", "component1", "component2", "copy", "equals", "", "other", "hash", "Lio/papermc/paperweight/util/Hash;", "hashCode", "", "toString", "paperweight-lib"})
    public static final class Download {
        @NotNull
        private final String sha1;
        @NotNull
        private final String url;

        public Download(@NotNull String sha1, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)sha1, (String)"sha1");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.sha1 = sha1;
            this.url = url;
        }

        @NotNull
        public final String getSha1() {
            return this.sha1;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final Hash hash() {
            return new Hash(this.sha1, HashingAlgorithm.SHA1);
        }

        @NotNull
        public final String component1() {
            return this.sha1;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final Download copy(@NotNull String sha1, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)sha1, (String)"sha1");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new Download(sha1, url);
        }

        public static /* synthetic */ Download copy$default(Download download, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = download.sha1;
            }
            if ((n & 2) != 0) {
                string2 = download.url;
            }
            return download.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Download(sha1=" + this.sha1 + ", url=" + this.url + ")";
        }

        public int hashCode() {
            int result2 = this.sha1.hashCode();
            result2 = result2 * 31 + this.url.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Download)) {
                return false;
            }
            Download download = (Download)other;
            if (!Intrinsics.areEqual((Object)this.sha1, (Object)download.sha1)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.url, (Object)download.url);
        }
    }
}

