/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util.data;

import io.papermc.paperweight.util.data.ModuleId;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactIdentifier;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J3\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u000eH\u00d6\u0001J\u0006\u0010\u0019\u001a\u00020\u0003J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001c"}, d2={"Lio/papermc/paperweight/util/data/ModuleId;", "", "group", "", "name", "version", "classifier", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getClassifier", "()Ljava/lang/String;", "getGroup", "getName", "getVersion", "compareTo", "", "other", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "toPath", "toString", "Companion", "paperweight-lib"})
public final class ModuleId
implements Comparable<ModuleId> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String group;
    @NotNull
    private final String name;
    @NotNull
    private final String version;
    @Nullable
    private final String classifier;
    @NotNull
    private static final Comparator<ModuleId> comparator;

    public ModuleId(@NotNull String group, @NotNull String name2, @NotNull String version, @Nullable String classifier) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.group = group;
        this.name = name2;
        this.version = version;
        this.classifier = classifier;
    }

    public /* synthetic */ ModuleId(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        this(string, string2, string3, string4);
    }

    @NotNull
    public final String getGroup() {
        return this.group;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @Nullable
    public final String getClassifier() {
        return this.classifier;
    }

    @NotNull
    public final String toPath() {
        Object[] objectArray = new String[]{this.name, this.version, this.classifier};
        String fileName = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)"-", null, null, (int)0, null, null, (int)62, null) + ".jar";
        return StringsKt.replace$default((String)this.group, (char)'.', (char)'/', (boolean)false, (int)4, null) + "/" + this.name + "/" + this.version + "/" + fileName;
    }

    @Override
    public int compareTo(@NotNull ModuleId other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return comparator.compare(this, other);
    }

    @NotNull
    public String toString() {
        Object[] objectArray = new String[]{this.group, this.name, this.version, this.classifier};
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)":", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String component1() {
        return this.group;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final String component3() {
        return this.version;
    }

    @Nullable
    public final String component4() {
        return this.classifier;
    }

    @NotNull
    public final ModuleId copy(@NotNull String group, @NotNull String name2, @NotNull String version, @Nullable String classifier) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return new ModuleId(group, name2, version, classifier);
    }

    public static /* synthetic */ ModuleId copy$default(ModuleId moduleId, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = moduleId.group;
        }
        if ((n & 2) != 0) {
            string2 = moduleId.name;
        }
        if ((n & 4) != 0) {
            string3 = moduleId.version;
        }
        if ((n & 8) != 0) {
            string4 = moduleId.classifier;
        }
        return moduleId.copy(string, string2, string3, string4);
    }

    public int hashCode() {
        int result2 = this.group.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + this.version.hashCode();
        result2 = result2 * 31 + (this.classifier == null ? 0 : this.classifier.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModuleId)) {
            return false;
        }
        ModuleId moduleId = (ModuleId)other;
        if (!Intrinsics.areEqual((Object)this.group, (Object)moduleId.group)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)moduleId.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.version, (Object)moduleId.version)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.classifier, (Object)moduleId.classifier);
    }

    static {
        Function1[] function1Array = new Function1[]{Companion.comparator.1.INSTANCE, Companion.comparator.2.INSTANCE, Companion.comparator.3.INSTANCE, Companion.comparator.4.INSTANCE};
        comparator = ComparisonsKt.compareBy((Function1[])function1Array);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/papermc/paperweight/util/data/ModuleId$Companion;", "", "()V", "comparator", "Ljava/util/Comparator;", "Lio/papermc/paperweight/util/data/ModuleId;", "Lkotlin/Comparator;", "fromIdentifier", "id", "Lorg/gradle/api/artifacts/component/ComponentArtifactIdentifier;", "parse", "text", "", "paperweight-lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModuleId parse(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            String[] stringArray = new String[]{":"};
            List split = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String group = (String)split.get(0);
            String name2 = (String)split.get(1);
            String version = (String)split.get(2);
            return new ModuleId(group, name2, version, (String)CollectionsKt.getOrNull((List)split, (int)3));
        }

        @NotNull
        public final ModuleId fromIdentifier(@NotNull ComponentArtifactIdentifier id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            if (id instanceof DefaultModuleComponentArtifactIdentifier) {
                ModuleComponentIdentifier moduleComponentIdentifier = ((DefaultModuleComponentArtifactIdentifier)id).getComponentIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)moduleComponentIdentifier, (String)"id.componentIdentifier");
                ModuleComponentIdentifier idx = moduleComponentIdentifier;
                String string = idx.getGroup();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"idx.group");
                String string2 = idx.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"idx.module");
                String string3 = idx.getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"idx.version");
                return new ModuleId(string, string2, string3, ((DefaultModuleComponentArtifactIdentifier)id).getName().getClassifier());
            }
            ComponentIdentifier componentIdentifier = id.getComponentIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier, (String)"id.componentIdentifier");
            ComponentIdentifier compId = componentIdentifier;
            if (compId instanceof ModuleComponentIdentifier) {
                String string = ((ModuleComponentIdentifier)compId).getGroup();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compId.group");
                String string4 = ((ModuleComponentIdentifier)compId).getModule();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"compId.module");
                String string5 = ((ModuleComponentIdentifier)compId).getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"compId.version");
                return new ModuleId(string, string4, string5, null, 8, null);
            }
            throw new IllegalStateException(("Could not create ModuleId from ComponentArtifactIdentifier " + id).toString());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

