/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.com.google.gson;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import paper.libs.com.google.gson.JsonElement;
import paper.libs.com.google.gson.JsonIOException;
import paper.libs.com.google.gson.internal.bind.JsonTreeReader;
import paper.libs.com.google.gson.internal.bind.JsonTreeWriter;
import paper.libs.com.google.gson.stream.JsonReader;
import paper.libs.com.google.gson.stream.JsonToken;
import paper.libs.com.google.gson.stream.JsonWriter;

public abstract class TypeAdapter<T> {
    public abstract void write(JsonWriter var1, T var2) throws IOException;

    public final void toJson(Writer out, T value2) throws IOException {
        JsonWriter writer = new JsonWriter(out);
        this.write(writer, value2);
    }

    public final String toJson(T value2) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.toJson(stringWriter, value2);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
        return stringWriter.toString();
    }

    public final JsonElement toJsonTree(T value2) {
        try {
            JsonTreeWriter jsonWriter = new JsonTreeWriter();
            this.write(jsonWriter, value2);
            return jsonWriter.get();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    public abstract T read(JsonReader var1) throws IOException;

    public final T fromJson(Reader in) throws IOException {
        JsonReader reader = new JsonReader(in);
        return this.read(reader);
    }

    public final T fromJson(String json) throws IOException {
        return this.fromJson(new StringReader(json));
    }

    public final T fromJsonTree(JsonElement jsonTree) {
        try {
            JsonTreeReader jsonReader = new JsonTreeReader(jsonTree);
            return this.read(jsonReader);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    public final TypeAdapter<T> nullSafe() {
        if (!(this instanceof NullSafeTypeAdapter)) {
            return new NullSafeTypeAdapter();
        }
        return this;
    }

    private final class NullSafeTypeAdapter
    extends TypeAdapter<T> {
        private NullSafeTypeAdapter() {
        }

        @Override
        public void write(JsonWriter out, T value2) throws IOException {
            if (value2 == null) {
                out.nullValue();
            } else {
                TypeAdapter.this.write(out, value2);
            }
        }

        @Override
        public T read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            return TypeAdapter.this.read(reader);
        }

        public String toString() {
            return "NullSafeTypeAdapter[" + TypeAdapter.this + "]";
        }
    }
}

