/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.asm;

import paper.libs.dev.denwav.hypo.asm.AsmClassData;
import paper.libs.dev.denwav.hypo.asm.HypoAsmUtil;
import paper.libs.dev.denwav.hypo.model.data.LazyMethodData;
import paper.libs.dev.denwav.hypo.model.data.MethodData;
import paper.libs.dev.denwav.hypo.model.data.MethodDescriptor;
import paper.libs.dev.denwav.hypo.model.data.Visibility;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.objectweb.asm.tree.MethodNode;

public class AsmMethodData
extends LazyMethodData
implements MethodData {
    @NotNull
    private final AsmClassData parentClass;
    @NotNull
    private final MethodNode node;

    public AsmMethodData(@NotNull AsmClassData parentClass, @NotNull MethodNode node) {
        this.parentClass = parentClass;
        this.node = node;
    }

    @NotNull
    public MethodNode getNode() {
        return this.node;
    }

    @Override
    @NotNull
    public Visibility visibility() {
        return HypoAsmUtil.accessToVisibility(this.node.access);
    }

    @Override
    public boolean isAbstract() {
        return (this.node.access & 0x400) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.node.access & 0x10) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.node.access & 0x1000) != 0;
    }

    @Override
    public boolean isBridge() {
        return (this.node.access & 0x40) != 0;
    }

    @Override
    public boolean isNative() {
        return (this.node.access & 0x100) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.node.access & 8) != 0;
    }

    @Override
    @NotNull
    public String name() {
        return this.node.name;
    }

    @Override
    @NotNull
    public AsmClassData parentClass() {
        return this.parentClass;
    }

    @Override
    @NotNull
    public MethodDescriptor computeDescriptor() {
        return MethodDescriptor.parseDescriptor(this.node.desc);
    }

    @Override
    @NotNull
    public String descriptorText() {
        return this.node.desc;
    }
}

