/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import paper.libs.dev.denwav.hypo.core.HypoException;
import paper.libs.dev.denwav.hypo.mappings.ChangeRegistry;
import paper.libs.dev.denwav.hypo.mappings.MappingsCompletionManager;
import paper.libs.dev.denwav.hypo.mappings.contributors.ChangeContributor;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.jetbrains.annotations.Contract;
import paper.libs.org.jetbrains.annotations.NotNull;
import paper.libs.org.jetbrains.annotations.Nullable;

public final class ChangeChain {
    @NotNull
    private final List<List<ChangeContributor>> links = new ArrayList<List<ChangeContributor>>();
    @Nullable
    private LinkCompletionListener completedLinkListener = null;
    @Nullable
    private LinkMappingsListener newMappingSetListener = null;

    private ChangeChain() {
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static ChangeChain create() {
        return new ChangeChain();
    }

    @Contract(value="_ -> this")
    @NotNull
    public ChangeChain addLink(@NotNull List<ChangeContributor> changes) {
        this.links.add(changes);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ChangeChain addLink(@NotNull ChangeContributor change) {
        this.links.add(Collections.singletonList(change));
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ChangeChain addLink(ChangeContributor ... changes) {
        this.links.add(Arrays.asList(changes));
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ChangeChain addLinkCompletedListener(@NotNull LinkCompletionListener listener) {
        this.completedLinkListener = listener;
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public ChangeChain addMappingSetListener(@NotNull LinkMappingsListener listener) {
        this.newMappingSetListener = listener;
        return this;
    }

    @NotNull
    public MappingSet applyChain(@NotNull MappingSet mappings, @NotNull MappingsCompletionManager manager) throws HypoException {
        LinkCompletionListener linkListener = this.completedLinkListener;
        LinkMappingsListener mappingListener = this.newMappingSetListener;
        int counter = 0;
        MappingSet currentMappings = mappings;
        for (List<ChangeContributor> link : this.links) {
            ChangeRegistry registry = manager.completeMappings(currentMappings, link);
            if (linkListener != null) {
                linkListener.accept(counter, currentMappings, registry);
            }
            currentMappings = registry.applyChanges(currentMappings);
            if (mappingListener != null) {
                mappingListener.accept(counter, currentMappings);
            }
            ++counter;
        }
        return currentMappings;
    }

    @FunctionalInterface
    public static interface LinkCompletionListener {
        public void accept(int var1, @NotNull MappingSet var2, @NotNull ChangeRegistry var3);
    }

    @FunctionalInterface
    public static interface LinkMappingsListener {
        public void accept(int var1, @NotNull MappingSet var2);
    }
}

