/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings.changes;

import paper.libs.dev.denwav.hypo.mappings.ClassMappingsChange;
import paper.libs.dev.denwav.hypo.mappings.LorenzUtil;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.jetbrains.annotations.Contract;
import paper.libs.org.jetbrains.annotations.NotNull;

public class RemoveClassMappingChange
implements ClassMappingsChange {
    @NotNull
    private final String targetClass;

    private RemoveClassMappingChange(@NotNull String targetClass) {
        this.targetClass = targetClass;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static RemoveClassMappingChange of(@NotNull String targetClass) {
        return new RemoveClassMappingChange(targetClass);
    }

    @Override
    @NotNull
    public String targetClass() {
        return this.targetClass;
    }

    @Override
    public void applyChange(@NotNull MappingSet input) {
        ClassMapping<?, ?> mapping = LorenzUtil.getClassMapping(input, this.targetClass);
        if (mapping == null) {
            return;
        }
        LorenzUtil.removeClassMapping(mapping);
    }
}

