/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.apache.commons.compress.compressors.xz;

import java.io.IOException;
import java.io.InputStream;
import paper.libs.org.apache.commons.compress.compressors.CompressorInputStream;
import paper.libs.org.tukaani.xz.SingleXZInputStream;
import paper.libs.org.tukaani.xz.XZ;
import paper.libs.org.tukaani.xz.XZInputStream;

public class XZCompressorInputStream
extends CompressorInputStream {
    private final InputStream in;

    public static boolean matches(byte[] signature, int length) {
        if (length < XZ.HEADER_MAGIC.length) {
            return false;
        }
        for (int i2 = 0; i2 < XZ.HEADER_MAGIC.length; ++i2) {
            if (signature[i2] == XZ.HEADER_MAGIC[i2]) continue;
            return false;
        }
        return true;
    }

    public XZCompressorInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public XZCompressorInputStream(InputStream inputStream, boolean decompressConcatenated) throws IOException {
        this.in = decompressConcatenated ? new XZInputStream(inputStream) : new SingleXZInputStream(inputStream);
    }

    public int read() throws IOException {
        int ret2 = this.in.read();
        this.count(ret2 == -1 ? -1 : 1);
        return ret2;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        int ret2 = this.in.read(buf, off, len);
        this.count(ret2);
        return ret2;
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }
}

