/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.lorenz.asm;

import paper.libs.org.cadixdev.bombe.analysis.InheritanceProvider;
import paper.libs.org.cadixdev.bombe.type.signature.FieldSignature;
import paper.libs.org.cadixdev.bombe.type.signature.MethodSignature;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.Mapping;
import paper.libs.org.objectweb.asm.commons.Remapper;

public class LorenzRemapper
extends Remapper {
    private final MappingSet mappings;
    private final InheritanceProvider inheritanceProvider;

    public LorenzRemapper(MappingSet mappings, InheritanceProvider inheritanceProvider) {
        this.mappings = mappings;
        this.inheritanceProvider = inheritanceProvider;
    }

    @Override
    public String map(String typeName) {
        return this.mappings.computeClassMapping(typeName).map(Mapping::getFullDeobfuscatedName).orElse(typeName);
    }

    @Override
    public String mapInnerClassName(String name2, String ownerName, String innerName) {
        return this.mappings.computeClassMapping(name2).map(Mapping::getDeobfuscatedName).orElse(innerName);
    }

    private ClassMapping<?, ?> getCompletedClassMapping(String owner) {
        ClassMapping<?, ?> mapping = this.mappings.getOrCreateClassMapping(owner);
        mapping.complete(this.inheritanceProvider);
        return mapping;
    }

    @Override
    public String mapFieldName(String owner, String name2, String desc) {
        return this.getCompletedClassMapping(owner).computeFieldMapping(FieldSignature.of(name2, desc)).map(Mapping::getDeobfuscatedName).orElse(name2);
    }

    @Override
    public String mapMethodName(String owner, String name2, String desc) {
        return this.getCompletedClassMapping(owner).getMethodMapping(MethodSignature.of(name2, desc)).map(Mapping::getDeobfuscatedName).orElse(name2);
    }
}

