/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.lorenz.io.srg.tsrg;

import java.io.Reader;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.io.TextMappingsReader;
import paper.libs.org.cadixdev.lorenz.io.srg.SrgConstants;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;

public class TSrgReader
extends TextMappingsReader {
    public TSrgReader(Reader reader) {
        super(reader, Processor::new);
    }

    public static class Processor
    extends TextMappingsReader.Processor {
        private static final int CLASS_MAPPING_ELEMENT_COUNT = 2;
        private static final int FIELD_MAPPING_ELEMENT_COUNT = 2;
        private static final int METHOD_MAPPING_ELEMENT_COUNT = 3;
        private ClassMapping currentClass;

        public Processor(MappingSet mappings) {
            super(mappings);
        }

        public Processor() {
            this(MappingSet.create());
        }

        @Override
        public void accept(String rawLine) {
            String line = SrgConstants.removeComments(rawLine);
            if (line.isEmpty()) {
                return;
            }
            if (line.length() < 3) {
                throw new IllegalArgumentException("Faulty TSRG mapping encountered: `" + line + "`!");
            }
            String[] split = SPACE.split(line);
            int len = split.length;
            if (!split[0].startsWith("\t") && len == 2) {
                String obfuscatedName = split[0];
                String deobfuscatedName = split[1];
                if (!obfuscatedName.endsWith("/")) {
                    this.currentClass = this.mappings.getOrCreateClassMapping(obfuscatedName);
                    this.currentClass.setDeobfuscatedName(deobfuscatedName);
                }
            } else if (split[0].startsWith("\t") && this.currentClass != null) {
                String obfuscatedName = split[0].replace("\t", "");
                if (len == 2) {
                    String deobfuscatedName = split[1];
                    this.currentClass.getOrCreateFieldMapping(obfuscatedName).setDeobfuscatedName(deobfuscatedName);
                } else if (len == 3) {
                    String obfuscatedSignature = split[1];
                    String deobfuscatedName = split[2];
                    this.currentClass.getOrCreateMethodMapping(obfuscatedName, obfuscatedSignature).setDeobfuscatedName(deobfuscatedName);
                }
            } else {
                throw new IllegalArgumentException("Failed to process line: `" + line + "`!");
            }
        }
    }
}

