/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.GraphTests;
import paper.libs.org.jgrapht.Graphs;
import paper.libs.org.jgrapht.alg.shortestpath.GraphMeasurer;
import paper.libs.org.jgrapht.alg.util.NeighborCache;
import paper.libs.org.jgrapht.util.CollectionUtil;

public abstract class GraphMetrics {
    public static <V, E> double getDiameter(Graph<V, E> graph) {
        return new GraphMeasurer<V, E>(graph).getDiameter();
    }

    public static <V, E> double getRadius(Graph<V, E> graph) {
        return new GraphMeasurer<V, E>(graph).getRadius();
    }

    public static <V, E> int getGirth(Graph<V, E> graph) {
        int NIL = -1;
        boolean isAllowingMultipleEdges = graph.getType().isAllowingMultipleEdges();
        ArrayList<V> vertices = new ArrayList<V>(graph.vertexSet());
        HashMap indexMap = new HashMap();
        for (int i2 = 0; i2 < vertices.size(); ++i2) {
            indexMap.put(vertices.get(i2), i2);
        }
        int girth = Integer.MAX_VALUE;
        int[] depth = new int[vertices.size()];
        LinkedList<Object> queue2 = new LinkedList<Object>();
        if (graph.getType().isAllowingSelfLoops()) {
            for (Object v : vertices) {
                if (!graph.containsEdge(v, v)) continue;
                return 1;
            }
        }
        NeighborCache neighborIndex = new NeighborCache(graph);
        if (graph.getType().isUndirected()) {
            int[] parent = new int[vertices.size()];
            for (int i3 = 0; i3 < vertices.size() - 2 && girth > 3; ++i3) {
                int depthU;
                Arrays.fill(depth, -1);
                Arrays.fill(parent, -1);
                queue2.clear();
                depth[i3] = 0;
                queue2.add(vertices.get(i3));
                do {
                    Object u = queue2.poll();
                    int indexU = (Integer)indexMap.get(u);
                    depthU = depth[indexU];
                    for (V v : neighborIndex.neighborsOf(u)) {
                        int indexV = (Integer)indexMap.get(v);
                        if (parent[indexU] == indexV && (!isAllowingMultipleEdges || graph.getAllEdges(u, v).size() == 1)) continue;
                        int depthV = depth[indexV];
                        if (depthV == -1) {
                            queue2.add(v);
                            depth[indexV] = depthU + 1;
                            parent[indexV] = indexU;
                            continue;
                        }
                        girth = Math.min(girth, depthU + depthV + 1);
                    }
                } while (!queue2.isEmpty() && 2 * (depthU + 1) - 1 < girth);
            }
        } else {
            for (int i4 = 0; i4 < vertices.size() - 1 && girth > 2; ++i4) {
                int depthU;
                Arrays.fill(depth, -1);
                queue2.clear();
                depth[i4] = 0;
                queue2.add(vertices.get(i4));
                do {
                    Object u = queue2.poll();
                    int indexU = (Integer)indexMap.get(u);
                    depthU = depth[indexU];
                    for (V v : neighborIndex.successorsOf(u)) {
                        int indexV = (Integer)indexMap.get(v);
                        int depthV = depth[indexV];
                        if (depthV == -1) {
                            queue2.add(v);
                            depth[indexV] = depthU + 1;
                            continue;
                        }
                        if (depthV != 0) continue;
                        girth = Math.min(girth, depthU + depthV + 1);
                    }
                } while (!queue2.isEmpty() && depthU + 1 < girth);
            }
        }
        assert (graph.getType().isUndirected() && graph.getType().isSimple() && girth >= 3 || graph.getType().isAllowingSelfLoops() && girth >= 1 || girth >= 2 && (graph.getType().isDirected() || graph.getType().isAllowingMultipleEdges()));
        return girth;
    }

    static <V, E> long naiveCountTriangles(Graph<V, E> graph, List<V> vertexSubset) {
        long total = 0L;
        for (int i2 = 0; i2 < vertexSubset.size(); ++i2) {
            for (int j = i2 + 1; j < vertexSubset.size(); ++j) {
                for (int k = j + 1; k < vertexSubset.size(); ++k) {
                    V u = vertexSubset.get(i2);
                    V v = vertexSubset.get(j);
                    V w = vertexSubset.get(k);
                    if (!graph.containsEdge(u, v) || !graph.containsEdge(v, w) || !graph.containsEdge(w, u)) continue;
                    ++total;
                }
            }
        }
        return total;
    }

    public static <V, E> long getNumberOfTriangles(Graph<V, E> graph) {
        GraphTests.requireUndirected(graph);
        int sqrtV = (int)Math.sqrt(graph.vertexSet().size());
        ArrayList<V> vertexList = new ArrayList<V>(graph.vertexSet());
        HashMap<V, Integer> vertexOrder = CollectionUtil.newHashMapWithExpectedSize(graph.vertexSet().size());
        int k = 0;
        for (V v : graph.vertexSet()) {
            vertexOrder.put(v, k++);
        }
        Comparator<Object> comparator2 = Comparator.comparingInt(graph::degreeOf).thenComparingInt(System::identityHashCode).thenComparingInt(vertexOrder::get);
        vertexList.sort(comparator2);
        List heavyHitterVertices = vertexList.stream().filter(x -> graph.degreeOf(x) >= sqrtV).collect(Collectors.toCollection(ArrayList::new));
        long numberTriangles = GraphMetrics.naiveCountTriangles(graph, heavyHitterVertices);
        for (E edge : graph.edgeSet()) {
            V v2;
            V v1 = graph.getEdgeSource(edge);
            if (v1 == (v2 = graph.getEdgeTarget(edge)) || graph.degreeOf(v1) >= sqrtV && graph.degreeOf(v2) >= sqrtV) continue;
            if (comparator2.compare(v1, v2) > 0) {
                V tmp = v1;
                v1 = v2;
                v2 = tmp;
            }
            for (E e : graph.edgesOf(v1)) {
                V u = Graphs.getOppositeVertex(graph, e, v1);
                if (u == v1 || u == v2 || comparator2.compare(v2, u) > 0 || !graph.containsEdge(u, v2)) continue;
                ++numberTriangles;
            }
        }
        return numberTriangles;
    }
}

