/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.alg;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Set;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.GraphTests;

public class TransitiveReduction {
    public static final TransitiveReduction INSTANCE = new TransitiveReduction();

    private TransitiveReduction() {
    }

    static void transformToPathMatrix(BitSet[] matrix) {
        for (int i2 = 0; i2 < matrix.length; ++i2) {
            for (int j = 0; j < matrix.length; ++j) {
                if (i2 == j || !matrix[j].get(i2)) continue;
                for (int k = 0; k < matrix.length; ++k) {
                    if (matrix[j].get(k)) continue;
                    matrix[j].set(k, matrix[i2].get(k));
                }
            }
        }
    }

    static void transitiveReduction(BitSet[] pathMatrix) {
        for (int j = 0; j < pathMatrix.length; ++j) {
            for (int i2 = 0; i2 < pathMatrix.length; ++i2) {
                if (!pathMatrix[i2].get(j)) continue;
                for (int k = 0; k < pathMatrix.length; ++k) {
                    if (!pathMatrix[j].get(k)) continue;
                    pathMatrix[i2].set(k, false);
                }
            }
        }
    }

    public <V, E> void reduce(Graph<V, E> directedGraph) {
        GraphTests.requireDirected(directedGraph, "Graph must be directed");
        ArrayList<V> vertices = new ArrayList<V>(directedGraph.vertexSet());
        int n = vertices.size();
        BitSet[] originalMatrix = new BitSet[n];
        for (int i2 = 0; i2 < originalMatrix.length; ++i2) {
            originalMatrix[i2] = new BitSet(n);
        }
        Set<E> edges = directedGraph.edgeSet();
        for (E edge : edges) {
            V v1 = directedGraph.getEdgeSource(edge);
            V v2 = directedGraph.getEdgeTarget(edge);
            int v_1 = vertices.indexOf(v1);
            int v_2 = vertices.indexOf(v2);
            originalMatrix[v_1].set(v_2);
        }
        BitSet[] pathMatrix = originalMatrix;
        TransitiveReduction.transformToPathMatrix(pathMatrix);
        BitSet[] transitivelyReducedMatrix = pathMatrix;
        TransitiveReduction.transitiveReduction(transitivelyReducedMatrix);
        for (int i3 = 0; i3 < n; ++i3) {
            for (int j = 0; j < n; ++j) {
                if (transitivelyReducedMatrix[i3].get(j)) continue;
                directedGraph.removeEdge(directedGraph.getEdge(vertices.get(i3), vertices.get(j)));
            }
        }
    }
}

