/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.alg.clique;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.GraphTests;
import paper.libs.org.jgrapht.Graphs;
import paper.libs.org.jgrapht.alg.clique.PivotBronKerboschCliqueFinder;
import paper.libs.org.jgrapht.traverse.DegeneracyOrderingIterator;

public class DegeneracyBronKerboschCliqueFinder<V, E>
extends PivotBronKerboschCliqueFinder<V, E> {
    public DegeneracyBronKerboschCliqueFinder(Graph<V, E> graph) {
        this(graph, 0L, TimeUnit.SECONDS);
    }

    public DegeneracyBronKerboschCliqueFinder(Graph<V, E> graph, long timeout, TimeUnit unit) {
        super(graph, timeout, unit);
    }

    @Override
    protected void lazyRun() {
        if (this.allMaximalCliques == null) {
            long nanosTimeLimit;
            if (!GraphTests.isSimple(this.graph)) {
                throw new IllegalArgumentException("Graph must be simple");
            }
            this.allMaximalCliques = new ArrayList();
            try {
                nanosTimeLimit = Math.addExact(System.nanoTime(), this.nanos);
            }
            catch (ArithmeticException ignore) {
                nanosTimeLimit = Long.MAX_VALUE;
            }
            ArrayList ordering = new ArrayList();
            new DegeneracyOrderingIterator(this.graph).forEachRemaining(ordering::add);
            int n = ordering.size();
            for (int i2 = 0; i2 < n; ++i2) {
                Object vi = ordering.get(i2);
                HashSet viNeighbors = new HashSet();
                for (Object e : this.graph.edgesOf(vi)) {
                    viNeighbors.add(Graphs.getOppositeVertex(this.graph, e, vi));
                }
                HashSet P = new HashSet();
                for (int j = i2 + 1; j < n; ++j) {
                    Object vj = ordering.get(j);
                    if (!viNeighbors.contains(vj)) continue;
                    P.add(vj);
                }
                HashSet R = new HashSet();
                R.add(vi);
                HashSet X = new HashSet();
                for (int j = 0; j < i2; ++j) {
                    Object vj = ordering.get(j);
                    if (!viNeighbors.contains(vj)) continue;
                    X.add(vj);
                }
                this.findCliques(P, R, X, nanosTimeLimit);
            }
        }
    }
}

