/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.alg.cycle;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.Graphs;
import paper.libs.org.jgrapht.alg.cycle.AbstractFundamentalCycleBasis;

public class QueueBFSFundamentalCycleBasis<V, E>
extends AbstractFundamentalCycleBasis<V, E> {
    public QueueBFSFundamentalCycleBasis(Graph<V, E> graph) {
        super(graph);
    }

    @Override
    protected Map<V, E> computeSpanningForest() {
        HashMap pred = new HashMap();
        ArrayDeque<Object> queue2 = new ArrayDeque<Object>();
        for (Object s : this.graph.vertexSet()) {
            if (pred.containsKey(s)) continue;
            pred.put(s, null);
            queue2.addLast(s);
            while (!queue2.isEmpty()) {
                Object v = queue2.removeFirst();
                for (Object e : this.graph.edgesOf(v)) {
                    Object u = Graphs.getOppositeVertex(this.graph, e, v);
                    if (pred.containsKey(u)) continue;
                    pred.put(u, e);
                    queue2.addLast(u);
                }
            }
        }
        return pred;
    }
}

