/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.alg.matching.blossom.v5;

import paper.libs.org.jgrapht.alg.matching.blossom.v5.BlossomVEdge;
import paper.libs.org.jgrapht.alg.matching.blossom.v5.BlossomVTree;
import paper.libs.org.jheaps.MergeableAddressableHeap;
import paper.libs.org.jheaps.tree.PairingHeap;

class BlossomVTreeEdge {
    BlossomVTree[] head = new BlossomVTree[2];
    BlossomVTreeEdge[] prev = new BlossomVTreeEdge[2];
    BlossomVTreeEdge[] next = new BlossomVTreeEdge[2];
    MergeableAddressableHeap<Double, BlossomVEdge> plusPlusEdges = new PairingHeap<Double, BlossomVEdge>();
    MergeableAddressableHeap<Double, BlossomVEdge> plusMinusEdges0 = new PairingHeap<Double, BlossomVEdge>();
    MergeableAddressableHeap<Double, BlossomVEdge> plusMinusEdges1 = new PairingHeap<Double, BlossomVEdge>();

    public void removeFromTreeEdgeList() {
        for (int dir2 = 0; dir2 < 2; ++dir2) {
            if (this.prev[dir2] != null) {
                this.prev[dir2].next[dir2] = this.next[dir2];
            } else {
                this.head[1 - dir2].first[dir2] = this.next[dir2];
            }
            if (this.next[dir2] == null) continue;
            this.next[dir2].prev[dir2] = this.prev[dir2];
        }
        this.head[1] = null;
        this.head[0] = null;
    }

    public String toString() {
        return "BlossomVTreeEdge (" + this.head[0].id + ":" + this.head[1].id + ")";
    }

    public void addToCurrentMinusPlusHeap(BlossomVEdge edge, int direction) {
        edge.handle = this.getCurrentMinusPlusHeap(direction).insert(edge.slack, edge);
    }

    public void addToCurrentPlusMinusHeap(BlossomVEdge edge, int direction) {
        edge.handle = this.getCurrentPlusMinusHeap(direction).insert(edge.slack, edge);
    }

    public void addPlusPlusEdge(BlossomVEdge edge) {
        edge.handle = this.plusPlusEdges.insert(edge.slack, edge);
    }

    public void removeFromCurrentMinusPlusHeap(BlossomVEdge edge) {
        edge.handle.delete();
        edge.handle = null;
    }

    public void removeFromCurrentPlusMinusHeap(BlossomVEdge edge) {
        edge.handle.delete();
        edge.handle = null;
    }

    public void removeFromPlusPlusHeap(BlossomVEdge edge) {
        edge.handle.delete();
        edge.handle = null;
    }

    public MergeableAddressableHeap<Double, BlossomVEdge> getCurrentMinusPlusHeap(int currentDir) {
        return currentDir == 0 ? this.plusMinusEdges0 : this.plusMinusEdges1;
    }

    public MergeableAddressableHeap<Double, BlossomVEdge> getCurrentPlusMinusHeap(int currentDir) {
        return currentDir == 0 ? this.plusMinusEdges1 : this.plusMinusEdges0;
    }
}

