/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.alg.shortestpath;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.GraphPath;
import paper.libs.org.jgrapht.alg.interfaces.KShortestPathAlgorithm;
import paper.libs.org.jgrapht.alg.shortestpath.YenShortestPathIterator;
import paper.libs.org.jheaps.AddressableHeap;

public class YenKShortestPath<V, E>
implements KShortestPathAlgorithm<V, E> {
    private final Graph<V, E> graph;

    public YenKShortestPath(Graph<V, E> graph) {
        this.graph = Objects.requireNonNull(graph, "Graph cannot be null!");
    }

    @Override
    public List<GraphPath<V, E>> getPaths(V source, V sink, int k) {
        if (k < 0) {
            throw new IllegalArgumentException("k should be positive");
        }
        ArrayList<GraphPath<V, Object>> result2 = new ArrayList<GraphPath<V, Object>>();
        YenShortestPathIterator<V, E> iterator = new YenShortestPathIterator<V, E>(this.graph, source, sink);
        for (int i2 = 0; i2 < k && iterator.hasNext(); ++i2) {
            int amountOfPathLeft = k - i2;
            if (iterator.getNumberOfCandidatesWithMinimumWeight() == amountOfPathLeft) {
                AddressableHeap<Double, GraphPath<V, E>> candidates = iterator.getCandidatePaths();
                for (int j = 0; j < amountOfPathLeft; ++j) {
                    result2.add(candidates.deleteMin().getValue());
                }
                break;
            }
            result2.add((GraphPath<V, Object>)iterator.next());
        }
        return result2;
    }
}

