/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.generate;

import java.util.ArrayList;
import java.util.Map;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.GraphTests;
import paper.libs.org.jgrapht.generate.GraphGenerator;

public class CompleteGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private final int size;

    public CompleteGraphGenerator(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        this.size = size;
    }

    public CompleteGraphGenerator() {
        this.size = 0;
    }

    @Override
    public void generateGraph(Graph<V, E> target, Map<String, V> resultMap) {
        GraphTests.requireDirectedOrUndirected(target);
        boolean isDirected = target.getType().isDirected();
        for (int i2 = 0; i2 < this.size; ++i2) {
            target.addVertex();
        }
        ArrayList<V> nodes = new ArrayList<V>(target.vertexSet());
        for (int i3 = 0; i3 < nodes.size(); ++i3) {
            for (int j = i3 + 1; j < nodes.size(); ++j) {
                Object v = nodes.get(i3);
                Object u = nodes.get(j);
                target.addEdge(v, u);
                if (!isDirected) continue;
                target.addEdge(u, v);
            }
        }
    }
}

