/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.generate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.generate.GraphGenerator;

public class GeneralizedPetersenGraphGenerator<V, E>
implements GraphGenerator<V, E, List<V>> {
    private final int n;
    private final int k;
    public final String STAR = "star";
    public final String REGULAR = "regular";

    public GeneralizedPetersenGraphGenerator(int n, int k) {
        if (n < 3) {
            throw new IllegalArgumentException("n must be larger or equal than 3");
        }
        if (k < 1 || (double)k > Math.floor((double)(n - 1) / 2.0)) {
            throw new IllegalArgumentException("k must be in the range [1, floor((n-1)/2.0)]");
        }
        this.n = n;
        this.k = k;
    }

    @Override
    public void generateGraph(Graph<V, E> target, Map<String, List<V>> resultMap) {
        int i2;
        ArrayList<V> verticesU = new ArrayList<V>(this.n);
        ArrayList<V> verticesV = new ArrayList<V>(this.n);
        for (i2 = 0; i2 < this.n; ++i2) {
            verticesU.add(target.addVertex());
            verticesV.add(target.addVertex());
        }
        for (i2 = 0; i2 < this.n; ++i2) {
            target.addEdge(verticesU.get(i2), verticesU.get((i2 + 1) % this.n));
            target.addEdge(verticesU.get(i2), verticesV.get(i2));
            target.addEdge(verticesV.get(i2), verticesV.get((i2 + this.k) % this.n));
        }
        if (resultMap != null) {
            resultMap.put("regular", verticesU);
            resultMap.put("star", verticesV);
        }
    }
}

