/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.traverse;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.GraphTests;
import paper.libs.org.jgrapht.Graphs;
import paper.libs.org.jgrapht.traverse.AbstractGraphIterator;
import paper.libs.org.jgrapht.util.ModifiableInteger;

public class TopologicalOrderIterator<V, E>
extends AbstractGraphIterator<V, E> {
    private static final String GRAPH_IS_NOT_A_DAG = "Graph is not a DAG";
    private Queue<V> queue;
    private Map<V, ModifiableInteger> inDegreeMap;
    private int remainingVertices;
    private V cur;

    public TopologicalOrderIterator(Graph<V, E> graph) {
        this(graph, null);
    }

    public TopologicalOrderIterator(Graph<V, E> graph, Comparator<V> comparator2) {
        super(graph);
        GraphTests.requireDirected(graph);
        this.queue = comparator2 == null ? new LinkedList<V>() : new PriorityQueue<V>(comparator2);
        this.inDegreeMap = new HashMap<V, ModifiableInteger>();
        for (V v : graph.vertexSet()) {
            int d = 0;
            for (E e : graph.incomingEdgesOf(v)) {
                V u = Graphs.getOppositeVertex(graph, e, v);
                if (v.equals(u)) {
                    throw new IllegalArgumentException(GRAPH_IS_NOT_A_DAG);
                }
                ++d;
            }
            this.inDegreeMap.put((ModifiableInteger)v, new ModifiableInteger(d));
            if (d != 0) continue;
            this.queue.offer(v);
        }
        this.remainingVertices = graph.vertexSet().size();
    }

    @Override
    public boolean isCrossComponentTraversal() {
        return true;
    }

    @Override
    public void setCrossComponentTraversal(boolean crossComponentTraversal) {
        if (!crossComponentTraversal) {
            throw new IllegalArgumentException("Iterator is always cross-component");
        }
    }

    @Override
    public boolean hasNext() {
        if (this.cur != null) {
            return true;
        }
        this.cur = this.advance();
        if (this.cur != null && this.nListeners != 0) {
            this.fireVertexTraversed(this.createVertexTraversalEvent(this.cur));
        }
        return this.cur != null;
    }

    @Override
    public V next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        V result2 = this.cur;
        this.cur = null;
        if (this.nListeners != 0) {
            this.fireVertexFinished(this.createVertexTraversalEvent(result2));
        }
        return result2;
    }

    private V advance() {
        V result2 = this.queue.poll();
        if (result2 != null) {
            for (Object e : this.graph.outgoingEdgesOf(result2)) {
                V other = Graphs.getOppositeVertex(this.graph, e, result2);
                ModifiableInteger inDegree = this.inDegreeMap.get(other);
                if (inDegree.value <= 0) continue;
                --inDegree.value;
                if (inDegree.value != 0) continue;
                this.queue.offer(other);
            }
            --this.remainingVertices;
        } else if (this.remainingVertices > 0) {
            throw new IllegalArgumentException(GRAPH_IS_NOT_A_DAG);
        }
        return result2;
    }
}

