/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.tukaani.xz;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import paper.libs.org.tukaani.xz.CountingOutputStream;
import paper.libs.org.tukaani.xz.FilterEncoder;
import paper.libs.org.tukaani.xz.FinishableOutputStream;
import paper.libs.org.tukaani.xz.UnsupportedOptionsException;
import paper.libs.org.tukaani.xz.XZIOException;
import paper.libs.org.tukaani.xz.check.Check;
import paper.libs.org.tukaani.xz.common.EncoderUtil;

class BlockOutputStream
extends FinishableOutputStream {
    private final OutputStream out;
    private final CountingOutputStream outCounted;
    private FinishableOutputStream filterChain;
    private final Check check;
    private final int headerSize;
    private final long compressedSizeLimit;
    private long uncompressedSize = 0L;

    public BlockOutputStream(OutputStream outputStream, FilterEncoder[] filterEncoderArray, Check check) throws IOException {
        this.out = outputStream;
        this.check = check;
        this.outCounted = new CountingOutputStream(outputStream);
        this.filterChain = this.outCounted;
        for (int j = filterEncoderArray.length - 1; j >= 0; --j) {
            this.filterChain = filterEncoderArray[j].getOutputStream(this.filterChain);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(0);
        byteArrayOutputStream.write(filterEncoderArray.length - 1);
        for (int j = 0; j < filterEncoderArray.length; ++j) {
            EncoderUtil.encodeVLI(byteArrayOutputStream, filterEncoderArray[j].getFilterID());
            byte[] byArray2 = filterEncoderArray[j].getFilterProps();
            EncoderUtil.encodeVLI(byteArrayOutputStream, byArray2.length);
            byteArrayOutputStream.write(byArray2);
        }
        while ((byteArrayOutputStream.size() & 3) != 0) {
            byteArrayOutputStream.write(0);
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        this.headerSize = byArray3.length + 4;
        if (this.headerSize > 1024) {
            throw new UnsupportedOptionsException();
        }
        byArray3[0] = (byte)(byArray3.length / 4);
        outputStream.write(byArray3);
        EncoderUtil.writeCRC32(outputStream, byArray3);
        this.compressedSizeLimit = 0x7FFFFFFFFFFFFFFCL - (long)this.headerSize - (long)check.getSize();
    }

    public void write(int n) throws IOException {
        byte[] byArray2 = new byte[]{(byte)n};
        this.write(byArray2, 0, 1);
    }

    public void write(byte[] byArray2, int n, int n2) throws IOException {
        this.filterChain.write(byArray2, n, n2);
        this.check.update(byArray2, n, n2);
        this.uncompressedSize += (long)n2;
        this.validate();
    }

    public void flush() throws IOException {
        this.filterChain.flush();
        this.validate();
    }

    public void finish() throws IOException {
        this.filterChain.finish();
        this.validate();
        long l = this.outCounted.getSize();
        while ((l & 3L) != 0L) {
            this.out.write(0);
            ++l;
        }
        this.out.write(this.check.finish());
    }

    private void validate() throws IOException {
        long l = this.outCounted.getSize();
        if (l < 0L || l > this.compressedSizeLimit || this.uncompressedSize < 0L) {
            throw new XZIOException("XZ Stream has grown too big");
        }
    }

    public long getUnpaddedSize() {
        return (long)this.headerSize + this.outCounted.getSize() + (long)this.check.getSize();
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }
}

