/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.ZippedTask;
import io.papermc.paperweight.util.Command;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Git;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import paper.libs.org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u000f*\u00020\u0014H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\b\u00a8\u0006\u0015"}, d2={"Lio/papermc/paperweight/tasks/CloneRepo;", "Lio/papermc/paperweight/tasks/ZippedTask;", "<init>", "()V", "url", "Lorg/gradle/api/provider/Property;", "", "getUrl", "()Lorg/gradle/api/provider/Property;", "ref", "getRef", "shallowClone", "", "getShallowClone", "init", "", "run", "rootDir", "Ljava/nio/file/Path;", "fetch", "Lio/papermc/paperweight/util/Git;", "paperweight-lib"})
public abstract class CloneRepo
extends ZippedTask {
    @Input
    @NotNull
    public abstract Property<String> getUrl();

    @Input
    @NotNull
    public abstract Property<String> getRef();

    @Input
    @NotNull
    public abstract Property<Boolean> getShallowClone();

    @Override
    public void init() {
        super.init();
        this.getShallowClone().convention((Object)true);
    }

    @Override
    public void run(@NotNull Path rootDir) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Git.Companion.checkForGit();
        Object object = this.getUrl().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        String urlText = ((Object)StringsKt.trim((CharSequence)((String)object))).toString();
        String[] stringArray = rootDir.resolve(".git");
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"resolve(...)");
        String[] stringArray2 = stringArray;
        Object[] objectArray = new LinkOption[]{};
        if (Files.notExists((Path)stringArray2, Arrays.copyOf(objectArray, objectArray.length))) {
            FileKt.deleteRecursive$default(rootDir, null, null, 3, null);
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(rootDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            stringArray2 = new String[]{"init", "--quiet"};
            Command.executeSilently$default(new Git(rootDir, null, 2, null).invoke(stringArray2), false, false, 3, null);
        }
        Git git = new Git(rootDir, null, 2, null);
        objectArray = new String[]{"remote", "add", "origin", urlText};
        Command.executeSilently$default(git.invoke((String[])objectArray), false, true, 1, null);
        this.fetch(git);
        objectArray = new String[]{"checkout", "-f", "FETCH_HEAD"};
        Command.executeSilently$default(git.invoke((String[])objectArray), false, true, 1, null);
    }

    private final void fetch(Git $this$fetch) {
        if (((Boolean)this.getShallowClone().get()).booleanValue()) {
            String[] stringArray = new String[5];
            stringArray[0] = "fetch";
            stringArray[1] = "--depth";
            stringArray[2] = "1";
            stringArray[3] = "origin";
            Intrinsics.checkNotNullExpressionValue((Object)this.getRef().get(), (String)"get(...)");
            Command.executeSilently$default($this$fetch.invoke(stringArray), false, true, 1, null);
        } else {
            String[] stringArray = new String[3];
            stringArray[0] = "fetch";
            stringArray[1] = "origin";
            Intrinsics.checkNotNullExpressionValue((Object)this.getRef().get(), (String)"get(...)");
            Command.executeSilently$default($this$fetch.invoke(stringArray), false, true, 1, null);
        }
    }
}

